/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.cqengine.query.simple;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import com.googlecode.cqengine.query.support.QueryValidation;
import java.util.regex.Pattern;

public class StringMatchesRegex<O, A extends CharSequence>
extends SimpleQuery<O, A> {
    private final Pattern regexPattern;

    public StringMatchesRegex(Attribute<O, A> attribute, Pattern regexPattern) {
        super(attribute);
        this.regexPattern = QueryValidation.checkQueryValueNotNull(regexPattern);
    }

    @Override
    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        CharSequence attributeValue = (CharSequence)attribute.getValue(object, queryOptions);
        return this.matchesValue(attributeValue, queryOptions);
    }

    @Override
    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        for (CharSequence attributeValue : attribute.getValues(object, queryOptions)) {
            if (!this.matchesValue(attributeValue, queryOptions)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesValue(A aValue, QueryOptions queryOptions) {
        return this.regexPattern.matcher((CharSequence)aValue).matches();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringMatchesRegex)) {
            return false;
        }
        StringMatchesRegex that = (StringMatchesRegex)o;
        return this.attribute.equals(that.attribute) && this.regexPattern.pattern().equals(that.regexPattern.pattern()) && this.regexPattern.flags() == that.regexPattern.flags();
    }

    @Override
    protected int calcHashCode() {
        int result = this.attribute.hashCode();
        result = 31 * result + this.regexPattern.hashCode();
        return result;
    }

    public String toString() {
        return "matchesRegex(" + StringMatchesRegex.asLiteral(super.getAttributeName()) + ", " + StringMatchesRegex.asLiteral(this.regexPattern.pattern()) + ")";
    }
}

