/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.logging;

import java.util.ArrayDeque;
import java.util.Queue;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apereo.cas.logging.LoggingUtils;

@Plugin(name="CasAppender", category="Core", elementType="appender", printObject=true)
public class CasAppender
extends AbstractAppender {
    private final Configuration config;
    private final AppenderRef appenderRef;
    private final Queue<LogEvent> logEvents;
    private final int maxLogEntries;

    public CasAppender(String name, Configuration config, AppenderRef appenderRef, int maxEntries) {
        this(name, config, appenderRef, null, maxEntries);
    }

    public CasAppender(String name, Configuration config, AppenderRef appenderRef, Filter filter, int maxEntries) {
        super(name, filter, (Layout)PatternLayout.createDefaultLayout(), false, Property.EMPTY_ARRAY);
        this.config = config;
        this.appenderRef = appenderRef;
        this.maxLogEntries = maxEntries;
        this.logEvents = maxEntries <= 0 ? new ArrayDeque<LogEvent>() : new ArrayDeque(maxEntries);
    }

    @PluginFactory
    public static CasAppender build(@PluginAttribute(value="name") String name, @PluginElement(value="AppenderRef") AppenderRef appenderRef, @PluginElement(value="Filter") Filter filter, @PluginConfiguration Configuration config, @PluginAttribute(value="maxEntries") int maxEntries) {
        return new CasAppender(name, config, appenderRef, filter, maxEntries);
    }

    public void append(LogEvent logEvent) {
        String refName = this.appenderRef.getRef();
        if (StringUtils.isNotBlank((CharSequence)refName)) {
            Appender appender = this.config.getAppender(refName);
            if (appender != null) {
                LogEvent newLogEvent = LoggingUtils.prepareLogEvent(logEvent);
                appender.append(newLogEvent);
                if (this.maxLogEntries > 0) {
                    if (this.logEvents.size() >= this.maxLogEntries) {
                        this.logEvents.poll();
                    }
                    this.logEvents.add(newLogEvent.toImmutable());
                }
            } else {
                LOGGER.warn("No log appender could be found for [{}]", (Object)refName);
            }
        } else {
            LOGGER.warn("No log appender reference for [{}] could be located in logging configuration.", (Object)refName);
        }
    }

    @Generated
    public Queue<LogEvent> getLogEvents() {
        return this.logEvents;
    }
}

