/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.web.flow.actions;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.BasicIdentifiableCredential;
import org.apereo.cas.authentication.principal.NullPrincipal;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.email.EmailProperties;
import org.apereo.cas.multitenancy.TenantDefinition;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.mail.EmailCommunicationResult;
import org.apereo.cas.notifications.mail.EmailMessageBodyBuilder;
import org.apereo.cas.notifications.mail.EmailMessageRequest;
import org.apereo.cas.pm.PasswordManagementQuery;
import org.apereo.cas.pm.PasswordManagementService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.apereo.inspektr.audit.annotation.Audit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SendForgotUsernameInstructionsAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SendForgotUsernameInstructionsAction.class);
    public static final String REQUEST_PARAMETER_EMAIL = "email";
    protected final CasConfigurationProperties casProperties;
    protected final CommunicationsManager communicationsManager;
    protected final PasswordManagementService passwordManagementService;
    protected final PrincipalResolver principalResolver;
    protected final TenantExtractor tenantExtractor;

    @Audit(action="REQUEST_FORGOT_USERNAME", principalResolverName="REQUEST_FORGOT_USERNAME_PRINCIPAL_RESOLVER", actionResolverName="REQUEST_FORGOT_USERNAME_ACTION_RESOLVER", resourceResolverName="REQUEST_FORGOT_USERNAME_RESOURCE_RESOLVER")
    protected Event doExecuteInternal(RequestContext requestContext) {
        this.communicationsManager.validate();
        if (!this.communicationsManager.isMailSenderDefined()) {
            return this.getErrorEvent("email.failed", "Unable to send email as no mail sender is defined", requestContext);
        }
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        String email = request.getParameter(REQUEST_PARAMETER_EMAIL);
        if (StringUtils.isBlank((CharSequence)email)) {
            return this.getErrorEvent("email.required", "No email is provided", requestContext);
        }
        if (!EmailValidator.getInstance().isValid(email)) {
            return this.getErrorEvent("email.invalid", "Provided email address is invalid", requestContext);
        }
        return (Event)FunctionUtils.doUnchecked(() -> {
            PasswordManagementQuery query = PasswordManagementQuery.builder().email(email).build();
            String username = this.passwordManagementService.findUsername(query);
            if (StringUtils.isBlank((CharSequence)username)) {
                return this.getErrorEvent("username.missing", "No username could be located for the given email address", requestContext);
            }
            query = PasswordManagementQuery.builder().username(username).email(email).build();
            return this.locateUserAndProcess(requestContext, query);
        });
    }

    protected Event locateUserAndProcess(RequestContext requestContext, PasswordManagementQuery query) throws Throwable {
        EmailCommunicationResult result = this.sendForgotUsernameEmailToAccount(query, requestContext);
        return (Event)FunctionUtils.doIf((boolean)result.isSuccess(), () -> this.success(result), () -> this.getErrorEvent("username.failed", "Cannot send the username to given email address", requestContext)).get();
    }

    protected EmailCommunicationResult sendForgotUsernameEmailToAccount(PasswordManagementQuery query, RequestContext requestContext) throws Throwable {
        Map parameters = CollectionUtils.wrap((String)"username", (Object)query.getUsername(), (String)REQUEST_PARAMETER_EMAIL, (Object)query.getEmail());
        BasicIdentifiableCredential credential = new BasicIdentifiableCredential();
        credential.setId(query.getUsername());
        Principal person = this.principalResolver.resolve((Credential)credential);
        FunctionUtils.doIf((person != null && !person.getClass().equals(NullPrincipal.class) ? 1 : 0) != 0, principal -> {
            parameters.put("principal", principal);
            requestContext.getFlashScope().put(Principal.class.getName(), (Object)person);
        }).accept(person);
        EmailProperties reset = this.casProperties.getAuthn().getPm().getForgotUsername().getMail();
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
        Optional<Locale> locale = Optional.ofNullable(RequestContextUtils.getLocaleResolver((HttpServletRequest)request)).map(resolver -> resolver.resolveLocale(request));
        String body = EmailMessageBodyBuilder.builder().properties(reset).locale(locale).parameters(parameters).build().get();
        EmailMessageRequest emailRequest = EmailMessageRequest.builder().emailProperties(reset).locale(locale.orElseGet(Locale::getDefault)).to(List.of(query.getEmail())).tenant(this.tenantExtractor.extract(requestContext).map(TenantDefinition::getId).orElse("")).body(body).build();
        return this.communicationsManager.email(emailRequest);
    }

    protected Event getErrorEvent(String code, String defaultMessage, RequestContext requestContext) {
        WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)("screen.pm.forgotusername." + code), (String)defaultMessage);
        LOGGER.error(defaultMessage);
        return new EventFactorySupport().event((Object)this, "error");
    }

    @Generated
    public SendForgotUsernameInstructionsAction(CasConfigurationProperties casProperties, CommunicationsManager communicationsManager, PasswordManagementService passwordManagementService, PrincipalResolver principalResolver, TenantExtractor tenantExtractor) {
        this.casProperties = casProperties;
        this.communicationsManager = communicationsManager;
        this.passwordManagementService = passwordManagementService;
        this.principalResolver = principalResolver;
        this.tenantExtractor = tenantExtractor;
    }
}

