/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.EventPayload;
import org.flowable.eventsubscription.service.EventSubscriptionService;

public abstract class AbstractProcessStartEventSubscriptionCmd {
    protected String generateCorrelationConfiguration(String eventDefinitionKey, String tenantId, Map<String, Object> correlationParameterValues, CommandContext commandContext) {
        EventModel eventModel = this.getEventModel(eventDefinitionKey, tenantId, commandContext);
        HashMap<String, Object> correlationParameters = new HashMap<String, Object>();
        for (Map.Entry<String, Object> correlationValue : correlationParameterValues.entrySet()) {
            this.checkEventModelCorrelationParameter(eventModel, correlationValue.getKey());
            correlationParameters.put(correlationValue.getKey(), correlationValue.getValue());
        }
        return CommandContextUtil.getEventRegistry().generateKey(correlationParameters);
    }

    protected void checkEventModelCorrelationParameter(EventModel eventModel, String correlationParameterName) {
        Collection correlationParameters = eventModel.getCorrelationParameters();
        for (EventPayload correlationParameter : correlationParameters) {
            if (!correlationParameter.getName().equals(correlationParameterName)) continue;
            return;
        }
        throw new FlowableIllegalArgumentException("There is no correlation parameter with name '" + correlationParameterName + "' defined in event model with key '" + eventModel.getKey() + "'. You can only subscribe for an event with a combination of valid correlation parameters.");
    }

    protected ProcessDefinition getLatestProcessDefinitionByKey(String processDefinitionKey, String tenantId, CommandContext commandContext) {
        ProcessDefinitionEntityManager processDefinitionEntityManager = CommandContextUtil.getProcessDefinitionEntityManager(commandContext);
        ProcessDefinitionEntity processDefinition = null;
        if (processDefinitionKey != null && (tenantId == null || "".equals(tenantId))) {
            processDefinition = processDefinitionEntityManager.findLatestProcessDefinitionByKey(processDefinitionKey);
            if (processDefinition == null) {
                throw new FlowableObjectNotFoundException("No process definition found for key '" + processDefinitionKey + "'", ProcessDefinition.class);
            }
        } else if (processDefinitionKey != null && tenantId != null && !"".equals(tenantId) && (processDefinition = processDefinitionEntityManager.findLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId)) == null) {
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            if (processEngineConfiguration.isFallbackToDefaultTenant()) {
                String defaultTenant = processEngineConfiguration.getDefaultTenantProvider().getDefaultTenant(tenantId, "bpmn", processDefinitionKey);
                processDefinition = StringUtils.isNotEmpty((CharSequence)defaultTenant) ? processDefinitionEntityManager.findLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, defaultTenant) : processDefinitionEntityManager.findLatestProcessDefinitionByKey(processDefinitionKey);
                if (processDefinition == null) {
                    throw new FlowableObjectNotFoundException("No process definition found for key '" + processDefinitionKey + "'. Fallback to default tenant was also applied.", ProcessDefinition.class);
                }
            } else {
                throw new FlowableObjectNotFoundException("Process definition with key '" + processDefinitionKey + "' and tenantId '" + tenantId + "' was not found", ProcessDefinition.class);
            }
        }
        if (processDefinition == null) {
            throw new FlowableIllegalArgumentException("No deployed process definition found for key '" + processDefinitionKey + "'.");
        }
        return processDefinition;
    }

    protected ProcessDefinition getProcessDefinitionById(String processDefinitionId, CommandContext commandContext) {
        RepositoryService repositoryService = CommandContextUtil.getProcessEngineConfiguration(commandContext).getRepositoryService();
        ProcessDefinition processDefinition = (ProcessDefinition)repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        if (processDefinition == null) {
            throw new FlowableIllegalArgumentException("No deployed process definition found for id '" + processDefinitionId + "'.");
        }
        return processDefinition;
    }

    protected Process getProcess(String processDefinitionId, CommandContext commandContext) {
        RepositoryService repositoryService = CommandContextUtil.getProcessEngineConfiguration(commandContext).getRepositoryService();
        BpmnModel bpmnModel = repositoryService.getBpmnModel(processDefinitionId);
        return bpmnModel.getMainProcess();
    }

    protected EventModel getEventModel(String eventDefinitionKey, String tenantId, CommandContext commandContext) {
        EventModel eventModel = CommandContextUtil.getEventRepositoryService(commandContext).getEventModelByKey(eventDefinitionKey, tenantId);
        if (eventModel == null) {
            throw new FlowableIllegalArgumentException("Could not find event model with key '" + eventDefinitionKey + "'.");
        }
        return eventModel;
    }

    protected EventSubscriptionService getEventSubscriptionService(CommandContext commandContext) {
        return CommandContextUtil.getProcessEngineConfiguration(commandContext).getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
    }
}

