/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.jobexecutor;

import org.flowable.bpmn.model.FlowElement;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.BpmnLoggingSessionUtil;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.variable.api.delegate.VariableScope;

public class AsyncContinuationJobHandler
implements JobHandler {
    public static final String TYPE = "async-continuation";

    public String getType() {
        return TYPE;
    }

    public void execute(JobEntity job, String configuration, VariableScope variableScope, CommandContext commandContext) {
        ExecutionEntity executionEntity = (ExecutionEntity)variableScope;
        if (CommandContextUtil.getProcessEngineConfiguration(commandContext).isLoggingSessionEnabled()) {
            FlowElement flowElement = executionEntity.getCurrentFlowElement();
            BpmnLoggingSessionUtil.addAsyncActivityLoggingData("Executing async job for " + flowElement.getId() + ", with job id " + job.getId(), "serviceTaskExecuteAsyncJob", job, flowElement, executionEntity);
        }
        CommandContextUtil.getAgenda(commandContext).planContinueProcessSynchronousOperation(executionEntity);
    }
}

