/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.util.concurrent.batch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;

public class BatchHelper<T, R, CT, CR> {
    private static final Object NEED_TO_EXECUTE_NEXT_BATCH = new Object();
    private static final WaitingTask<?, ?> QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS = new WaitingTask(null);
    private static final WaitingTask<?, ?> QUEUE_EMPTY = new WaitingTask(null);
    private final Function<List<T>, CT> taskCombiner;
    private final Function<CT, CR> combinedTaskExecutor;
    private final Function<T, R> taskExecutor;
    private final BiFunction<CT, CR, List<R>> combinedResultSplitter;
    private final AtomicReference<WaitingTask> headReference = new AtomicReference(QUEUE_EMPTY);

    public static <T, R, CT, CR> BatchHelper<T, R, CT, CR> create(Function<List<T>, CT> taskCombiner, Function<CT, CR> combinedTaskExecutor, Function<T, R> taskExecutor, BiFunction<CT, CR, List<R>> combinedResultSplitter) {
        return new BatchHelper<T, R, CT, CR>(taskCombiner, combinedTaskExecutor, taskExecutor, combinedResultSplitter);
    }

    public static <T, R, CT, CR> BatchHelper<T, R, CT, CR> create(final Function<List<T>, CT> taskCombiner, final Function<CT, CR> combinedTaskExecutor, final BiFunction<CT, CR, List<R>> combinedResultSplitter) {
        Function taskExecutor = new Function<T, R>(){

            @Override
            public R apply(T task) {
                Object combinedTask = taskCombiner.apply(Collections.singletonList(task));
                Object combinedResult = combinedTaskExecutor.apply(combinedTask);
                List results = (List)combinedResultSplitter.apply(combinedTask, combinedResult);
                return results.get(0);
            }
        };
        return new BatchHelper<T, R, CT, CR>(taskCombiner, combinedTaskExecutor, taskExecutor, combinedResultSplitter);
    }

    private BatchHelper(Function<List<T>, CT> taskCombiner, Function<CT, CR> combinedTaskExecutor, Function<T, R> taskExecutor, BiFunction<CT, CR, List<R>> combinedResultSplitter) {
        this.taskCombiner = Objects.requireNonNull(taskCombiner);
        this.combinedTaskExecutor = Objects.requireNonNull(combinedTaskExecutor);
        this.taskExecutor = Objects.requireNonNull(taskExecutor);
        this.combinedResultSplitter = Objects.requireNonNull(combinedResultSplitter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public R execute(T task) {
        WaitingTask<T, R> waitingNode = this.lockExclusivelyOrEnqueue(task);
        if (waitingNode == null) {
            try {
                R r = this.taskExecutor.apply(task);
                return r;
            }
            finally {
                this.wakeupAnyThreadFromNextBatchOrFreeLock();
            }
        }
        R result = waitingNode.waitUninterruptedly();
        if (result != NEED_TO_EXECUTE_NEXT_BATCH) {
            return result;
        }
        try {
            R r = this.executeBatch(waitingNode);
            return r;
        }
        finally {
            this.wakeupAnyThreadFromNextBatchOrFreeLock();
        }
    }

    private R executeBatch(WaitingTask<T, R> currentWaitingNode) {
        List<WaitingTask<T, R>> waitingNodes = this.takeAllWaitingTasksOrFreeLock();
        if (waitingNodes.size() == 1) {
            Object singleCommand = waitingNodes.get((int)0).wrappedTask;
            return this.taskExecutor.apply(singleCommand);
        }
        try {
            int resultIndex = -1;
            ArrayList commandsInBatch = new ArrayList(waitingNodes.size());
            for (int i = 0; i < waitingNodes.size(); ++i) {
                WaitingTask<T, R> waitingNode = waitingNodes.get(i);
                commandsInBatch.add(waitingNode.wrappedTask);
                if (waitingNode != currentWaitingNode) continue;
                resultIndex = i;
            }
            CT multiCommand = this.taskCombiner.apply(commandsInBatch);
            CR multiResult = this.combinedTaskExecutor.apply(multiCommand);
            List<R> singleResults = this.combinedResultSplitter.apply(multiCommand, multiResult);
            for (int i = 0; i < waitingNodes.size(); ++i) {
                R singleResult = singleResults.get(i);
                waitingNodes.get((int)i).future.complete(singleResult);
            }
            return singleResults.get(resultIndex);
        }
        catch (Throwable e) {
            for (WaitingTask<T, R> waitingNode : waitingNodes) {
                waitingNode.future.completeExceptionally(e);
            }
            throw new BatchFailedException(e);
        }
    }

    private WaitingTask<T, R> lockExclusivelyOrEnqueue(T command) {
        WaitingTask currentTask = new WaitingTask(command);
        while (true) {
            WaitingTask previous;
            if ((previous = this.headReference.get()) == QUEUE_EMPTY) {
                if (!this.headReference.compareAndSet(previous, QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS)) continue;
                return null;
            }
            currentTask.previous = previous;
            if (this.headReference.compareAndSet(previous, currentTask)) {
                return currentTask;
            }
            currentTask.previous = null;
        }
    }

    private void wakeupAnyThreadFromNextBatchOrFreeLock() {
        WaitingTask previous;
        while ((previous = this.headReference.get()) == QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS) {
            if (!this.headReference.compareAndSet(QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS, QUEUE_EMPTY)) continue;
            return;
        }
        if (previous != QUEUE_EMPTY) {
            previous.future.complete(NEED_TO_EXECUTE_NEXT_BATCH);
            return;
        }
        String msg = "Detected illegal usage of API, wakeupAnyThreadFromNextBatchOrFreeLock should not be called on empty queue";
        throw new IllegalStateException(msg);
    }

    private List<WaitingTask<T, R>> takeAllWaitingTasksOrFreeLock() {
        WaitingTask head;
        while (true) {
            if ((head = this.headReference.get()) == QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS) {
                if (!this.headReference.compareAndSet(QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS, QUEUE_EMPTY)) continue;
                return Collections.emptyList();
            }
            if (this.headReference.compareAndSet(head, QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS)) break;
        }
        WaitingTask current = head;
        ArrayList<WaitingTask<T, R>> waitingNodes = new ArrayList<WaitingTask<T, R>>();
        while (current != QUEUE_EMPTY_BUT_EXECUTION_IN_PROGRESS) {
            waitingNodes.add(current);
            WaitingTask tmp = current.previous;
            current.previous = null;
            current = tmp;
        }
        Collections.reverse(waitingNodes);
        return waitingNodes;
    }

    public static class BatchFailedException
    extends IllegalStateException {
        public BatchFailedException(Throwable e) {
            super(e);
        }
    }

    private static class WaitingTask<T, R> {
        public final T wrappedTask;
        public final CompletableFuture<R> future = new CompletableFuture();
        public final Thread thread = Thread.currentThread();
        public WaitingTask<T, R> previous;

        WaitingTask(T task) {
            this.wrappedTask = task;
        }

        /*
         * Exception decompiling
         */
        public R waitUninterruptedly() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

