/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.service.DefaultConversionService;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.context.ApplicationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;
import org.springframework.validation.Validator;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.expression.spel.WebFlowSpringELExpressionParser;
import org.springframework.webflow.mvc.builder.MvcViewFactoryCreator;
import org.springframework.webflow.validation.ValidationHintResolver;

public class FlowBuilderServicesBuilder {
    private ConversionService conversionService = new DefaultConversionService();
    private ExpressionParser expressionParser;
    private ViewFactoryCreator viewFactoryCreator;
    private Validator validator;
    private ValidationHintResolver validationHintResolver;
    private boolean enableDevelopmentMode;

    public FlowBuilderServicesBuilder() {
        this.viewFactoryCreator = new MvcViewFactoryCreator();
    }

    public FlowBuilderServicesBuilder(ApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"applicationContext is required");
        this.viewFactoryCreator = new MvcViewFactoryCreator();
    }

    public FlowBuilderServicesBuilder setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
        return this;
    }

    public FlowBuilderServicesBuilder setExpressionParser(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
        return this;
    }

    public FlowBuilderServicesBuilder setViewFactoryCreator(ViewFactoryCreator viewFactoryCreator) {
        this.viewFactoryCreator = viewFactoryCreator;
        return this;
    }

    public FlowBuilderServicesBuilder setValidator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public FlowBuilderServicesBuilder setValidationHintResolver(ValidationHintResolver resolver) {
        this.validationHintResolver = resolver;
        return this;
    }

    public FlowBuilderServicesBuilder setDevelopmentMode(boolean enableDevelopmentMode) {
        this.enableDevelopmentMode = enableDevelopmentMode;
        return this;
    }

    public FlowBuilderServices build() {
        FlowBuilderServices flowBuilderServices = new FlowBuilderServices();
        flowBuilderServices.setConversionService(this.conversionService);
        flowBuilderServices.setExpressionParser(this.getExpressionParser());
        flowBuilderServices.setViewFactoryCreator(this.viewFactoryCreator);
        flowBuilderServices.setValidator(this.validator);
        flowBuilderServices.setValidationHintResolver(this.validationHintResolver);
        flowBuilderServices.setDevelopment(this.enableDevelopmentMode);
        return flowBuilderServices;
    }

    private ExpressionParser getExpressionParser() {
        if (this.expressionParser != null) {
            return this.expressionParser;
        }
        return new WebFlowSpringELExpressionParser(new SpelExpressionParser(), this.conversionService);
    }
}

