/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.MailTemplateTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.MailTemplateFormat;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.DuplicateException;
import org.apache.syncope.core.persistence.api.dao.MailTemplateDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.MailTemplate;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class MailTemplateLogic
extends AbstractTransactionalLogic<MailTemplateTO> {
    protected final MailTemplateDAO mailTemplateDAO;
    protected final NotificationDAO notificationDAO;
    protected final EntityFactory entityFactory;

    public MailTemplateLogic(MailTemplateDAO mailTemplateDAO, NotificationDAO notificationDAO, EntityFactory entityFactory) {
        this.mailTemplateDAO = mailTemplateDAO;
        this.notificationDAO = notificationDAO;
        this.entityFactory = entityFactory;
    }

    protected MailTemplateTO getMailTemplateTO(String key) {
        MailTemplateTO mailTemplateTO = new MailTemplateTO();
        mailTemplateTO.setKey(key);
        return mailTemplateTO;
    }

    @PreAuthorize(value="hasRole('MAIL_TEMPLATE_READ')")
    @Transactional(readOnly=true)
    public MailTemplateTO read(String key) {
        this.mailTemplateDAO.findById(key).orElseThrow(() -> new NotFoundException("MailTemplate " + key));
        return this.getMailTemplateTO(key);
    }

    @PreAuthorize(value="hasRole('MAIL_TEMPLATE_LIST')")
    @Transactional(readOnly=true)
    public List<MailTemplateTO> list() {
        return this.mailTemplateDAO.findAll().stream().map(template -> this.getMailTemplateTO(template.getKey())).toList();
    }

    @PreAuthorize(value="hasRole('MAIL_TEMPLATE_CREATE')")
    public MailTemplateTO create(String key) {
        if (this.mailTemplateDAO.existsById(key)) {
            throw new DuplicateException(key);
        }
        MailTemplate mailTemplate = (MailTemplate)this.entityFactory.newEntity(MailTemplate.class);
        mailTemplate.setKey(key);
        this.mailTemplateDAO.save((Entity)mailTemplate);
        return this.getMailTemplateTO(key);
    }

    @PreAuthorize(value="hasRole('MAIL_TEMPLATE_READ')")
    public String getFormat(String key, MailTemplateFormat format) {
        String template;
        MailTemplate mailTemplate = (MailTemplate)this.mailTemplateDAO.findById(key).orElseThrow(() -> new NotFoundException("MailTemplate " + key));
        String string = template = format == MailTemplateFormat.HTML ? mailTemplate.getHTMLTemplate() : mailTemplate.getTextTemplate();
        if (StringUtils.isBlank((CharSequence)template)) {
            LOG.error("Could not find mail template '{}' in {} format", (Object)key, (Object)format);
            throw new NotFoundException(key + " in " + String.valueOf(format));
        }
        return template;
    }

    @PreAuthorize(value="hasRole('MAIL_TEMPLATE_UPDATE')")
    public void setFormat(String key, MailTemplateFormat format, String template) {
        MailTemplate mailTemplate = (MailTemplate)this.mailTemplateDAO.findById(key).orElseThrow(() -> new NotFoundException("MailTemplate " + key));
        if (format == MailTemplateFormat.HTML) {
            mailTemplate.setHTMLTemplate(template);
        } else {
            mailTemplate.setTextTemplate(template);
        }
        this.mailTemplateDAO.save((Entity)mailTemplate);
    }

    @PreAuthorize(value="hasRole('MAIL_TEMPLATE_DELETE')")
    public MailTemplateTO delete(String key) {
        MailTemplate mailTemplate = (MailTemplate)this.mailTemplateDAO.findById(key).orElseThrow(() -> new NotFoundException("MailTemplate " + key));
        List notifications = this.notificationDAO.findByTemplate(mailTemplate);
        if (!notifications.isEmpty()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InUse);
            sce.getElements().addAll(notifications.stream().map(Entity::getKey).toList());
            throw sce;
        }
        MailTemplateTO deleted = this.getMailTemplateTO(key);
        this.mailTemplateDAO.deleteById(key);
        return deleted;
    }

    @Override
    protected MailTemplateTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                Object object = args[i];
                if (object instanceof String) {
                    String string;
                    key = string = (String)object;
                    continue;
                }
                object = args[i];
                if (!(object instanceof MailTemplateTO)) continue;
                MailTemplateTO mailTemplateTO = (MailTemplateTO)object;
                key = mailTemplateTO.getKey();
            }
        }
        if (key != null) {
            try {
                return this.getMailTemplateTO(key);
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

