/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.PlainSchemaCheck;

public class PlainSchemaValidator
extends AbstractValidator<PlainSchemaCheck, PlainSchema> {
    public boolean isValid(PlainSchema schema, ConstraintValidatorContext context) {
        switch (schema.getType()) {
            case Enum: {
                if (!schema.getEnumValues().isEmpty()) break;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(PlainSchemaValidator.getTemplate(EntityViolationType.InvalidSchema, "Enumeration values missing")).addPropertyNode("enumValues").addConstraintViolation();
                return false;
            }
            case Dropdown: {
                if (schema.getDropdownValueProvider() != null) break;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(PlainSchemaValidator.getTemplate(EntityViolationType.InvalidSchema, "DropdownValueProvider missing")).addPropertyNode("dropdownValueProvider").addConstraintViolation();
                return false;
            }
            case Encrypted: {
                if (schema.getSecretKey() != null && schema.getCipherAlgorithm() != null) break;
                context.disableDefaultConstraintViolation();
                context.buildConstraintViolationWithTemplate(PlainSchemaValidator.getTemplate(EntityViolationType.InvalidSchema, "SecretKey or CipherAlgorithm missing")).addPropertyNode("secretKey").addPropertyNode("cipherAlgorithm").addConstraintViolation();
                return false;
            }
        }
        if (schema.isMultivalue() && schema.isUniqueConstraint()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(PlainSchemaValidator.getTemplate(EntityViolationType.InvalidSchema, "Cannot be multivalue and have unique constraint at the same time")).addPropertyNode("multiValue").addConstraintViolation();
            return false;
        }
        return true;
    }
}

