/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.common.lib.types.SRARouteType;
import org.apache.syncope.core.persistence.api.entity.SRARoute;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.SRARouteCheck;

public class SRARouteValidator
extends AbstractValidator<SRARouteCheck, SRARoute> {
    public boolean isValid(SRARoute route, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean isValid = true;
        if (SRARouteValidator.isHtml(route.getName())) {
            context.buildConstraintViolationWithTemplate(SRARouteValidator.getTemplate(EntityViolationType.InvalidName, "Invalid name")).addPropertyNode("name").addConstraintViolation();
            isValid = false;
        }
        if (route.getType() == SRARouteType.PUBLIC && route.isLogout()) {
            context.buildConstraintViolationWithTemplate(SRARouteValidator.getTemplate(EntityViolationType.InvalidMapping, "Logout route cannot be public")).addPropertyNode("routeType").addConstraintViolation();
            isValid = false;
        }
        if (route.getPostLogout() != null && !route.isLogout()) {
            context.buildConstraintViolationWithTemplate(SRARouteValidator.getTemplate(EntityViolationType.InvalidMapping, "Can set postLogout only for logout routes")).addPropertyNode("postLogout").addConstraintViolation();
            isValid = false;
        }
        if (route.getPredicates().size() > 1 && route.getPredicates().stream().allMatch(predicate -> predicate.getCond() != null)) {
            context.buildConstraintViolationWithTemplate(SRARouteValidator.getTemplate(EntityViolationType.InvalidValueList, "Cond must be set when predicates are more than one")).addPropertyNode("predicates").addConstraintViolation();
            isValid = false;
        }
        return isValid;
    }
}

