/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.web.flow;

import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.bucket4j.consumer.BucketConsumer;
import org.apereo.cas.bucket4j.consumer.BucketConsumptionResult;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorAuthenticationProvider;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCommunicationStrategy;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCredential;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicket;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.action.EventFactorySupport;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class CasSimpleMultifactorUpdateEmailAction
extends AbstractMultifactorAuthenticationAction<CasSimpleMultifactorAuthenticationProvider> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasSimpleMultifactorUpdateEmailAction.class);
    private static final String ERROR_CODE_TOKEN_FAILED = "cas.mfa.simple.registration.token.failed";
    protected final CommunicationsManager communicationsManager;
    protected final CasSimpleMultifactorAuthenticationService multifactorAuthenticationService;
    protected final CasSimpleMultifactorAuthenticationProperties properties;
    protected final CasSimpleMultifactorTokenCommunicationStrategy tokenCommunicationStrategy;
    protected final BucketConsumer bucketConsumer;

    protected Event doPreExecute(RequestContext requestContext) throws Exception {
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        BucketConsumptionResult result = this.bucketConsumer.consume(this.getThrottledRequestKeyFor(authentication, requestContext));
        result.getHeaders().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1));
        return result.isConsumed() ? super.doPreExecute(requestContext) : this.error();
    }

    protected Event doExecuteInternal(RequestContext requestContext) throws Throwable {
        try {
            String token = requestContext.getRequestParameters().getRequired("token");
            CasSimpleMultifactorTokenCredential tokenCredential = new CasSimpleMultifactorTokenCredential(token);
            CasSimpleMultifactorAuthenticationTicket ticket = this.multifactorAuthenticationService.getMultifactorAuthenticationTicket(tokenCredential);
            Principal credentialPrincipal = this.multifactorAuthenticationService.getPrincipalFromTicket(ticket);
            Principal resolvedPrincipal = this.resolvePrincipal(credentialPrincipal, requestContext);
            String emailAddress = (String)ticket.getProperty("emailAddressToRegister", String.class);
            Principal principal = this.multifactorAuthenticationService.validate(resolvedPrincipal, tokenCredential);
            LOGGER.debug("Updating email address [{}] for [{}]", (Object)emailAddress, (Object)principal.getId());
            this.multifactorAuthenticationService.update(principal, Map.of("emailAddressToRegister", emailAddress));
            MultifactorAuthenticationWebflowUtils.removeSimpleMultifactorAuthenticationToken((RequestContext)requestContext);
            return new EventFactorySupport().event((Object)this, "resume", (AttributeMap)new LocalAttributeMap(Map.of("emailAddressToRegister", emailAddress)));
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)ERROR_CODE_TOKEN_FAILED);
            return this.error();
        }
    }

    @Generated
    public CasSimpleMultifactorUpdateEmailAction(CommunicationsManager communicationsManager, CasSimpleMultifactorAuthenticationService multifactorAuthenticationService, CasSimpleMultifactorAuthenticationProperties properties, CasSimpleMultifactorTokenCommunicationStrategy tokenCommunicationStrategy, BucketConsumer bucketConsumer) {
        this.communicationsManager = communicationsManager;
        this.multifactorAuthenticationService = multifactorAuthenticationService;
        this.properties = properties;
        this.tokenCommunicationStrategy = tokenCommunicationStrategy;
        this.bucketConsumer = bucketConsumer;
    }
}

