/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.web.flow;

import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.validator.routines.EmailValidator;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.bucket4j.consumer.BucketConsumer;
import org.apereo.cas.bucket4j.consumer.BucketConsumptionResult;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorAuthenticationProvider;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorTokenCommunicationStrategy;
import org.apereo.cas.mfa.simple.ticket.CasSimpleMultifactorAuthenticationTicket;
import org.apereo.cas.mfa.simple.validation.CasSimpleMultifactorAuthenticationService;
import org.apereo.cas.mfa.simple.web.flow.CasSimpleMultifactorSendEmail;
import org.apereo.cas.multitenancy.TenantExtractor;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.RegexUtils;
import org.apereo.cas.web.flow.actions.AbstractMultifactorAuthenticationAction;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class CasSimpleMultifactorVerifyEmailAction
extends AbstractMultifactorAuthenticationAction<CasSimpleMultifactorAuthenticationProvider> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasSimpleMultifactorVerifyEmailAction.class);
    public static final String TOKEN_PROPERTY_EMAIL_TO_REGISTER = "emailAddressToRegister";
    private static final String ERROR_CODE_EMAIL_FAILED = "cas.mfa.simple.registration.email.failed";
    protected final CommunicationsManager communicationsManager;
    protected final CasSimpleMultifactorAuthenticationService multifactorAuthenticationService;
    protected final CasSimpleMultifactorAuthenticationProperties properties;
    protected final CasSimpleMultifactorTokenCommunicationStrategy tokenCommunicationStrategy;
    protected final BucketConsumer bucketConsumer;
    protected final TenantExtractor tenantExtractor;

    protected Event doPreExecute(RequestContext requestContext) throws Exception {
        HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
        BucketConsumptionResult result = this.bucketConsumer.consume(this.getThrottledRequestKeyFor(authentication, requestContext));
        result.getHeaders().forEach((arg_0, arg_1) -> ((HttpServletResponse)response).addHeader(arg_0, arg_1));
        return result.isConsumed() ? super.doPreExecute(requestContext) : this.error();
    }

    protected Event doExecuteInternal(RequestContext requestContext) {
        try {
            String emailAddress = requestContext.getRequestParameters().getRequired("email");
            if (this.isAcceptableEmailAddress(emailAddress)) {
                Authentication authentication = WebUtils.getAuthentication((RequestContext)requestContext);
                Principal principal = this.resolvePrincipal(authentication.getPrincipal(), requestContext);
                LOGGER.debug("Received email address [{}] for [{}]", (Object)emailAddress, (Object)principal.getId());
                CasSimpleMultifactorAuthenticationTicket token = this.getOrCreateToken(requestContext, principal);
                token.putProperty(TOKEN_PROPERTY_EMAIL_TO_REGISTER, (Serializable)((Object)emailAddress));
                CasSimpleMultifactorSendEmail cmd = CasSimpleMultifactorSendEmail.of(this.communicationsManager, this.properties, this.tenantExtractor);
                boolean emailSent = cmd.send(principal, (Ticket)token, List.of(emailAddress), requestContext).isAnyEmailSent();
                if (emailSent) {
                    LOGGER.debug("Email [{}] is sent to [{}]", (Object)emailAddress, (Object)principal.getId());
                    this.storeToken(requestContext, token);
                    return this.success(token);
                }
            }
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        WebUtils.addErrorMessageToContext((RequestContext)requestContext, (String)ERROR_CODE_EMAIL_FAILED);
        return this.error();
    }

    protected boolean isAcceptableEmailAddress(String emailAddress) {
        return EmailValidator.getInstance().isValid(emailAddress) && this.properties.getMail().isRegistrationEnabled() && RegexUtils.matches((Pattern)this.properties.getMail().getAcceptedEmailPattern(), (String)emailAddress);
    }

    protected CasSimpleMultifactorAuthenticationTicket getOrCreateToken(RequestContext requestContext, Principal principal) {
        CasSimpleMultifactorAuthenticationTicket currentToken = (CasSimpleMultifactorAuthenticationTicket)MultifactorAuthenticationWebflowUtils.getSimpleMultifactorAuthenticationToken((RequestContext)requestContext, CasSimpleMultifactorAuthenticationTicket.class);
        return Optional.ofNullable(currentToken).filter(token -> !token.isExpired()).orElseGet(Unchecked.supplier(() -> {
            MultifactorAuthenticationWebflowUtils.removeSimpleMultifactorAuthenticationToken((RequestContext)requestContext);
            WebApplicationService service = WebUtils.getService((RequestContext)requestContext);
            return this.multifactorAuthenticationService.generate(principal, (Service)service);
        }));
    }

    protected void storeToken(RequestContext requestContext, CasSimpleMultifactorAuthenticationTicket token) throws Throwable {
        this.multifactorAuthenticationService.store(token);
        MultifactorAuthenticationWebflowUtils.putSimpleMultifactorAuthenticationToken((RequestContext)requestContext, (Ticket)token);
    }

    @Generated
    public CasSimpleMultifactorVerifyEmailAction(CommunicationsManager communicationsManager, CasSimpleMultifactorAuthenticationService multifactorAuthenticationService, CasSimpleMultifactorAuthenticationProperties properties, CasSimpleMultifactorTokenCommunicationStrategy tokenCommunicationStrategy, BucketConsumer bucketConsumer, TenantExtractor tenantExtractor) {
        this.communicationsManager = communicationsManager;
        this.multifactorAuthenticationService = multifactorAuthenticationService;
        this.properties = properties;
        this.tokenCommunicationStrategy = tokenCommunicationStrategy;
        this.bucketConsumer = bucketConsumer;
        this.tenantExtractor = tenantExtractor;
    }
}

