/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.form.datetime;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.model.IModel;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.utils.LocaleUtils;
import org.wicketstuff.kendo.ui.KendoUIBehavior;
import org.wicketstuff.kendo.ui.utils.KendoDateTimeUtils;

public class TimePicker
extends DateTextField
implements IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private final Locale locale;
    protected final Options options;

    public TimePicker(String id) {
        this(id, new Options());
    }

    public TimePicker(String id, Options options) {
        this(id, null, null, "h:mm aa", options);
    }

    public TimePicker(String id, Locale locale) {
        this(id, locale, new Options());
    }

    public TimePicker(String id, Locale locale, Options options) {
        this(id, null, locale, LocaleUtils.getLocaleTimePattern((Locale)locale, (String)"h:mm aa"), options);
    }

    public TimePicker(String id, String pattern) {
        this(id, pattern, new Options());
    }

    public TimePicker(String id, String pattern, Options options) {
        this(id, null, null, pattern, options);
    }

    public TimePicker(String id, Locale locale, String pattern) {
        this(id, locale, pattern, new Options());
    }

    public TimePicker(String id, Locale locale, String pattern, Options options) {
        this(id, null, locale, pattern, options);
    }

    public TimePicker(String id, IModel<Date> model) {
        this(id, model, new Options());
    }

    public TimePicker(String id, IModel<Date> model, Options options) {
        this(id, model, null, "h:mm aa", options);
    }

    public TimePicker(String id, IModel<Date> model, Locale locale) {
        this(id, model, locale, new Options());
    }

    public TimePicker(String id, IModel<Date> model, Locale locale, Options options) {
        this(id, model, locale, LocaleUtils.getLocaleTimePattern((Locale)locale, (String)"h:mm aa"), options);
    }

    public TimePicker(String id, IModel<Date> model, String pattern) {
        this(id, model, pattern, new Options());
    }

    public TimePicker(String id, IModel<Date> model, String pattern, Options options) {
        this(id, model, null, pattern, options);
    }

    public TimePicker(String id, IModel<Date> model, Locale locale, String pattern) {
        this(id, model, locale, pattern, new Options());
    }

    public TimePicker(String id, IModel<Date> model, Locale locale, String pattern, Options options) {
        super(id, model, pattern);
        this.locale = locale;
        this.options = options;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
    }

    public void onConfigure(JQueryBehavior behavior) {
        if (behavior.getOption("culture") == null) {
            behavior.setOption("culture", (Object)Options.asString((String)LocaleUtils.getLangageCode((Locale)this.getLocale())));
        }
        if (behavior.getOption("format") == null) {
            behavior.setOption("format", (Object)Options.asString((String)KendoDateTimeUtils.toPattern(this.getTextFormat())));
        }
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    public final String getTextFormat() {
        return super.getTextFormat();
    }

    public String getModelObjectAsString() {
        Date date = (Date)this.getModelObject();
        if (date != null) {
            return new SimpleDateFormat(this.getTextFormat(), this.getLocale()).format(date);
        }
        return "";
    }

    protected String[] getInputTypes() {
        return new String[]{"text", "time"};
    }

    public String getInput() {
        String input = super.getInput();
        if (input != null) {
            return KendoDateTimeUtils.convert(input);
        }
        return null;
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new KendoUIBehavior(selector, "kendoTimePicker", this.options);
    }
}

