/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.Table;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.time.OffsetDateTime;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.AccessToken;
import org.apache.syncope.core.persistence.jpa.entity.AbstractProvidedKeyEntity;

@Entity
@Table(name="AccessToken")
@Cacheable
public class JPAAccessToken
extends AbstractProvidedKeyEntity
implements AccessToken,
PersistenceCapable {
    public static final String TABLE = "AccessToken";
    private static final long serialVersionUID = -8734194815582467949L;
    @Lob
    private String body;
    private OffsetDateTime expirationTime;
    @Column(unique=true)
    private String owner;
    @Lob
    private byte[] authorities;
    private static int pcInheritedFieldCount = AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public String getBody() {
        return JPAAccessToken.pcGetbody(this);
    }

    public void setBody(String body) {
        JPAAccessToken.pcSetbody(this, body);
    }

    public OffsetDateTime getExpirationTime() {
        return JPAAccessToken.pcGetexpirationTime(this);
    }

    public void setExpirationTime(OffsetDateTime expirationTime) {
        JPAAccessToken.pcSetexpirationTime(this, expirationTime);
    }

    public String getOwner() {
        return JPAAccessToken.pcGetowner(this);
    }

    public void setOwner(String owner) {
        JPAAccessToken.pcSetowner(this, owner);
    }

    public byte[] getAuthorities() {
        return JPAAccessToken.pcGetauthorities(this);
    }

    public void setAuthorities(byte[] authorities) {
        JPAAccessToken.pcSetauthorities(this, ArrayUtils.clone((byte[])authorities));
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcPCSuperclass = AbstractProvidedKeyEntity.class;
        pcFieldNames = new String[]{"authorities", "body", "expirationTime", "owner"};
        pcFieldTypes = new Class[]{byte[].class, String.class, OffsetDateTime.class, String.class};
        pcFieldFlags = new byte[]{26, 26, 26, 26};
        PCRegistry.register(JPAAccessToken.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAAccessToken", (PersistenceCapable)new JPAAccessToken());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.authorities = null;
        this.body = null;
        this.expirationTime = null;
        this.owner = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAAccessToken jPAAccessToken = new JPAAccessToken();
        if (bl) {
            jPAAccessToken.pcClearFields();
        }
        jPAAccessToken.pcStateManager = stateManager;
        jPAAccessToken.pcCopyKeyFieldsFromObjectId(object);
        return jPAAccessToken;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAAccessToken jPAAccessToken = new JPAAccessToken();
        if (bl) {
            jPAAccessToken.pcClearFields();
        }
        jPAAccessToken.pcStateManager = stateManager;
        return jPAAccessToken;
    }

    protected static int pcGetManagedFieldCount() {
        return 4 + AbstractProvidedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.authorities = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.body = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.expirationTime = (OffsetDateTime)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.owner = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.authorities);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.body);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.expirationTime);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.owner);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAAccessToken jPAAccessToken, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAAccessToken, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.authorities = jPAAccessToken.authorities;
                return;
            }
            case 1: {
                this.body = jPAAccessToken.body;
                return;
            }
            case 2: {
                this.expirationTime = jPAAccessToken.expirationTime;
                return;
            }
            case 3: {
                this.owner = jPAAccessToken.owner;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAAccessToken jPAAccessToken = (JPAAccessToken)object;
        if (jPAAccessToken.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAAccessToken, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAAccessToken.class;
    }

    private static final byte[] pcGetauthorities(JPAAccessToken jPAAccessToken) {
        if (jPAAccessToken.pcStateManager == null) {
            return jPAAccessToken.authorities;
        }
        int n = pcInheritedFieldCount + 0;
        jPAAccessToken.pcStateManager.accessingField(n);
        return jPAAccessToken.authorities;
    }

    private static final void pcSetauthorities(JPAAccessToken jPAAccessToken, byte[] byArray) {
        if (jPAAccessToken.pcStateManager == null) {
            jPAAccessToken.authorities = byArray;
            return;
        }
        jPAAccessToken.pcStateManager.settingObjectField((PersistenceCapable)jPAAccessToken, pcInheritedFieldCount + 0, (Object)jPAAccessToken.authorities, (Object)byArray, 0);
    }

    private static final String pcGetbody(JPAAccessToken jPAAccessToken) {
        if (jPAAccessToken.pcStateManager == null) {
            return jPAAccessToken.body;
        }
        int n = pcInheritedFieldCount + 1;
        jPAAccessToken.pcStateManager.accessingField(n);
        return jPAAccessToken.body;
    }

    private static final void pcSetbody(JPAAccessToken jPAAccessToken, String string) {
        if (jPAAccessToken.pcStateManager == null) {
            jPAAccessToken.body = string;
            return;
        }
        jPAAccessToken.pcStateManager.settingStringField((PersistenceCapable)jPAAccessToken, pcInheritedFieldCount + 1, jPAAccessToken.body, string, 0);
    }

    private static final OffsetDateTime pcGetexpirationTime(JPAAccessToken jPAAccessToken) {
        if (jPAAccessToken.pcStateManager == null) {
            return jPAAccessToken.expirationTime;
        }
        int n = pcInheritedFieldCount + 2;
        jPAAccessToken.pcStateManager.accessingField(n);
        return jPAAccessToken.expirationTime;
    }

    private static final void pcSetexpirationTime(JPAAccessToken jPAAccessToken, OffsetDateTime offsetDateTime) {
        if (jPAAccessToken.pcStateManager == null) {
            jPAAccessToken.expirationTime = offsetDateTime;
            return;
        }
        jPAAccessToken.pcStateManager.settingObjectField((PersistenceCapable)jPAAccessToken, pcInheritedFieldCount + 2, (Object)jPAAccessToken.expirationTime, (Object)offsetDateTime, 0);
    }

    private static final String pcGetowner(JPAAccessToken jPAAccessToken) {
        if (jPAAccessToken.pcStateManager == null) {
            return jPAAccessToken.owner;
        }
        int n = pcInheritedFieldCount + 3;
        jPAAccessToken.pcStateManager.accessingField(n);
        return jPAAccessToken.owner;
    }

    private static final void pcSetowner(JPAAccessToken jPAAccessToken, String string) {
        if (jPAAccessToken.pcStateManager == null) {
            jPAAccessToken.owner = string;
            return;
        }
        jPAAccessToken.pcStateManager.settingStringField((PersistenceCapable)jPAAccessToken, pcInheritedFieldCount + 3, jPAAccessToken.owner, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

