/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.interceptor;

import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.interceptor.RetryInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JtaRetryInterceptor
extends RetryInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JtaRetryInterceptor.class);
    protected final TransactionManager transactionManager;

    public JtaRetryInterceptor(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public <T> T execute(CommandConfig config, Command<T> command, CommandExecutor commandExecutor) {
        if (this.calledInsideTransaction()) {
            LOGGER.trace("Called inside transaction, skipping the retry interceptor.");
            return this.next.execute(config, command, commandExecutor);
        }
        return super.execute(config, command, commandExecutor);
    }

    protected boolean calledInsideTransaction() {
        try {
            return this.transactionManager.getStatus() != 6;
        }
        catch (SystemException e) {
            throw new FlowableException("Could not determine the current status of the transaction manager: " + e.getMessage(), (Throwable)e);
        }
    }
}

