/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authorization;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authorization.BaseUseAttributesAuthorizationGenerator;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.SearchOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class LdapUserAttributesToRolesAuthorizationGenerator
extends BaseUseAttributesAuthorizationGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(LdapUserAttributesToRolesAuthorizationGenerator.class);
    private final String roleAttribute;
    private final String rolePrefix;

    public LdapUserAttributesToRolesAuthorizationGenerator(SearchOperation userSearchOperation, boolean allowMultipleResults, String roleAttribute, String rolePrefix) {
        super(userSearchOperation, allowMultipleResults);
        this.roleAttribute = roleAttribute;
        this.rolePrefix = rolePrefix;
    }

    @Override
    protected List<SimpleGrantedAuthority> generateAuthorizationForLdapEntry(Principal profile, LdapEntry userEntry) {
        LdapAttribute attribute = userEntry.getAttribute(this.roleAttribute);
        return Optional.ofNullable(attribute).map(LdapAttribute::getStringValues).map(value -> value.stream().map(entry -> entry.toUpperCase(Locale.ENGLISH)).map(role -> StringUtils.prependIfMissing((String)role, (CharSequence)this.rolePrefix, (CharSequence[])new CharSequence[0])).map(SimpleGrantedAuthority::new).collect(Collectors.toList())).stream().flatMap(Collection::stream).toList();
    }

    @Generated
    public String getRoleAttribute() {
        return this.roleAttribute;
    }

    @Generated
    public String getRolePrefix() {
        return this.rolePrefix;
    }
}

