/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.config.CasCoreUtilAutoConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.GroovyScriptResourceCacheManager;
import org.apereo.cas.util.scripting.ScriptResourceCacheManager;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.scheduling.annotation.EnableScheduling;

@AutoConfigureOrder(value=-2147483648)
@EnableScheduling
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.Scripting})
@ImportAutoConfiguration(value={CasCoreUtilAutoConfiguration.class})
@AutoConfiguration
public class CasCoreScriptingAutoConfiguration {

    @Configuration(value="CasCoreScriptingGroovyConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @Lazy(value=false)
    static class CasCoreScriptingGroovyConfiguration {
        CasCoreScriptingGroovyConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(name={"scriptResourceCacheManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ScriptResourceCacheManager<String, ExecutableCompiledScript> scriptResourceCacheManager(CasConfigurationProperties casProperties) {
            return new GroovyScriptResourceCacheManager(casProperties.getCore().getGroovyCacheManager());
        }
    }
}

