/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.CheckRequestTupleKey;
import org.apache.syncope.ext.openfga.client.model.ContextualTupleKeys;

@JsonPropertyOrder(value={"tuple_key", "contextual_tuples", "context", "correlation_id"})
public class BatchCheckItem {
    public static final String JSON_PROPERTY_TUPLE_KEY = "tuple_key";
    @Nonnull
    private CheckRequestTupleKey tupleKey;
    public static final String JSON_PROPERTY_CONTEXTUAL_TUPLES = "contextual_tuples";
    @Nullable
    private ContextualTupleKeys contextualTuples;
    public static final String JSON_PROPERTY_CONTEXT = "context";
    @Nullable
    private Object context;
    public static final String JSON_PROPERTY_CORRELATION_ID = "correlation_id";
    @Nonnull
    private String correlationId;

    public BatchCheckItem tupleKey(@Nonnull CheckRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tuple_key", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public CheckRequestTupleKey getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="tuple_key", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTupleKey(@Nonnull CheckRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
    }

    public BatchCheckItem contextualTuples(@Nullable ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
        return this;
    }

    @Nullable
    @JsonProperty(value="contextual_tuples", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContextualTupleKeys getContextualTuples() {
        return this.contextualTuples;
    }

    @JsonProperty(value="contextual_tuples", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContextualTuples(@Nullable ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
    }

    public BatchCheckItem context(@Nullable Object context) {
        this.context = context;
        return this;
    }

    @Nullable
    @JsonProperty(value="context", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getContext() {
        return this.context;
    }

    @JsonProperty(value="context", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContext(@Nullable Object context) {
        this.context = context;
    }

    public BatchCheckItem correlationId(@Nonnull String correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    @Nonnull
    @JsonProperty(value="correlation_id", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCorrelationId() {
        return this.correlationId;
    }

    @JsonProperty(value="correlation_id", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCorrelationId(@Nonnull String correlationId) {
        this.correlationId = correlationId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchCheckItem batchCheckItem = (BatchCheckItem)o;
        return Objects.equals(this.tupleKey, batchCheckItem.tupleKey) && Objects.equals(this.contextualTuples, batchCheckItem.contextualTuples) && Objects.equals(this.context, batchCheckItem.context) && Objects.equals(this.correlationId, batchCheckItem.correlationId);
    }

    public int hashCode() {
        return Objects.hash(this.tupleKey, this.contextualTuples, this.context, this.correlationId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchCheckItem {\n");
        sb.append("    tupleKey: ").append(this.toIndentedString(this.tupleKey)).append("\n");
        sb.append("    contextualTuples: ").append(this.toIndentedString(this.contextualTuples)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("    correlationId: ").append(this.toIndentedString(this.correlationId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTupleKey() != null) {
            joiner.add(this.getTupleKey().toUrlQueryString((String)prefix + JSON_PROPERTY_TUPLE_KEY + suffix));
        }
        if (this.getContextualTuples() != null) {
            joiner.add(this.getContextualTuples().toUrlQueryString((String)prefix + JSON_PROPERTY_CONTEXTUAL_TUPLES + suffix));
        }
        if (this.getContext() != null) {
            joiner.add(String.format(Locale.ROOT, "%scontext%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getContext()))));
        }
        if (this.getCorrelationId() != null) {
            joiner.add(String.format(Locale.ROOT, "%scorrelation_id%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getCorrelationId()))));
        }
        return joiner.toString();
    }
}

