/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.mfa.simple.CasSimpleMultifactorBypassEvaluator;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.SimpleMFA})
@Configuration(value="CasSimpleMultifactorAuthenticationMultifactorProviderBypassConfiguration", proxyBeanMethods=false)
class CasSimpleMultifactorAuthenticationMultifactorProviderBypassConfiguration {
    CasSimpleMultifactorAuthenticationMultifactorProviderBypassConfiguration() {
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorBypassEvaluator"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorBypassEvaluator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider(applicationContext);
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        Collection currentBypassEvaluators = applicationContext.getBeansWithAnnotation(CasSimpleMultifactorBypassEvaluator.class).values();
        currentBypassEvaluators.stream().filter(BeanSupplier::isNotProxy).map(MultifactorAuthenticationProviderBypassEvaluator.class::cast).filter(evaluator -> !evaluator.isEmpty()).map(evaluator -> evaluator.belongsToMultifactorAuthenticationProvider(simple.getId())).filter(Optional::isPresent).map(Optional::get).sorted((Comparator<MultifactorAuthenticationProviderBypassEvaluator>)AnnotationAwareOrderComparator.INSTANCE).forEach(arg_0 -> ((DefaultChainingMultifactorAuthenticationBypassProvider)bypass).addMultifactorAuthenticationProviderBypassEvaluator(arg_0));
        return bypass;
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @CasSimpleMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorRestMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(BeanCondition.on((String)"cas.authn.mfa.simple.bypass.rest.url").given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
            MultifactorAuthenticationProviderBypassProperties props = simple.getBypass();
            return new RestMultifactorAuthenticationProviderBypassEvaluator(props, simple.getId(), applicationContext);
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @CasSimpleMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorGroovyMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(BeanCondition.on((String)"cas.authn.mfa.simple.bypass.groovy.location").exists().given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
            CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
            MultifactorAuthenticationProviderBypassProperties props = simple.getBypass();
            return new GroovyMultifactorAuthenticationProviderBypassEvaluator(props, simple.getId(), applicationContext);
        }).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"casSimpleMultifactorHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @CasSimpleMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorHttpRequestMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        MultifactorAuthenticationProviderBypassProperties props = simple.getBypass();
        boolean bypassActive = StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress());
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(bypassActive).supply(() -> new HttpRequestMultifactorAuthenticationProviderBypassEvaluator(props, simple.getId(), (ApplicationContext)applicationContext)).otherwiseProxy().get();
    }

    @ConditionalOnMissingBean(name={"casSimpleRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator"})
    @Bean
    @CasSimpleMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleRegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        return new RegisteredServicePrincipalAttributeMultifactorAuthenticationProviderBypassEvaluator(simple.getId(), applicationContext);
    }

    @Bean
    @CasSimpleMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"casSimpleMultifactorCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorCredentialMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        MultifactorAuthenticationProviderBypassProperties props = simple.getBypass();
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(StringUtils.isNotBlank((CharSequence)props.getCredentialClassType())).supply(() -> new CredentialMultifactorAuthenticationProviderBypassEvaluator(props, simple.getId(), applicationContext)).otherwiseProxy().get();
    }

    @Bean
    @CasSimpleMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"casSimpleMultifactorRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorRegisteredServiceMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        return new RegisteredServiceMultifactorAuthenticationProviderBypassEvaluator(simple.getId(), applicationContext);
    }

    @Bean
    @CasSimpleMultifactorBypassEvaluator
    @ConditionalOnMissingBean(name={"casSimpleMultifactorPrincipalMultifactorAuthenticationProviderBypass"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorPrincipalMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        MultifactorAuthenticationProviderBypassProperties props = simple.getBypass();
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(StringUtils.isNotBlank((CharSequence)props.getPrincipalAttributeName())).supply(() -> new PrincipalMultifactorAuthenticationProviderBypassEvaluator(props, simple.getId(), (ApplicationContext)applicationContext)).otherwiseProxy().get();
    }

    @Bean
    @CasSimpleMultifactorBypassEvaluator
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @ConditionalOnMissingBean(name={"casSimpleMultifactorAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypassEvaluator casSimpleMultifactorAuthenticationMultifactorAuthenticationProviderBypass(ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        CasSimpleMultifactorAuthenticationProperties simple = casProperties.getAuthn().getMfa().getSimple();
        MultifactorAuthenticationProviderBypassProperties props = simple.getBypass();
        boolean bypassActive = StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName());
        return (MultifactorAuthenticationProviderBypassEvaluator)BeanSupplier.of(MultifactorAuthenticationProviderBypassEvaluator.class).when(bypassActive).supply(() -> new AuthenticationMultifactorAuthenticationProviderBypassEvaluator(props, simple.getId(), applicationContext)).otherwiseProxy().get();
    }
}

