/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import kafka.log.LogTestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ec\u0001B\n\u0015\u0001eAQ\u0001\t\u0001\u0005\u0002\u0005Bq\u0001\n\u0001C\u0002\u0013\u0005Q\u0005\u0003\u00042\u0001\u0001\u0006IA\n\u0005\ne\u0001\u0001\r\u00111A\u0005\u0002MB\u0011\u0002\u0010\u0001A\u0002\u0003\u0007I\u0011A\u001f\t\u0013\r\u0003\u0001\u0019!A!B\u0013!\u0004\"\u0002#\u0001\t\u0013)\u0005bB1\u0001#\u0003%IA\u0019\u0005\b[\u0002\t\n\u0011\"\u0003o\u0011\u0015\u0001\b\u0001\"\u0001r\u0011\u0015i\b\u0001\"\u0001r\u0011\u001d\t)\u0001\u0001C\u0005\u0003\u000fAa!a\u000f\u0001\t\u0003\t\bBBA#\u0001\u0011\u0005\u0011\u000f\u0003\u0004\u0002J\u0001!\t!\u001d\u0005\u0007\u0003\u001b\u0002A\u0011A9\t\r\u0005E\u0003\u0001\"\u0001r\u0011\u0019\t)\u0006\u0001C\u0001c\nyAj\\4TK\u001elWM\u001c;t)\u0016\u001cHO\u0003\u0002\u0016-\u0005\u0019An\\4\u000b\u0003]\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00015A\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0012\u0011\u0005\r\u0002Q\"\u0001\u000b\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\ta\u0005\u0005\u0002(_5\t\u0001F\u0003\u0002*U\u000511m\\7n_:T!aF\u0016\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0005\u0003a!\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\bu_BL7\rU1si&$\u0018n\u001c8!\u0003\u0019awn\u001a#jeV\tA\u0007\u0005\u00026u5\taG\u0003\u00028q\u0005\u0011\u0011n\u001c\u0006\u0002s\u0005!!.\u0019<b\u0013\tYdG\u0001\u0003GS2,\u0017A\u00037pO\u0012K'o\u0018\u0013fcR\u0011a(\u0011\t\u00037}J!\u0001\u0011\u000f\u0003\tUs\u0017\u000e\u001e\u0005\b\u0005\u0016\t\t\u00111\u00015\u0003\rAH%M\u0001\bY><G)\u001b:!\u00035\u0019'/Z1uKN+w-\\3oiR!ai\u0014+Z!\t9U*D\u0001I\u0015\t)\u0012J\u0003\u0002K\u0017\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0003\u0019*\nqa\u001d;pe\u0006<W-\u0003\u0002O\u0011\nQAj\\4TK\u001elWM\u001c;\t\u000bA;\u0001\u0019A)\u0002\r=4gm]3u!\tY\"+\u0003\u0002T9\t!Aj\u001c8h\u0011\u001d)v\u0001%AA\u0002Y\u000b!#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fgB\u00111dV\u0005\u00031r\u00111!\u00138u\u0011\u001dQv\u0001%AA\u0002m\u000bA\u0001^5nKB\u0011AlX\u0007\u0002;*\u0011a\fK\u0001\u0006kRLGn]\u0005\u0003Av\u0013A\u0001V5nK\u000692M]3bi\u0016\u001cVmZ7f]R$C-\u001a4bk2$HEM\u000b\u0002G*\u0012a\u000bZ\u0016\u0002KB\u0011am[\u0007\u0002O*\u0011\u0001.[\u0001\nk:\u001c\u0007.Z2lK\u0012T!A\u001b\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002mO\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002/\r\u0014X-\u0019;f'\u0016<W.\u001a8uI\u0011,g-Y;mi\u0012\u001aT#A8+\u0005m#\u0017!B:fiV\u0004H#\u0001 )\u0005)\u0019\bC\u0001;|\u001b\u0005)(B\u0001<x\u0003\r\t\u0007/\u001b\u0006\u0003qf\fqA[;qSR,'O\u0003\u0002{[\u0005)!.\u001e8ji&\u0011A0\u001e\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$wn\u001e8)\u0005-y\bc\u0001;\u0002\u0002%\u0019\u00111A;\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017aC1tg\u0016\u0014H/\u00128uef$RAPA\u0005\u0003\u001bAa!a\u0003\r\u0001\u00041\u0015aB:fO6,g\u000e\u001e\u0005\b\u0003\u001fa\u0001\u0019AA\t\u0003\u0019!Xm\u001d;fIB9\u00111CA\u0016\u0003c1e\u0002BA\u000b\u0003KqA!a\u0006\u0002\"9!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001ea\ta\u0001\u0010:p_Rt\u0014\"A\u001d\n\u0007\u0005\r\u0002(\u0001\u0003vi&d\u0017\u0002BA\u0014\u0003S\t1!T1q\u0015\r\t\u0019\u0003O\u0005\u0005\u0003[\tyCA\u0003F]R\u0014\u0018P\u0003\u0003\u0002(\u0005%\u0002\u0003BA\u001a\u0003si!!!\u000e\u000b\u0007\u0005]\u0002(\u0001\u0003mC:<\u0017bA*\u00026\u0005\u0019B/Z:u\u0005\u0006\u001c\u0018nY(qKJ\fG/[8og\"\u001aQ\"a\u0010\u0011\u0007Q\f\t%C\u0002\u0002DU\u0014A\u0001V3ti\u0006\tB/Z:u'\u0016<W.\u001a8u\u0003\u000e\u001cWm]:)\u00079\ty$\u0001\u000euKN$8\t\\8tKN$X*\u0019;dQ>\u0003XM]1uS>t7\u000fK\u0002\u0010\u0003\u007f\t!\u0003^3ti\"Kw\r[3s'\u0016<W.\u001a8ug\"\u001a\u0001#a\u0010\u0002)Q,7\u000f^*ju\u00164uN\u001d'be\u001e,Gj\\4tQ\r\t\u0012qH\u0001\u000ei\u0016\u001cH/\u00169eCR,G)\u001b:)\u0007I\ty\u0004")
public class LogSegmentsTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private File logDir;

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public File logDir() {
        return this.logDir;
    }

    public void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        return LogTestUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
    }

    private int createSegment$default$2() {
        return 10;
    }

    private Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @BeforeEach
    public void setup() {
        this.logDir_$eq(TestUtils.tempDirectory(null, null));
    }

    @AfterEach
    public void teardown() {
        Utils.delete((File)this.logDir());
    }

    private void assertEntry(LogSegment segment, Map.Entry<Long, LogSegment> tested) {
        Assertions.assertEquals((long)segment.baseOffset(), (Long)tested.getKey());
        Assertions.assertEquals((Object)segment, (Object)tested.getValue());
    }

    @Test
    public void testBasicOperations() {
        LogSegments segments = new LogSegments(this.topicPartition());
        Assertions.assertTrue((boolean)segments.isEmpty());
        Assertions.assertFalse((boolean)segments.nonEmpty());
        int offset1 = 40;
        LogSegment seg1 = this.createSegment(offset1, 10, Time.SYSTEM);
        int offset2 = 80;
        LogSegment seg2 = this.createSegment(offset2, 10, Time.SYSTEM);
        LogSegment seg3 = this.createSegment(offset1, 10, Time.SYSTEM);
        segments.add(seg1);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)1, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset1));
        Assertions.assertEquals(Optional.of(seg1), (Object)segments.get((long)offset1));
        segments.add(seg2);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)2, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset2));
        Assertions.assertEquals(Optional.of(seg2), (Object)segments.get((long)offset2));
        segments.add(seg3);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)2, (int)segments.numberOfSegments());
        Assertions.assertTrue((boolean)segments.contains((long)offset1));
        Assertions.assertEquals(Optional.of(seg3), (Object)segments.get((long)offset1));
        segments.remove((long)offset2);
        Assertions.assertFalse((boolean)segments.isEmpty());
        Assertions.assertTrue((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)1, (int)segments.numberOfSegments());
        Assertions.assertFalse((boolean)segments.contains((long)offset2));
        segments.clear();
        Assertions.assertTrue((boolean)segments.isEmpty());
        Assertions.assertFalse((boolean)segments.nonEmpty());
        Assertions.assertEquals((int)0, (int)segments.numberOfSegments());
        Assertions.assertFalse((boolean)segments.contains((long)offset1));
        seg1.close();
        seg2.close();
        seg3.close();
    }

    @Test
    public void testSegmentAccess() {
        LogSegments segments = new LogSegments(this.topicPartition());
        int offset1 = 1;
        LogSegment seg1 = this.createSegment(offset1, 10, Time.SYSTEM);
        int offset2 = 2;
        LogSegment seg2 = this.createSegment(offset2, 10, Time.SYSTEM);
        int offset3 = 3;
        LogSegment seg3 = this.createSegment(offset3, 10, Time.SYSTEM);
        int offset4 = 4;
        LogSegment seg4 = this.createSegment(offset4, 10, Time.SYSTEM);
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)seg -> {
            LogSegmentsTest.$anonfun$testSegmentAccess$1(this, segments, seg1, seg);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{offset1, offset2, offset3, offset4})), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.baseOffsets()).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values()).asScala().toSeq());
        Assertions.assertThrows(IllegalArgumentException.class, () -> segments.values(2L, 1L));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(1L, 1L)).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(1L, 2L)).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(1L, 3L)).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)Nil$.MODULE$))), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(1L, 4L)).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(2L, 4L)).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg3, (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(3L, 4L)).asScala().toSeq());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(4L, 4L)).asScala().toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg4, (List)Nil$.MODULE$), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.values(4L, 5L)).asScala().toSeq());
        Assertions.assertEquals((Object)seg4, (Object)segments.activeSegment());
        Assertions.assertEquals((Object)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)Nil$.MODULE$)), (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.nonActiveLogSegmentsFrom(2L)).asScala().toSeq());
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)CollectionConverters$.MODULE$.CollectionHasAsScala(segments.nonActiveLogSegmentsFrom(4L)).asScala().toSeq());
        segments.close();
    }

    @Test
    public void testClosestMatchOperations() {
        LogSegments segments = new LogSegments(this.topicPartition());
        LogSegment seg1 = this.createSegment(1L, 10, Time.SYSTEM);
        LogSegment seg2 = this.createSegment(3L, 10, Time.SYSTEM);
        LogSegment seg3 = this.createSegment(5L, 10, Time.SYSTEM);
        LogSegment seg4 = this.createSegment(7L, 10, Time.SYSTEM);
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)x$1 -> segments.add(x$1));
        Assertions.assertEquals(Optional.of(seg1), (Object)segments.floorSegment(2L));
        Assertions.assertEquals(Optional.of(seg2), (Object)segments.floorSegment(3L));
        Assertions.assertEquals(Optional.of(seg1), (Object)segments.lowerSegment(3L));
        Assertions.assertEquals(Optional.of(seg2), (Object)segments.lowerSegment(4L));
        Assertions.assertEquals(Optional.of(seg3), (Object)segments.higherSegment(4L));
        this.assertEntry(seg3, (Map.Entry)segments.higherEntry(4L).get());
        Assertions.assertEquals(Optional.of(seg4), (Object)segments.higherSegment(5L));
        this.assertEntry(seg4, (Map.Entry)segments.higherEntry(5L).get());
        segments.close();
    }

    @Test
    public void testHigherSegments() {
        LogSegments segments = new LogSegments(this.topicPartition());
        LogSegment seg1 = this.createSegment(1L, 10, Time.SYSTEM);
        LogSegment seg2 = this.createSegment(3L, 10, Time.SYSTEM);
        LogSegment seg3 = this.createSegment(5L, 10, Time.SYSTEM);
        LogSegment seg4 = this.createSegment(7L, 10, Time.SYSTEM);
        LogSegment seg5 = this.createSegment(9L, 10, Time.SYSTEM);
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)x$1 -> segments.add(x$1));
        Iterator iterator = segments.higherSegments(0L).iterator();
        new .colon.colon((Object)seg1, (List)new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)segment -> {
            LogSegmentsTest.$anonfun$testHigherSegments$2(iterator, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)iterator.hasNext());
        Iterator iterator2 = segments.higherSegments(1L).iterator();
        new .colon.colon((Object)seg2, (List)new .colon.colon((Object)seg3, (List)new .colon.colon((Object)seg4, (List)new .colon.colon((Object)seg5, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)segment -> {
            LogSegmentsTest.$anonfun$testHigherSegments$3(iterator2, segment);
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)iterator2.hasNext());
        Iterator iterator3 = segments.higherSegments(8L).iterator();
        Assertions.assertTrue((boolean)iterator3.hasNext());
        Assertions.assertEquals((Object)seg5, iterator3.next());
        Assertions.assertFalse((boolean)iterator3.hasNext());
        Assertions.assertFalse((boolean)segments.higherSegments(9L).iterator().hasNext());
        segments.close();
    }

    @Test
    public void testSizeForLargeLogs() {
        long largeSize = 0xFFFFFFFEL;
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenReturn((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        Assertions.assertEquals((long)Integer.MAX_VALUE, (long)LogSegments.sizeInBytes(Arrays.asList(logSegment)));
        Assertions.assertEquals((long)largeSize, (long)LogSegments.sizeInBytes(Arrays.asList(logSegment, logSegment)));
        Assertions.assertTrue((LogSegments.sizeInBytes(Arrays.asList(logSegment, logSegment)) > Integer.MAX_VALUE ? 1 : 0) != 0);
        LogSegments logSegments = new LogSegments(this.topicPartition());
        logSegments.add(logSegment);
        Assertions.assertEquals((long)Integer.MAX_VALUE, (long)logSegments.sizeInBytes());
        logSegment.close();
    }

    @Test
    public void testUpdateDir() {
        LogSegment seg1 = this.createSegment(1L, 10, Time.SYSTEM);
        LogSegments segments = new LogSegments(this.topicPartition());
        segments.add(seg1);
        File newDir = TestUtils.tempDirectory(null, null);
        segments.updateParentDir(newDir);
        Assertions.assertEquals((Object)newDir, (Object)seg1.log().file().getParentFile());
        Assertions.assertEquals((Object)newDir, (Object)seg1.timeIndexFile().getParentFile());
        Assertions.assertEquals((Object)newDir, (Object)seg1.offsetIndexFile().getParentFile());
        Assertions.assertEquals((Object)newDir, (Object)seg1.txnIndex().file().getParentFile());
        seg1.close();
        Utils.delete((File)newDir);
    }

    public static final /* synthetic */ void $anonfun$testSegmentAccess$1(LogSegmentsTest $this, LogSegments segments$1, LogSegment seg1$1, LogSegment seg) {
        segments$1.add(seg);
        $this.assertEntry(seg1$1, (Map.Entry)segments$1.firstEntry().get());
        Assertions.assertEquals(Optional.of(seg1$1), (Object)segments$1.firstSegment());
        Assertions.assertEquals((Object)OptionalLong.of(1L), (Object)segments$1.firstSegmentBaseOffset());
        $this.assertEntry(seg, (Map.Entry)segments$1.lastEntry().get());
        Assertions.assertEquals(Optional.of(seg), (Object)segments$1.lastSegment());
    }

    public static final /* synthetic */ void $anonfun$testHigherSegments$2(Iterator iterator$1, LogSegment segment) {
        Assertions.assertTrue((boolean)iterator$1.hasNext());
        Assertions.assertEquals((Object)segment, iterator$1.next());
    }

    public static final /* synthetic */ void $anonfun$testHigherSegments$3(Iterator iterator$2, LogSegment segment) {
        Assertions.assertTrue((boolean)iterator$2.hasNext());
        Assertions.assertEquals((Object)segment, iterator$2.next());
    }
}

