/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import kafka.utils.Json$;
import kafka.utils.json.JsonValue$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0005=w!B\u0012%\u0011\u0003Ic!B\u0016%\u0011\u0003a\u0003\"B\u001a\u0002\t\u0003!d\u0001B\u001b\u0002\u0001ZB\u0001BR\u0002\u0003\u0016\u0004%\ta\u0012\u0005\t!\u000e\u0011\t\u0012)A\u0005\u0011\"A\u0011k\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005W\u0007\tE\t\u0015!\u0003T\u0011\u0015\u00194\u0001\"\u0001X\u0011\u001di7!!A\u0005\u00029Dq!]\u0002\u0012\u0002\u0013\u0005!\u000fC\u0004}\u0007E\u0005I\u0011A?\t\u0011}\u001c\u0011\u0011!C!\u0003\u0003A\u0001\"!\u0005\u0004\u0003\u0003%\tA\u0015\u0005\n\u0003'\u0019\u0011\u0011!C\u0001\u0003+A\u0011\"!\t\u0004\u0003\u0003%\t%a\t\t\u0013\u0005E2!!A\u0005\u0002\u0005M\u0002\"CA\u001f\u0007\u0005\u0005I\u0011IA \u0011%\t\u0019eAA\u0001\n\u0003\n)\u0005C\u0005\u0002H\r\t\t\u0011\"\u0011\u0002J!I\u00111J\u0002\u0002\u0002\u0013\u0005\u0013QJ\u0004\n\u0003#\n\u0011\u0011!E\u0001\u0003'2\u0001\"N\u0001\u0002\u0002#\u0005\u0011Q\u000b\u0005\u0007gY!\t!!\u001c\t\u0013\u0005\u001dc#!A\u0005F\u0005%\u0003\"CA8-\u0005\u0005I\u0011QA9\u0011%\t9HFA\u0001\n\u0003\u000bI\bC\u0005\u0002\fZ\t\t\u0011\"\u0003\u0002\u000e\u001a)1\u0006\n\u0001\u0002\u0016\"11\u0007\bC\u0001\u0003/Cq!a'\u001d\t\u0003\ti\nC\u0004\u0002@r!\t!!(\t\u000f\u0005\rG\u0004\"\u0001\u0002\u001e\"9\u0011q\u0019\u000f\u0005\u0002\u0005u\u0005bBAf9\u0011\u0005\u0011QT\u0001\t\u0015N|g\u000eV3ti*\u0011QEJ\u0001\u0006kRLGn\u001d\u0006\u0002O\u0005)1.\u00194lC\u000e\u0001\u0001C\u0001\u0016\u0002\u001b\u0005!#\u0001\u0003&t_:$Vm\u001d;\u0014\u0005\u0005i\u0003C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002S\tQA+Z:u\u001f\nTWm\u0019;\u0014\t\risG\u000f\t\u0003]aJ!!O\u0018\u0003\u000fA\u0013x\u000eZ;diB\u00111h\u0011\b\u0003y\u0005s!!\u0010!\u000e\u0003yR!a\u0010\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0014B\u0001\"0\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001R#\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\t{\u0013a\u00014p_V\t\u0001\n\u0005\u0002J\u001b:\u0011!j\u0013\t\u0003{=J!\u0001T\u0018\u0002\rA\u0013X\rZ3g\u0013\tquJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0019>\nAAZ8pA\u0005\u0019!-\u0019:\u0016\u0003M\u0003\"A\f+\n\u0005U{#aA%oi\u0006!!-\u0019:!)\rA&L\u001b\t\u00033\u000ei\u0011!\u0001\u0005\u0006\r\"\u0001\r\u0001\u0013\u0015\u00055rC\u0017\u000e\u0005\u0002^M6\taL\u0003\u0002`A\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\u0005\u0005\u0014\u0017a\u00026bG.\u001cxN\u001c\u0006\u0003G\u0012\f\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0003\u0015\f1aY8n\u0013\t9gL\u0001\u0007Kg>t\u0007K]8qKJ$\u00180A\u0003wC2,X-I\u0001G\u0011\u0015\t\u0006\u00021\u0001TQ\u0011QG\f\u001b7\"\u0003E\u000bAaY8qsR\u0019\u0001l\u001c9\t\u000f\u0019K\u0001\u0013!a\u0001\u0011\"9\u0011+\u0003I\u0001\u0002\u0004\u0019\u0016AD2paf$C-\u001a4bk2$H%M\u000b\u0002g*\u0012\u0001\n^\u0016\u0002kB\u0011aO_\u0007\u0002o*\u0011\u00010_\u0001\nk:\u001c\u0007.Z2lK\u0012T!aX\u0018\n\u0005m<(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012T#\u0001@+\u0005M#\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u0004A!\u0011QAA\b\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011\u0001\u00027b]\u001eT!!!\u0004\u0002\t)\fg/Y\u0005\u0004\u001d\u0006\u001d\u0011\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003/\ti\u0002E\u0002/\u00033I1!a\u00070\u0005\r\te.\u001f\u0005\t\u0003?q\u0011\u0011!a\u0001'\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\n\u0011\r\u0005\u001d\u0012QFA\f\u001b\t\tICC\u0002\u0002,=\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty#!\u000b\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003k\tY\u0004E\u0002/\u0003oI1!!\u000f0\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\b\u0011\u0003\u0003\u0005\r!a\u0006\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003\u0007\t\t\u0005\u0003\u0005\u0002 E\t\t\u00111\u0001T\u0003!A\u0017m\u001d5D_\u0012,G#A*\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0001\u0002\r\u0015\fX/\u00197t)\u0011\t)$a\u0014\t\u0013\u0005}A#!AA\u0002\u0005]\u0011A\u0003+fgR|%M[3diB\u0011\u0011LF\n\u0006-\u0005]\u00131\r\t\b\u00033\ny\u0006S*Y\u001b\t\tYFC\u0002\u0002^=\nqA];oi&lW-\u0003\u0003\u0002b\u0005m#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011QMA6\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0011AA5p\u0013\r!\u0015q\r\u000b\u0003\u0003'\nQ!\u00199qYf$R\u0001WA:\u0003kBQAR\rA\u0002!CQ!U\rA\u0002M\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002|\u0005\u001d\u0005#\u0002\u0018\u0002~\u0005\u0005\u0015bAA@_\t1q\n\u001d;j_:\u0004RALAB\u0011NK1!!\"0\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011\u0012\u000e\u0002\u0002\u0003\u0007\u0001,A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a$\u0011\t\u0005\u0015\u0011\u0011S\u0005\u0005\u0003'\u000b9A\u0001\u0004PE*,7\r^\n\u000395\"\"!!'\u0011\u0005)b\u0012!\u0004;fgRT5o\u001c8QCJ\u001cX\r\u0006\u0002\u0002 B\u0019a&!)\n\u0007\u0005\rvF\u0001\u0003V]&$\bf\u0001\u0010\u0002(B!\u0011\u0011VA^\u001b\t\tYK\u0003\u0003\u0002.\u0006=\u0016aA1qS*!\u0011\u0011WAZ\u0003\u001dQW\u000f]5uKJTA!!.\u00028\u0006)!.\u001e8ji*\u0011\u0011\u0011X\u0001\u0004_J<\u0017\u0002BA_\u0003W\u0013A\u0001V3ti\u0006\u0011B/Z:u\u000b:\u001cw\u000eZ3BgN#(/\u001b8hQ\ry\u0012qU\u0001\u0012i\u0016\u001cH/\u00128d_\u0012,\u0017i\u001d\"zi\u0016\u001c\bf\u0001\u0011\u0002(\u0006YA/Z:u!\u0006\u00148/\u001a+pQ\r\t\u0013qU\u0001\u001bi\u0016\u001cH\u000fU1sg\u0016$vnV5uQ&sg/\u00197jI*\u001bxN\u001c\u0015\u0004E\u0005\u001d\u0006")
public class JsonTest {
    @Test
    public void testJsonParse() {
        JsonNodeFactory jnf = JsonNodeFactory.instance;
        Assertions.assertEquals((Object)new Some((Object)JsonValue$.MODULE$.apply((JsonNode)new ObjectNode(jnf))), (Object)Json$.MODULE$.parseFull("{}"));
        Assertions.assertEquals((Object)new Right((Object)JsonValue$.MODULE$.apply((JsonNode)new ObjectNode(jnf))), (Object)Json$.MODULE$.tryParseFull("{}"));
        Assertions.assertEquals(Left.class, (Object)Json$.MODULE$.tryParseFull(null).getClass());
        Assertions.assertThrows(IllegalArgumentException.class, () -> Json$.MODULE$.tryParseBytes(null));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)Json$.MODULE$.parseFull(""));
        Assertions.assertEquals(Left.class, (Object)Json$.MODULE$.tryParseFull("").getClass());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)Json$.MODULE$.parseFull("{\"foo\":\"bar\"s}"));
        Assertions.assertTrue((boolean)(Json$.MODULE$.tryParseFull("{\"foo\":\"bar\"s}") instanceof Left));
        ObjectNode objectNode = new ObjectNode(jnf, CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)new TextNode("bar")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"is_enabled"), (Object)BooleanNode.TRUE)}))).asJava());
        Assertions.assertEquals((Object)new Some((Object)JsonValue$.MODULE$.apply((JsonNode)objectNode)), (Object)Json$.MODULE$.parseFull("{\"foo\":\"bar\", \"is_enabled\":true}"));
        Assertions.assertEquals((Object)new Right((Object)JsonValue$.MODULE$.apply((JsonNode)objectNode)), (Object)Json$.MODULE$.tryParseFull("{\"foo\":\"bar\", \"is_enabled\":true}"));
        ArrayNode arrayNode = new ArrayNode(jnf);
        ((Vector)((StrictOptimizedIterableOps)package$.MODULE$.Vector().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).map((Function1 & Serializable)x$1 -> JsonTest.$anonfun$testJsonParse$2(BoxesRunTime.unboxToInt((Object)x$1)))).foreach((Function1 & Serializable)x$1 -> arrayNode.add(x$1));
        Assertions.assertEquals((Object)new Some((Object)JsonValue$.MODULE$.apply((JsonNode)arrayNode)), (Object)Json$.MODULE$.parseFull("[1, 2, 3]"));
        java.util.Map map = CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo1"), (Object)"bar1\\,bar2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo2"), (Object)"\\bar")}))).asJava();
        String encoded = Json$.MODULE$.encodeAsString((Object)map);
        Assertions.assertEquals((Object)Json$.MODULE$.parseFull(encoded), (Object)Json$.MODULE$.parseFull("{\"foo1\":\"bar1\\\\,bar2\", \"foo2\":\"\\\\bar\"}"));
    }

    @Test
    public void testEncodeAsString() {
        Assertions.assertEquals((Object)"null", (Object)Json$.MODULE$.encodeAsString(null));
        Assertions.assertEquals((Object)"1", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToInteger((int)1)));
        Assertions.assertEquals((Object)"1", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((Object)"1", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToByte((byte)((byte)1))));
        Assertions.assertEquals((Object)"1", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToShort((short)((short)1))));
        Assertions.assertEquals((Object)"1.0", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToDouble((double)1.0)));
        Assertions.assertEquals((Object)"\"str\"", (Object)Json$.MODULE$.encodeAsString((Object)"str"));
        Assertions.assertEquals((Object)"true", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToBoolean((boolean)true)));
        Assertions.assertEquals((Object)"false", (Object)Json$.MODULE$.encodeAsString((Object)BoxesRunTime.boxToBoolean((boolean)false)));
        Assertions.assertEquals((Object)"[]", (Object)Json$.MODULE$.encodeAsString((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava()));
        Assertions.assertEquals((Object)"[null]", (Object)Json$.MODULE$.encodeAsString((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))).asJava()));
        Assertions.assertEquals((Object)"[1,2,3]", (Object)Json$.MODULE$.encodeAsString((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).asJava()));
        Assertions.assertEquals((Object)"[1,\"2\",[3],null]", (Object)Json$.MODULE$.encodeAsString((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3}))).asJava(), null}))).asJava()));
        Assertions.assertEquals((Object)"{}", (Object)Json$.MODULE$.encodeAsString((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).asJava()));
        Assertions.assertEquals((Object)"{\"a\":1,\"b\":2,\"c\":null}", (Object)Json$.MODULE$.encodeAsString((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null)}))).asJava()));
        Assertions.assertEquals((Object)"{\"a\":[1,2],\"c\":[3,4]}", (Object)Json$.MODULE$.encodeAsString((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4}))).asJava())}))).asJava()));
        Assertions.assertEquals((Object)"{\"a\":[1,2],\"b\":[3,4],\"c\":null}", (Object)Json$.MODULE$.encodeAsString((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null)}))).asJava()));
        Assertions.assertEquals((Object)"\"str1\\\\,str2\"", (Object)Json$.MODULE$.encodeAsString((Object)"str1\\,str2"));
        Assertions.assertEquals((Object)"\"\\\"quoted\\\"\"", (Object)Json$.MODULE$.encodeAsString((Object)"\"quoted\""));
    }

    @Test
    public void testEncodeAsBytes() {
        Assertions.assertEquals((Object)"null", (Object)new String(Json$.MODULE$.encodeAsBytes(null), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"1", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToInteger((int)1)), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"1", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToLong((long)1L)), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"1", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToByte((byte)((byte)1))), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"1", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToShort((short)((short)1))), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"1.0", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToDouble((double)1.0)), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"\"str\"", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)"str"), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"true", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToBoolean((boolean)true)), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"false", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)BoxesRunTime.boxToBoolean((boolean)false)), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"[]", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Nil$.MODULE$).asJava()), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"[null]", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Null$[]{null}))).asJava()), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"[1,2,3]", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))).asJava()), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"[1,\"2\",[3],null]", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "2", CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3}))).asJava(), null}))).asJava()), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"{}", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)).asJava()), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"{\"a\":1,\"b\":2,\"c\":null}", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null)}))).asJava()), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"{\"a\":[1,2],\"c\":[3,4]}", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4}))).asJava())}))).asJava()), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"{\"a\":[1,2],\"b\":[3,4],\"c\":null}", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)CollectionConverters$.MODULE$.MapHasAsJava((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4}))).asJava()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), null)}))).asJava()), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"\"str1\\\\,str2\"", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)"str1\\,str2"), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)"\"\\\"quoted\\\"\"", (Object)new String(Json$.MODULE$.encodeAsBytes((Object)"\"quoted\""), StandardCharsets.UTF_8));
    }

    @Test
    public void testParseTo() {
        String foo = "baz";
        int bar = 1;
        Either result = Json$.MODULE$.parseStringAs(new StringBuilder(20).append("{\"foo\": \"").append(foo).append("\", \"bar\": ").append(bar).append("}").toString(), ClassTag$.MODULE$.apply(TestObject.class));
        Assertions.assertEquals((Object)new Right((Object)new TestObject(foo, bar)), (Object)result);
    }

    @Test
    public void testParseToWithInvalidJson() {
        Either result = Json$.MODULE$.parseStringAs("{invalid json}", ClassTag$.MODULE$.apply(TestObject.class));
        Assertions.assertEquals((Object)new Left(JsonParseException.class), (Object)result.left().map((Function1 & Serializable)x$2 -> x$2.getClass()));
    }

    public static final /* synthetic */ IntNode $anonfun$testJsonParse$2(int x$1) {
        return new IntNode(x$1);
    }

    public static class TestObject
    implements Product,
    Serializable {
        private final String foo;
        private final int bar;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String foo() {
            return this.foo;
        }

        public int bar() {
            return this.bar;
        }

        public TestObject copy(String foo, int bar) {
            return new TestObject(foo, bar);
        }

        public String copy$default$1() {
            return this.foo();
        }

        public int copy$default$2() {
            return this.bar();
        }

        public String productPrefix() {
            return "TestObject";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.foo();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this.bar());
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof TestObject;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "foo";
                }
                case 1: {
                    return "bar";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return Statics.finalizeHash((int)Statics.mix((int)Statics.mix((int)Statics.mix((int)-889275714, (int)this.productPrefix().hashCode()), (int)Statics.anyHash((Object)this.foo())), (int)this.bar()), (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof TestObject)) break block3;
                    TestObject testObject = (TestObject)x$1;
                    if (this.bar() != testObject.bar()) break block3;
                    String string = this.foo();
                    String string2 = testObject.foo();
                    if ((string != null ? !string.equals(string2) : string2 != null) || !testObject.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public TestObject(@JsonProperty(value="foo") String foo, @JsonProperty(value="bar") int bar) {
            this.foo = foo;
            this.bar = bar;
            Product.$init$((Product)this);
        }
    }
}

