/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.credentials.extractor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Base64;
import java.util.Optional;
import java.util.zip.Inflater;
import lombok.Generated;
import org.apereo.cas.client.Protocol;
import org.apereo.cas.client.util.XmlUtils;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextHelper;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.SessionKeyCredentials;
import org.pac4j.core.credentials.TokenCredentials;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.logout.LogoutType;
import org.pac4j.core.util.CommonHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasCredentialsExtractor
implements CredentialsExtractor {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCredentialsExtractor.class);
    private static final int DECOMPRESSION_FACTOR = 10;
    protected CasConfiguration configuration;

    public CasCredentialsExtractor(CasConfiguration configuration) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)configuration));
        this.configuration = configuration;
    }

    public Optional<Credentials> extract(CallContext ctx) {
        TokenCredentials credentials = null;
        WebContext webContext = ctx.webContext();
        if (this.isTokenRequest(webContext)) {
            String ticket = this.getArtifactParameter(webContext).get();
            credentials = new TokenCredentials(ticket);
        } else if (this.isBackLogoutRequest(webContext)) {
            String logoutMessage = (String)webContext.getRequestParameter("logoutRequest").get();
            LOGGER.trace("Logout request:\n{}", (Object)logoutMessage);
            String ticket = XmlUtils.getTextForElement((String)logoutMessage, (String)"SessionIndex");
            credentials = new SessionKeyCredentials(LogoutType.BACK, ticket);
        } else if (this.isFrontLogoutRequest(webContext)) {
            String logoutMessage = this.uncompressLogoutMessage((String)webContext.getRequestParameter("logoutRequest").get());
            LOGGER.trace("Logout request:\n{}", (Object)logoutMessage);
            String ticket = XmlUtils.getTextForElement((String)logoutMessage, (String)"SessionIndex");
            credentials = new SessionKeyCredentials(LogoutType.FRONT, ticket);
        }
        LOGGER.debug("extracted credentials: {}", (Object)credentials);
        return Optional.ofNullable(credentials);
    }

    protected boolean isTokenRequest(WebContext context) {
        return this.getArtifactParameter(context).isPresent();
    }

    protected Optional<String> getArtifactParameter(WebContext context) {
        Optional optValue;
        if (this.configuration.getProtocol() == CasProtocol.SAML && (optValue = context.getRequestParameter(Protocol.SAML11.getArtifactParameterName())).isPresent()) {
            return optValue;
        }
        return context.getRequestParameter("ticket");
    }

    protected boolean isBackLogoutRequest(WebContext context) {
        return WebContextHelper.isPost((WebContext)context) && !this.isMultipartRequest(context) && context.getRequestParameter("logoutRequest").isPresent();
    }

    protected boolean isMultipartRequest(WebContext context) {
        Optional contentType = context.getRequestHeader("Content-Type");
        return contentType.isPresent() && ((String)contentType.get()).toLowerCase().startsWith("multipart");
    }

    protected boolean isFrontLogoutRequest(WebContext context) {
        return WebContextHelper.isGet((WebContext)context) && context.getRequestParameter("logoutRequest").isPresent();
    }

    protected String uncompressLogoutMessage(String originalMessage) {
        byte[] binaryMessage = Base64.getMimeDecoder().decode(originalMessage);
        Inflater decompresser = null;
        try {
            decompresser = new Inflater();
            decompresser.setInput(binaryMessage);
            byte[] result = new byte[binaryMessage.length * 10];
            int resultLength = decompresser.inflate(result);
            String string = new String(result, 0, resultLength, "UTF-8");
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Unable to decompress logout message", (Throwable)e);
            throw new TechnicalException((Throwable)e);
        }
        finally {
            if (decompresser != null) {
                decompresser.end();
            }
        }
    }
}

