/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.codegen;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.hops.codegen.SpoofCompiler;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.codegen.ByteClassLoader;
import org.apache.sysml.runtime.codegen.SpoofOperator;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.util.LocalFileUtils;
import org.apache.sysml.utils.Statistics;
import org.codehaus.janino.SimpleCompiler;

public class CodegenUtils {
    private static final Log LOG = LogFactory.getLog((String)CodegenUtils.class.getName());
    private static ConcurrentHashMap<String, Class<?>> _cache = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, String> _src = new ConcurrentHashMap();
    private static String _workingDir = null;

    public static Class<?> compileClass(String name, String src) {
        Class<?> ret = _cache.get(name);
        if (ret != null) {
            return ret;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        ret = SpoofCompiler.JAVA_COMPILER == SpoofCompiler.CompilerType.JANINO ? CodegenUtils.compileClassJanino(name, src) : CodegenUtils.compileClassJavac(name, src);
        _cache.put(name, ret);
        if (DMLScript.STATISTICS) {
            Statistics.incrementCodegenClassCompile();
            Statistics.incrementCodegenClassCompileTime(System.nanoTime() - t0);
        }
        return ret;
    }

    public static Class<?> getClass(String name) {
        return CodegenUtils.getClass(name, null);
    }

    public static synchronized Class<?> getClassSync(String name, byte[] classBytes) {
        return CodegenUtils.getClass(name, classBytes);
    }

    public static Class<?> getClass(String name, byte[] classBytes) {
        Class<?> ret = _cache.get(name);
        if (ret != null) {
            return ret;
        }
        ret = SpoofCompiler.JAVA_COMPILER == SpoofCompiler.CompilerType.JANINO ? CodegenUtils.compileClassJanino(name, new String(classBytes)) : CodegenUtils.loadFromClassFile(name, classBytes);
        _cache.put(name, ret);
        return ret;
    }

    public static byte[] getClassData(String name) {
        if (SpoofCompiler.JAVA_COMPILER == SpoofCompiler.CompilerType.JANINO) {
            return _src.get(name).getBytes();
        }
        return CodegenUtils.getClassAsByteArray(name);
    }

    public static void clearClassCache() {
        _cache.clear();
        _src.clear();
    }

    public static void clearClassCache(Class<?> cla) {
        Iterator<Map.Entry<String, Class<?>>> iter = _cache.entrySet().iterator();
        while (iter.hasNext()) {
            if (iter.next().getValue() != cla) continue;
            iter.remove();
        }
    }

    public static SpoofOperator createInstance(Class<?> cla) {
        SpoofOperator ret = null;
        try {
            ret = (SpoofOperator)cla.newInstance();
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return ret;
    }

    public static SpoofOperator.SideInput createSideInput(MatrixBlock in) {
        SpoofOperator.SideInput ret = in.isInSparseFormat() || !in.isAllocated() ? new SpoofOperator.SideInput(null, in, in.getNumColumns()) : new SpoofOperator.SideInput(in.getDenseBlock(), null, in.getNumColumns());
        return ret.mdat != null ? new SpoofOperator.SideInputSparseCell(ret) : ret;
    }

    private static Class<?> compileClassJanino(String name, String src) {
        try {
            SimpleCompiler compiler = new SimpleCompiler();
            compiler.cook(src);
            _src.put(name, src);
            return compiler.getClassLoader().loadClass(name);
        }
        catch (Exception ex) {
            LOG.error((Object)("Failed to compile class " + name + ": \n" + src));
            throw new DMLRuntimeException("Failed to compile class " + name + ".", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> compileClassJavac(String name, String src) {
        Class<?> clazz;
        File ftmp;
        if (_workingDir == null) {
            CodegenUtils.createWorkingDir();
        }
        if (!(ftmp = new File(_workingDir + "/" + name.replace(".", "/") + ".java")).getParentFile().exists()) {
            ftmp.getParentFile().mkdirs();
        }
        LocalFileUtils.writeTextFile(ftmp, src);
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new RuntimeException("Unable to obtain system java compiler.");
        }
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(diagnostics, null, null);
        Iterable<? extends JavaFileObject> sources = fileManager.getJavaFileObjectsFromFiles(Arrays.asList(ftmp));
        URL runDir = CodegenUtils.class.getProtectionDomain().getCodeSource().getLocation();
        String classpath = System.getProperty("java.class.path") + File.pathSeparator + runDir.getPath();
        List<String> options = Arrays.asList("-classpath", classpath);
        JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, diagnostics, options, null, sources);
        Boolean success = task.call();
        for (Diagnostic tmp : diagnostics.getDiagnostics()) {
            if (tmp.getKind() != Diagnostic.Kind.ERROR) continue;
            System.err.println("ERROR: " + tmp.toString());
        }
        if (success == null || !success.booleanValue()) {
            throw new RuntimeException("Failed to compile class " + name);
        }
        URLClassLoader classLoader = null;
        try {
            classLoader = new URLClassLoader(new URL[]{new File(_workingDir).toURI().toURL(), runDir}, CodegenUtils.class.getClassLoader());
            clazz = classLoader.loadClass(name);
        }
        catch (Throwable throwable) {
            try {
                IOUtilFunctions.closeSilently(classLoader);
                throw throwable;
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to compile class " + name + ": \n" + src));
                throw new DMLRuntimeException("Failed to compile class " + name + ".", ex);
            }
        }
        IOUtilFunctions.closeSilently(classLoader);
        return clazz;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Class<?> loadFromClassFile(String name, byte[] classBytes) {
        if (classBytes != null) {
            try (ByteClassLoader byteLoader = new ByteClassLoader(new URL[0], CodegenUtils.class.getClassLoader(), classBytes);){
                Class<?> clazz = byteLoader.findClass(name);
                return clazz;
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
        }
        URL runDir = CodegenUtils.class.getProtectionDomain().getCodeSource().getLocation();
        try (URLClassLoader classLoader = new URLClassLoader(new URL[]{new File(_workingDir).toURI().toURL(), runDir}, CodegenUtils.class.getClassLoader());){
            Class<?> clazz = classLoader.loadClass(name);
            return clazz;
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
    }

    private static byte[] getClassAsByteArray(String name) {
        byte[] byArray;
        String classAsPath = name.replace('.', '/') + ".class";
        URLClassLoader classLoader = null;
        InputStream stream = null;
        try {
            URL runDir = CodegenUtils.class.getProtectionDomain().getCodeSource().getLocation();
            classLoader = new URLClassLoader(new URL[]{new File(_workingDir).toURI().toURL(), runDir}, CodegenUtils.class.getClassLoader());
            stream = classLoader.getResourceAsStream(classAsPath);
            byArray = IOUtils.toByteArray((InputStream)stream);
        }
        catch (IOException e) {
            try {
                throw new DMLRuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtilFunctions.closeSilently(classLoader);
                IOUtilFunctions.closeSilently(stream);
                throw throwable;
            }
        }
        IOUtilFunctions.closeSilently(classLoader);
        IOUtilFunctions.closeSilently(stream);
        return byArray;
    }

    private static void createWorkingDir() {
        if (_workingDir != null) {
            return;
        }
        String tmp = LocalFileUtils.getWorkingDir("codegen");
        LocalFileUtils.createLocalFileIfNotExist(tmp);
        _workingDir = tmp;
    }
}

