/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.util.UtilFunctions;

public class FrameReblockBuffer {
    public static final int DEFAULT_BUFFER_SIZE = 5000000;
    private int _bufflen = -1;
    private int _count = -1;
    private FrameCell[] _buff = null;
    private long _rlen = -1L;
    private long _clen = -1L;
    private int _brlen = -1;
    private int _bclen = -1;
    private Expression.ValueType[] _schema;

    public FrameReblockBuffer(int buffersize, long rlen, long clen, Expression.ValueType[] schema) {
        this._bufflen = buffersize;
        this._count = 0;
        this._buff = new FrameCell[this._bufflen];
        for (int i = 0; i < this._bufflen; ++i) {
            this._buff[i] = new FrameCell();
        }
        this._rlen = rlen;
        this._clen = clen;
        this._brlen = Math.max((int)((long)this._bufflen / this._clen), 1);
        this._bclen = (int)clen;
        this._schema = schema;
    }

    public int getSize() {
        return this._count;
    }

    public int getCapacity() {
        return this._bufflen;
    }

    public void appendCell(long r, long c, Object obj) {
        this._buff[this._count].setRow((int)r);
        this._buff[this._count].setCol((int)c);
        this._buff[this._count].setObjVal(obj);
        ++this._count;
    }

    public void flushBufferToBinaryBlocks(ArrayList<Pair<Long, FrameBlock>> outList) throws IOException, DMLRuntimeException {
        if (this._count == 0) {
            return;
        }
        Arrays.sort(this._buff, 0, this._count, new FrameReblockBufferComparator());
        Long tmpIx = -1L;
        FrameBlock tmpBlock = new FrameBlock(this._schema);
        long cbi = -1L;
        long cbj = -1L;
        for (int i = 0; i < this._count; ++i) {
            long bi = Math.max(UtilFunctions.computeBlockIndex(this._buff[i].getRow(), this._brlen), 1L);
            long bj = UtilFunctions.computeBlockIndex(this._buff[i].getCol(), this._bclen);
            if (bi != cbi || bj != cbj) {
                if (cbi != -1L && cbj != -1L) {
                    FrameReblockBuffer.outputBlock(outList, tmpIx, tmpBlock);
                }
                cbi = bi;
                cbj = bj;
                tmpIx = (bi - 1L) * (long)this._brlen + 1L;
                tmpBlock = new FrameBlock(this._schema);
                tmpBlock.ensureAllocatedColumns(Math.min(this._brlen, (int)(this._rlen - (bi - 1L) * (long)this._brlen)));
            }
            int ci = UtilFunctions.computeCellInBlock(this._buff[i].getRow(), this._brlen);
            int cj = UtilFunctions.computeCellInBlock(this._buff[i].getCol(), this._bclen);
            if (ci == -3) {
                tmpBlock.getColumnMetadata(cj).setMvValue(this._buff[i].getObjVal().toString());
                continue;
            }
            if (ci == -2) {
                tmpBlock.getColumnMetadata(cj).setNumDistinct(Long.parseLong(this._buff[i].getObjVal().toString()));
                continue;
            }
            tmpBlock.set(ci, cj, this._buff[i].getObjVal());
        }
        if (cbi != -1L && cbj != -1L) {
            FrameReblockBuffer.outputBlock(outList, tmpIx, tmpBlock);
        }
        this._count = 0;
    }

    private static void outputBlock(ArrayList<Pair<Long, FrameBlock>> out, Long key, FrameBlock value) throws IOException, DMLRuntimeException {
        if (key == -1L) {
            return;
        }
        out.add(new Pair<Long, FrameBlock>(new Long(key), value));
    }

    private static class FrameReblockBufferComparator
    implements Comparator<FrameCell> {
        private FrameReblockBufferComparator() {
        }

        @Override
        public int compare(FrameCell arg0, FrameCell arg1) {
            long bi0 = arg0.getRow();
            long bj0 = arg0.getCol();
            long bi1 = arg1.getRow();
            long bj1 = arg1.getCol();
            return bi0 < bi1 || bi0 == bi1 && bj0 < bj1 ? -1 : (bi0 == bi1 && bj0 == bj1 ? 0 : 1);
        }
    }

    private static class FrameCell {
        private int iRow;
        private int iCol;
        private Object objVal;

        private FrameCell() {
        }

        public int getRow() {
            return this.iRow;
        }

        public void setRow(int iRow) {
            this.iRow = iRow;
        }

        public int getCol() {
            return this.iCol;
        }

        public void setCol(int iCol) {
            this.iCol = iCol;
        }

        public Object getObjVal() {
            return this.objVal;
        }

        public void setObjVal(Object objVal) {
            this.objVal = objVal;
        }
    }
}

