/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.parfor.ResultMerge;
import org.apache.sysml.runtime.controlprogram.parfor.util.Cell;
import org.apache.sysml.runtime.controlprogram.parfor.util.IDSequence;
import org.apache.sysml.runtime.controlprogram.parfor.util.StagingFileUtils;
import org.apache.sysml.runtime.io.IOUtilFunctions;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.MetaDataFormat;
import org.apache.sysml.runtime.matrix.data.DenseBlock;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.util.DataConverter;
import org.apache.sysml.runtime.util.FastStringTokenizer;
import org.apache.sysml.runtime.util.LocalFileUtils;
import org.apache.sysml.runtime.util.MapReduceTool;

public class ResultMergeLocalFile
extends ResultMerge {
    private static final long serialVersionUID = -6905893742840020489L;
    public static final boolean ALLOW_COPY_CELLFILES = false;
    private IDSequence _seq = new IDSequence();

    public ResultMergeLocalFile(MatrixObject out, MatrixObject[] in, String outputFilename, boolean accum) {
        super(out, in, outputFilename, accum);
    }

    @Override
    public MatrixObject executeSerialMerge() {
        MatrixObject moNew = null;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ResultMerge (local, file): Execute serial merge for output " + this._output.hashCode() + " (fname=" + this._output.getFileName() + ")"));
        }
        try {
            ArrayList<MatrixObject> inMO = new ArrayList<MatrixObject>();
            for (MatrixObject in : this._inputs) {
                if (in == null || in == this._output) continue;
                in.exportData();
                inMO.add(in);
            }
            if (!inMO.isEmpty()) {
                this._output.exportData();
                this.merge(this._outputFName, this._output, inMO);
                moNew = this.createNewMatrixObject(this._output, inMO);
            } else {
                moNew = this._output;
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
        return moNew;
    }

    @Override
    public MatrixObject executeParallelMerge(int par) {
        return this.executeSerialMerge();
    }

    private MatrixObject createNewMatrixObject(MatrixObject output, ArrayList<MatrixObject> inMO) {
        MetaDataFormat metadata = (MetaDataFormat)this._output.getMetaData();
        MatrixObject moNew = new MatrixObject(this._output.getValueType(), this._outputFName);
        MatrixCharacteristics mcOld = metadata.getMatrixCharacteristics();
        OutputInfo oiOld = metadata.getOutputInfo();
        InputInfo iiOld = metadata.getInputInfo();
        MatrixCharacteristics mc = new MatrixCharacteristics(mcOld);
        mc.setNonZeros(this._isAccum ? -1L : this.computeNonZeros(output, inMO));
        MetaDataFormat meta = new MetaDataFormat(mc, oiOld, iiOld);
        moNew.setMetaData(meta);
        return moNew;
    }

    private void merge(String fnameNew, MatrixObject outMo, ArrayList<MatrixObject> inMO) {
        boolean withCompare;
        OutputInfo oi = ((MetaDataFormat)outMo.getMetaData()).getOutputInfo();
        boolean bl = withCompare = outMo.getNnz() != 0L;
        if (oi == OutputInfo.TextCellOutputInfo) {
            if (withCompare) {
                this.mergeTextCellWithComp(fnameNew, outMo, inMO);
            } else {
                ResultMergeLocalFile.mergeTextCellWithoutComp(fnameNew, outMo, inMO);
            }
        } else if (oi == OutputInfo.BinaryCellOutputInfo) {
            if (withCompare) {
                this.mergeBinaryCellWithComp(fnameNew, outMo, inMO);
            } else {
                ResultMergeLocalFile.mergeBinaryCellWithoutComp(fnameNew, outMo, inMO);
            }
        } else if (oi == OutputInfo.BinaryBlockOutputInfo) {
            if (withCompare) {
                this.mergeBinaryBlockWithComp(fnameNew, outMo, inMO);
            } else {
                this.mergeBinaryBlockWithoutComp(fnameNew, outMo, inMO);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mergeTextCellWithoutComp(String fnameNew, MatrixObject outMo, ArrayList<MatrixObject> inMO) {
        try {
            MapReduceTool.deleteFileIfExistOnHDFS(fnameNew);
            JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            Path path = new Path(fnameNew);
            FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));
            String valueStr = null;
            try {
                for (MatrixObject in : inMO) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("ResultMerge (local, file): Merge input " + in.hashCode() + " (fname=" + in.getFileName() + ") via stream merge"));
                    }
                    JobConf tmpJob = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
                    Path tmpPath = new Path(in.getFileName());
                    FileInputFormat.addInputPath((JobConf)tmpJob, (Path)tmpPath);
                    TextInputFormat informat = new TextInputFormat();
                    informat.configure(tmpJob);
                    InputSplit[] splits = informat.getSplits(tmpJob, 1);
                    LongWritable key = new LongWritable();
                    Text value = new Text();
                    for (InputSplit split : splits) {
                        RecordReader reader = informat.getRecordReader(split, tmpJob, Reporter.NULL);
                        try {
                            while (reader.next((Object)key, (Object)value)) {
                                valueStr = value.toString().trim();
                                out.write(valueStr + "\n");
                            }
                        }
                        finally {
                            IOUtilFunctions.closeSilently(reader);
                        }
                    }
                }
            }
            finally {
                IOUtilFunctions.closeSilently(out);
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to merge text cell results.", ex);
        }
    }

    private void mergeTextCellWithComp(String fnameNew, MatrixObject outMo, ArrayList<MatrixObject> inMO) {
        String fnameStaging = LocalFileUtils.getUniqueWorkingDir("resultmerge");
        String fnameStagingCompare = LocalFileUtils.getUniqueWorkingDir("resultmerge");
        try {
            MapReduceTool.deleteFileIfExistOnHDFS(fnameNew);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("ResultMerge (local, file): Create merge compare matrix for output " + outMo.hashCode() + " (fname=" + outMo.getFileName() + ")"));
            }
            ResultMergeLocalFile.createTextCellStagingFile(fnameStagingCompare, outMo, 0L);
            for (MatrixObject in : inMO) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("ResultMerge (local, file): Merge input " + in.hashCode() + " (fname=" + in.getFileName() + ")"));
                }
                long ID = this._seq.getNextID();
                ResultMergeLocalFile.createTextCellStagingFile(fnameStaging, in, ID);
            }
            this.createTextCellResultFile(fnameStaging, fnameStagingCompare, fnameNew, (MetaDataFormat)outMo.getMetaData(), true);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to merge text cell results.", ex);
        }
        LocalFileUtils.cleanupWorkingDirectory(fnameStaging);
        LocalFileUtils.cleanupWorkingDirectory(fnameStagingCompare);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mergeBinaryCellWithoutComp(String fnameNew, MatrixObject outMo, ArrayList<MatrixObject> inMO) {
        try {
            MapReduceTool.deleteFileIfExistOnHDFS(fnameNew);
            JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
            Path path = new Path(fnameNew);
            FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
            SequenceFile.Writer out = new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixCell.class);
            MatrixIndexes key = new MatrixIndexes();
            MatrixCell value = new MatrixCell();
            try {
                for (MatrixObject in : inMO) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("ResultMerge (local, file): Merge input " + in.hashCode() + " (fname=" + in.getFileName() + ") via stream merge"));
                    }
                    JobConf tmpJob = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
                    Path tmpPath = new Path(in.getFileName());
                    for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, tmpPath)) {
                        SequenceFile.Reader reader = new SequenceFile.Reader(fs, lpath, (Configuration)tmpJob);
                        try {
                            while (reader.next((Writable)key, (Writable)value)) {
                                out.append((Writable)key, (Writable)value);
                            }
                        }
                        finally {
                            IOUtilFunctions.closeSilently((Closeable)reader);
                        }
                    }
                }
            }
            finally {
                IOUtilFunctions.closeSilently((Closeable)out);
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to merge binary cell results.", ex);
        }
    }

    private void mergeBinaryCellWithComp(String fnameNew, MatrixObject outMo, ArrayList<MatrixObject> inMO) {
        String fnameStaging = LocalFileUtils.getUniqueWorkingDir("resultmerge");
        String fnameStagingCompare = LocalFileUtils.getUniqueWorkingDir("resultmerge");
        try {
            MapReduceTool.deleteFileIfExistOnHDFS(fnameNew);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("ResultMerge (local, file): Create merge compare matrix for output " + outMo.hashCode() + " (fname=" + outMo.getFileName() + ")"));
            }
            ResultMergeLocalFile.createBinaryCellStagingFile(fnameStagingCompare, outMo, 0L);
            for (MatrixObject in : inMO) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("ResultMerge (local, file): Merge input " + in.hashCode() + " (fname=" + in.getFileName() + ")"));
                }
                long ID = this._seq.getNextID();
                ResultMergeLocalFile.createBinaryCellStagingFile(fnameStaging, in, ID);
            }
            this.createBinaryCellResultFile(fnameStaging, fnameStagingCompare, fnameNew, (MetaDataFormat)outMo.getMetaData(), true);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to merge binary cell results.", ex);
        }
        LocalFileUtils.cleanupWorkingDirectory(fnameStaging);
        LocalFileUtils.cleanupWorkingDirectory(fnameStagingCompare);
    }

    private void mergeBinaryBlockWithoutComp(String fnameNew, MatrixObject outMo, ArrayList<MatrixObject> inMO) {
        String fnameStaging = LocalFileUtils.getUniqueWorkingDir("resultmerge");
        try {
            MapReduceTool.deleteFileIfExistOnHDFS(fnameNew);
            for (MatrixObject in : inMO) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("ResultMerge (local, file): Merge input " + in.hashCode() + " (fname=" + in.getFileName() + ")"));
                }
                this.createBinaryBlockStagingFile(fnameStaging, in);
            }
            this.createBinaryBlockResultFile(fnameStaging, null, fnameNew, (MetaDataFormat)outMo.getMetaData(), false);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to merge binary block results.", ex);
        }
        LocalFileUtils.cleanupWorkingDirectory(fnameStaging);
    }

    private void mergeBinaryBlockWithComp(String fnameNew, MatrixObject outMo, ArrayList<MatrixObject> inMO) {
        String fnameStaging = LocalFileUtils.getUniqueWorkingDir("resultmerge");
        String fnameStagingCompare = LocalFileUtils.getUniqueWorkingDir("resultmerge");
        try {
            MapReduceTool.deleteFileIfExistOnHDFS(fnameNew);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("ResultMerge (local, file): Create merge compare matrix for output " + outMo.hashCode() + " (fname=" + outMo.getFileName() + ")"));
            }
            this.createBinaryBlockStagingFile(fnameStagingCompare, outMo);
            for (MatrixObject in : inMO) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("ResultMerge (local, file): Merge input " + in.hashCode() + " (fname=" + in.getFileName() + ")"));
                }
                this.createBinaryBlockStagingFile(fnameStaging, in);
            }
            this.createBinaryBlockResultFile(fnameStaging, fnameStagingCompare, fnameNew, (MetaDataFormat)outMo.getMetaData(), true);
        }
        catch (Exception ex) {
            throw new DMLRuntimeException("Unable to merge binary block results.", ex);
        }
        LocalFileUtils.cleanupWorkingDirectory(fnameStaging);
        LocalFileUtils.cleanupWorkingDirectory(fnameStagingCompare);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBinaryBlockStagingFile(String fnameStaging, MatrixObject mo) throws IOException {
        MatrixIndexes key = new MatrixIndexes();
        MatrixBlock value = new MatrixBlock();
        JobConf tmpJob = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path tmpPath = new Path(mo.getFileName());
        FileSystem fs = IOUtilFunctions.getFileSystem(tmpPath, (Configuration)tmpJob);
        for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, tmpPath)) {
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, lpath, (Configuration)tmpJob);
            try {
                while (reader.next((Writable)key, (Writable)value)) {
                    String lname = key.getRowIndex() + "_" + key.getColumnIndex();
                    String dir = fnameStaging + "/" + lname;
                    if (value.getNonZeros() <= 0L) continue;
                    LocalFileUtils.checkAndCreateStagingDir(dir);
                    LocalFileUtils.writeMatrixBlockToLocal(dir + "/" + this._seq.getNextID(), value);
                }
            }
            finally {
                IOUtilFunctions.closeSilently((Closeable)reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTextCellStagingFile(String fnameStaging, MatrixObject mo, long ID) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(mo.getFileName());
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, 1);
        LinkedList<Cell> buffer = new LinkedList<Cell>();
        LongWritable key = new LongWritable();
        Text value = new Text();
        MatrixCharacteristics mc = mo.getMatrixCharacteristics();
        int brlen = mc.getRowsPerBlock();
        int bclen = mc.getColsPerBlock();
        FastStringTokenizer st = new FastStringTokenizer(' ');
        for (InputSplit split : splits) {
            RecordReader reader = informat.getRecordReader(split, job, Reporter.NULL);
            try {
                while (reader.next((Object)key, (Object)value)) {
                    st.reset(value.toString());
                    long row = st.nextLong();
                    long col = st.nextLong();
                    double lvalue = Double.parseDouble(st.nextToken());
                    Cell tmp = new Cell(row, col, lvalue);
                    buffer.addLast(tmp);
                    if (buffer.size() <= 100000) continue;
                    ResultMergeLocalFile.appendCellBufferToStagingArea(fnameStaging, ID, buffer, brlen, bclen);
                    buffer.clear();
                }
                if (buffer.isEmpty()) continue;
                ResultMergeLocalFile.appendCellBufferToStagingArea(fnameStaging, ID, buffer, brlen, bclen);
                buffer.clear();
            }
            finally {
                IOUtilFunctions.closeSilently(reader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createBinaryCellStagingFile(String fnameStaging, MatrixObject mo, long ID) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(mo.getFileName());
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        LinkedList<Cell> buffer = new LinkedList<Cell>();
        MatrixIndexes key = new MatrixIndexes();
        MatrixCell value = new MatrixCell();
        MatrixCharacteristics mc = mo.getMatrixCharacteristics();
        int brlen = mc.getRowsPerBlock();
        int bclen = mc.getColsPerBlock();
        for (Path lpath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
            SequenceFile.Reader reader = new SequenceFile.Reader(fs, lpath, (Configuration)job);
            try {
                while (reader.next((Writable)key, (Writable)value)) {
                    Cell tmp = new Cell(key.getRowIndex(), key.getColumnIndex(), value.getValue());
                    buffer.addLast(tmp);
                    if (buffer.size() <= 100000) continue;
                    ResultMergeLocalFile.appendCellBufferToStagingArea(fnameStaging, ID, buffer, brlen, bclen);
                    buffer.clear();
                }
                if (buffer.isEmpty()) continue;
                ResultMergeLocalFile.appendCellBufferToStagingArea(fnameStaging, ID, buffer, brlen, bclen);
                buffer.clear();
            }
            finally {
                IOUtilFunctions.closeSilently((Closeable)reader);
            }
        }
    }

    private static void appendCellBufferToStagingArea(String fnameStaging, long ID, LinkedList<Cell> buffer, int brlen, int bclen) throws IOException {
        long bcol;
        long brow;
        HashMap sortedBuffer = new HashMap();
        for (Cell cell : buffer) {
            brow = (cell.getRow() - 1L) / (long)brlen + 1L;
            bcol = (cell.getCol() - 1L) / (long)bclen + 1L;
            long row_offset = (brow - 1L) * (long)brlen + 1L;
            long col_offset = (bcol - 1L) * (long)bclen + 1L;
            cell.setRow(cell.getRow() - row_offset);
            cell.setCol(cell.getCol() - col_offset);
            if (!sortedBuffer.containsKey(brow)) {
                sortedBuffer.put(brow, new HashMap());
            }
            if (!((HashMap)sortedBuffer.get(brow)).containsKey(bcol)) {
                ((HashMap)sortedBuffer.get(brow)).put(bcol, new LinkedList());
            }
            ((LinkedList)((HashMap)sortedBuffer.get(brow)).get(bcol)).addLast(cell);
        }
        for (Map.Entry entry : sortedBuffer.entrySet()) {
            brow = (Long)entry.getKey();
            for (Map.Entry e2 : ((HashMap)entry.getValue()).entrySet()) {
                bcol = (Long)e2.getKey();
                String lname = brow + "_" + bcol;
                String dir = fnameStaging + "/" + lname;
                LocalFileUtils.checkAndCreateStagingDir(dir);
                StagingFileUtils.writeCellListToLocal(dir + "/" + ID, (LinkedList)e2.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBinaryBlockResultFile(String fnameStaging, String fnameStagingCompare, String fnameNew, MetaDataFormat metadata, boolean withCompare) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fnameNew);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        MatrixCharacteristics mc = metadata.getMatrixCharacteristics();
        long rlen = mc.getRows();
        long clen = mc.getCols();
        int brlen = mc.getRowsPerBlock();
        int bclen = mc.getColsPerBlock();
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixBlock.class);
        try {
            MatrixIndexes indexes = new MatrixIndexes();
            for (long brow = 1L; brow <= (long)Math.ceil((double)rlen / (double)brlen); ++brow) {
                for (long bcol = 1L; bcol <= (long)Math.ceil((double)clen / (double)bclen); ++bcol) {
                    File dir = new File(fnameStaging + "/" + brow + "_" + bcol);
                    File dir2 = new File(fnameStagingCompare + "/" + brow + "_" + bcol);
                    MatrixBlock mb = null;
                    if (dir.exists()) {
                        if (withCompare && dir2.exists()) {
                            String[] lnames2 = dir2.list();
                            if (lnames2.length != 1) {
                                throw new DMLRuntimeException("Unable to merge results because multiple compare blocks found.");
                            }
                            mb = LocalFileUtils.readMatrixBlockFromLocal(dir2 + "/" + lnames2[0]);
                            boolean appendOnly = mb.isInSparseFormat();
                            DenseBlock compare = DataConverter.convertToDenseBlock(mb, false);
                            for (String lname : dir.list()) {
                                MatrixBlock tmp = LocalFileUtils.readMatrixBlockFromLocal(dir + "/" + lname);
                                this.mergeWithComp(mb, tmp, compare);
                            }
                            if (appendOnly && !this._isAccum) {
                                mb.sortSparseRows();
                            }
                            mb.examSparsity();
                        } else {
                            boolean appendOnly = false;
                            for (String lname : dir.list()) {
                                if (mb == null) {
                                    mb = LocalFileUtils.readMatrixBlockFromLocal(dir + "/" + lname);
                                    appendOnly = mb.isInSparseFormat();
                                    continue;
                                }
                                MatrixBlock tmp = LocalFileUtils.readMatrixBlockFromLocal(dir + "/" + lname);
                                this.mergeWithoutComp(mb, tmp, appendOnly);
                            }
                            if (appendOnly && !this._isAccum) {
                                mb.sortSparseRows();
                            }
                            mb.examSparsity();
                        }
                    } else {
                        int maxRow = (int)((brow - 1L) * (long)brlen + (long)brlen < rlen ? (long)brlen : rlen - (brow - 1L) * (long)brlen);
                        int maxCol = (int)((bcol - 1L) * (long)bclen + (long)bclen < clen ? (long)bclen : clen - (bcol - 1L) * (long)bclen);
                        mb = new MatrixBlock(maxRow, maxCol, true);
                    }
                    indexes.setIndexes(brow, bcol);
                    writer.append((Writable)indexes, (Writable)mb);
                }
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)writer);
        }
    }

    private void createTextCellResultFile(String fnameStaging, String fnameStagingCompare, String fnameNew, MetaDataFormat metadata, boolean withCompare) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fnameNew);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        MatrixCharacteristics mc = metadata.getMatrixCharacteristics();
        long rlen = mc.getRows();
        long clen = mc.getCols();
        int brlen = mc.getRowsPerBlock();
        int bclen = mc.getColsPerBlock();
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(path, true)));){
            StringBuilder sb = new StringBuilder();
            boolean written = false;
            for (long brow = 1L; brow <= (long)Math.ceil((double)rlen / (double)brlen); ++brow) {
                for (long bcol = 1L; bcol <= (long)Math.ceil((double)clen / (double)bclen); ++bcol) {
                    File dir = new File(fnameStaging + "/" + brow + "_" + bcol);
                    File dir2 = new File(fnameStagingCompare + "/" + brow + "_" + bcol);
                    MatrixBlock mb = null;
                    long row_offset = (brow - 1L) * (long)brlen + 1L;
                    long col_offset = (bcol - 1L) * (long)bclen + 1L;
                    if (dir.exists()) {
                        if (withCompare && dir2.exists()) {
                            String[] lnames2 = dir2.list();
                            if (lnames2.length != 1) {
                                throw new DMLRuntimeException("Unable to merge results because multiple compare blocks found.");
                            }
                            mb = StagingFileUtils.readCellList2BlockFromLocal(dir2 + "/" + lnames2[0], brlen, bclen);
                            boolean appendOnly = mb.isInSparseFormat();
                            DenseBlock compare = DataConverter.convertToDenseBlock(mb, false);
                            for (String lname : dir.list()) {
                                MatrixBlock tmp = StagingFileUtils.readCellList2BlockFromLocal(dir + "/" + lname, brlen, bclen);
                                this.mergeWithComp(mb, tmp, compare);
                            }
                            if (appendOnly && !this._isAccum) {
                                mb.sortSparseRows();
                            }
                            mb.examSparsity();
                        } else {
                            boolean appendOnly = false;
                            for (String lname : dir.list()) {
                                if (mb == null) {
                                    mb = StagingFileUtils.readCellList2BlockFromLocal(dir + "/" + lname, brlen, bclen);
                                    appendOnly = mb.isInSparseFormat();
                                    continue;
                                }
                                MatrixBlock tmp = StagingFileUtils.readCellList2BlockFromLocal(dir + "/" + lname, brlen, bclen);
                                this.mergeWithoutComp(mb, tmp, appendOnly);
                            }
                            if (appendOnly && !this._isAccum) {
                                mb.sortSparseRows();
                            }
                            mb.examSparsity();
                        }
                    }
                    if (mb == null) continue;
                    if (mb.isInSparseFormat()) {
                        Iterator<IJV> iter = mb.getSparseBlockIterator();
                        while (iter.hasNext()) {
                            IJV lcell = iter.next();
                            sb.append(row_offset + (long)lcell.getI());
                            sb.append(' ');
                            sb.append(col_offset + (long)lcell.getJ());
                            sb.append(' ');
                            sb.append(lcell.getV());
                            sb.append('\n');
                            out.write(sb.toString());
                            sb.setLength(0);
                            written = true;
                        }
                        continue;
                    }
                    for (int i = 0; i < brlen; ++i) {
                        for (int j = 0; j < bclen; ++j) {
                            double lvalue = mb.getValueDenseUnsafe(i, j);
                            if (lvalue == 0.0) continue;
                            sb.append(row_offset + (long)i);
                            sb.append(' ');
                            sb.append(col_offset + (long)j);
                            sb.append(' ');
                            sb.append(lvalue);
                            sb.append('\n');
                            out.write(sb.toString());
                            sb.setLength(0);
                            written = true;
                        }
                    }
                }
            }
            if (!written) {
                out.write("0 0 0\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBinaryCellResultFile(String fnameStaging, String fnameStagingCompare, String fnameNew, MetaDataFormat metadata, boolean withCompare) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fnameNew);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        MatrixCharacteristics mc = metadata.getMatrixCharacteristics();
        long rlen = mc.getRows();
        long clen = mc.getCols();
        int brlen = mc.getRowsPerBlock();
        int bclen = mc.getColsPerBlock();
        MatrixIndexes indexes = new MatrixIndexes(1L, 1L);
        MatrixCell cell = new MatrixCell(0.0);
        SequenceFile.Writer out = new SequenceFile.Writer(fs, (Configuration)job, path, MatrixIndexes.class, MatrixCell.class);
        try {
            boolean written = false;
            for (long brow = 1L; brow <= (long)Math.ceil((double)rlen / (double)brlen); ++brow) {
                for (long bcol = 1L; bcol <= (long)Math.ceil((double)clen / (double)bclen); ++bcol) {
                    File dir = new File(fnameStaging + "/" + brow + "_" + bcol);
                    File dir2 = new File(fnameStagingCompare + "/" + brow + "_" + bcol);
                    MatrixBlock mb = null;
                    long row_offset = (brow - 1L) * (long)brlen + 1L;
                    long col_offset = (bcol - 1L) * (long)bclen + 1L;
                    if (dir.exists()) {
                        if (withCompare && dir2.exists()) {
                            String[] lnames2 = dir2.list();
                            if (lnames2.length != 1) {
                                throw new DMLRuntimeException("Unable to merge results because multiple compare blocks found.");
                            }
                            mb = StagingFileUtils.readCellList2BlockFromLocal(dir2 + "/" + lnames2[0], brlen, bclen);
                            boolean appendOnly = mb.isInSparseFormat();
                            DenseBlock compare = DataConverter.convertToDenseBlock(mb, false);
                            for (String lname : dir.list()) {
                                MatrixBlock tmp = StagingFileUtils.readCellList2BlockFromLocal(dir + "/" + lname, brlen, bclen);
                                this.mergeWithComp(mb, tmp, compare);
                            }
                            if (appendOnly && !this._isAccum) {
                                mb.sortSparseRows();
                            }
                            mb.examSparsity();
                        } else {
                            boolean appendOnly = false;
                            for (String lname : dir.list()) {
                                if (mb == null) {
                                    mb = StagingFileUtils.readCellList2BlockFromLocal(dir + "/" + lname, brlen, bclen);
                                    appendOnly = mb.isInSparseFormat();
                                    continue;
                                }
                                MatrixBlock tmp = StagingFileUtils.readCellList2BlockFromLocal(dir + "/" + lname, brlen, bclen);
                                this.mergeWithoutComp(mb, tmp, appendOnly);
                            }
                            if (appendOnly && !this._isAccum) {
                                mb.sortSparseRows();
                            }
                            mb.examSparsity();
                        }
                    }
                    if (mb == null) continue;
                    if (mb.isInSparseFormat()) {
                        Iterator<IJV> iter = mb.getSparseBlockIterator();
                        while (iter.hasNext()) {
                            IJV lcell = iter.next();
                            indexes.setIndexes(row_offset + (long)lcell.getI(), col_offset + (long)lcell.getJ());
                            cell.setValue(lcell.getV());
                            out.append((Writable)indexes, (Writable)cell);
                            written = true;
                        }
                        continue;
                    }
                    for (int i = 0; i < brlen; ++i) {
                        for (int j = 0; j < bclen; ++j) {
                            double lvalue = mb.getValueDenseUnsafe(i, j);
                            if (lvalue == 0.0) continue;
                            indexes.setIndexes(row_offset + (long)i, col_offset + (long)j);
                            cell.setValue(lvalue);
                            out.append((Writable)indexes, (Writable)cell);
                            written = true;
                        }
                    }
                }
            }
            if (!written) {
                out.append((Writable)indexes, (Writable)cell);
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)out);
        }
    }

    private static void copyAllFiles(String fnameNew, ArrayList<MatrixObject> inMO) throws IOException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fnameNew);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        fs.mkdirs(path);
        IDSequence seq = new IDSequence();
        for (MatrixObject in : inMO) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("ResultMerge (local, file): Merge input " + in.hashCode() + " (fname=" + in.getFileName() + ") via file rename."));
            }
            Path tmpPath = new Path(in.getFileName());
            String lname = tmpPath.getName();
            fs.rename(tmpPath, new Path(fnameNew + "/" + lname + seq.getNextID()));
        }
    }
}

