/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.context;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.package$;
import org.apache.spark.storage.RDDInfo;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.LongAccumulator;
import org.apache.sysml.api.DMLScript;
import org.apache.sysml.api.mlcontext.MLContext;
import org.apache.sysml.api.mlcontext.MLContextUtil;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.hops.OptimizerUtils;
import org.apache.sysml.lops.Checkpoint;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.compress.CompressedMatrixBlock;
import org.apache.sysml.runtime.controlprogram.Program;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.caching.FrameObject;
import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.instructions.cp.Data;
import org.apache.sysml.runtime.instructions.spark.data.BroadcastObject;
import org.apache.sysml.runtime.instructions.spark.data.LineageObject;
import org.apache.sysml.runtime.instructions.spark.data.PartitionedBlock;
import org.apache.sysml.runtime.instructions.spark.data.PartitionedBroadcast;
import org.apache.sysml.runtime.instructions.spark.data.RDDObject;
import org.apache.sysml.runtime.instructions.spark.functions.ComputeBinaryBlockNnzFunction;
import org.apache.sysml.runtime.instructions.spark.functions.CopyBinaryCellFunction;
import org.apache.sysml.runtime.instructions.spark.functions.CopyFrameBlockPairFunction;
import org.apache.sysml.runtime.instructions.spark.functions.CopyTextInputFunction;
import org.apache.sysml.runtime.instructions.spark.functions.CreateSparseBlockFunction;
import org.apache.sysml.runtime.instructions.spark.utils.FrameRDDConverterUtils;
import org.apache.sysml.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysml.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.FrameBlock;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.SparseBlock;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.util.MapReduceTool;
import org.apache.sysml.runtime.util.UtilFunctions;
import org.apache.sysml.utils.MLContextProxy;
import org.apache.sysml.utils.Statistics;
import scala.Tuple2;

public class SparkExecutionContext
extends ExecutionContext {
    private static final Log LOG = LogFactory.getLog((String)SparkExecutionContext.class.getName());
    private static final boolean LDEBUG = false;
    private static final boolean LAZY_SPARKCTX_CREATION = true;
    private static final boolean ASYNCHRONOUS_VAR_DESTROY = true;
    public static final boolean FAIR_SCHEDULER_MODE = true;
    private static SparkClusterConfig _sconf = null;
    private static JavaSparkContext _spctx = null;
    private static final MemoryManagerParRDDs _parRDDs = new MemoryManagerParRDDs(0.1);
    private static boolean[] _poolBuff = new boolean[InfrastructureAnalyzer.getLocalParallelism()];

    protected SparkExecutionContext(boolean allocateVars, Program prog) {
        super(allocateVars, prog);
        if (DMLScript.rtplatform == DMLScript.RUNTIME_PLATFORM.SPARK) {
            SparkExecutionContext.initSparkContext();
        }
    }

    public JavaSparkContext getSparkContext() {
        SparkExecutionContext.initSparkContext();
        return _spctx;
    }

    public static JavaSparkContext getSparkContextStatic() {
        SparkExecutionContext.initSparkContext();
        return _spctx;
    }

    public static synchronized boolean isSparkContextCreated() {
        return _spctx != null;
    }

    public static void resetSparkContextStatic() {
        _spctx = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Class<SparkExecutionContext> clazz = SparkExecutionContext.class;
        synchronized (SparkExecutionContext.class) {
            if (_spctx != null) {
                _spctx.stop();
                _spctx = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isLazySparkContextCreation() {
        return true;
    }

    private static synchronized void initSparkContext() {
        if (_spctx != null) {
            return;
        }
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MLContext mlCtxObj = MLContextProxy.getActiveMLContext();
        if (mlCtxObj != null) {
            _spctx = MLContextUtil.getJavaSparkContext(mlCtxObj);
        } else {
            SparkConf conf;
            if (DMLScript.USE_LOCAL_SPARK_CONFIG) {
                conf = SparkExecutionContext.createSystemMLSparkConf().setMaster("local[*]").setAppName("My local integration test app");
                conf.set("spark.ui.enabled", "false");
                _spctx = new JavaSparkContext(conf);
            } else {
                conf = SparkExecutionContext.createSystemMLSparkConf();
                _spctx = new JavaSparkContext(conf);
            }
            _parRDDs.clear();
        }
        String strDriverMaxResSize = _spctx.getConf().get("spark.driver.maxResultSize", "1g");
        long driverMaxResSize = UtilFunctions.parseMemorySize(strDriverMaxResSize);
        if (driverMaxResSize != 0L && (double)driverMaxResSize < OptimizerUtils.getLocalMemBudget() && !DMLScript.USE_LOCAL_SPARK_CONFIG) {
            LOG.warn((Object)("Configuration parameter spark.driver.maxResultSize set to " + UtilFunctions.formatMemorySize(driverMaxResSize) + ". You can set it through Spark default configuration setting either to 0 (unlimited) or to available memory budget of size " + UtilFunctions.formatMemorySize((long)OptimizerUtils.getLocalMemBudget()) + "."));
        }
        MRJobConfiguration.addBinaryBlockSerializationFramework(_spctx.hadoopConfiguration());
        if (DMLScript.STATISTICS) {
            Statistics.setSparkCtxCreateTime(System.nanoTime() - t0);
        }
    }

    public static SparkConf createSystemMLSparkConf() {
        String sparkVersion;
        String msgSizeConf;
        SparkConf conf = new SparkConf();
        conf.set("spark.driver.maxResultSize", "0");
        conf.set("spark.scheduler.mode", "FAIR");
        if (!conf.contains("spark.locality.wait")) {
            conf.set("spark.locality.wait", "5s");
        }
        String string = msgSizeConf = UtilFunctions.compareVersion(sparkVersion = package$.MODULE$.SPARK_VERSION(), "2.0.0") < 0 ? "spark.akka.frameSize" : "spark.rpc.message.maxSize";
        if (!conf.contains(msgSizeConf)) {
            conf.set(msgSizeConf, "512");
        }
        return conf;
    }

    public static boolean isLocalMaster() {
        return SparkExecutionContext.getSparkContextStatic().isLocal();
    }

    public JavaPairRDD<MatrixIndexes, MatrixBlock> getBinaryBlockRDDHandleForVariable(String varname) {
        MatrixObject mo = this.getMatrixObject(varname);
        return this.getRDDHandleForMatrixObject(mo, InputInfo.BinaryBlockInputInfo, -1, true);
    }

    public JavaPairRDD<MatrixIndexes, MatrixBlock> getBinaryBlockRDDHandleForVariable(String varname, int numParts, boolean inclEmpty) {
        MatrixObject mo = this.getMatrixObject(varname);
        return this.getRDDHandleForMatrixObject(mo, InputInfo.BinaryBlockInputInfo, numParts, inclEmpty);
    }

    public JavaPairRDD<Long, FrameBlock> getFrameBinaryBlockRDDHandleForVariable(String varname) {
        FrameObject fo = this.getFrameObject(varname);
        JavaPairRDD<?, ?> out = this.getRDDHandleForFrameObject(fo, InputInfo.BinaryBlockInputInfo);
        return out;
    }

    public JavaPairRDD<?, ?> getRDDHandleForVariable(String varname, InputInfo inputInfo, int numParts, boolean inclEmpty) {
        Data dat = this.getVariable(varname);
        if (dat instanceof MatrixObject) {
            MatrixObject mo = this.getMatrixObject(varname);
            return this.getRDDHandleForMatrixObject(mo, inputInfo, numParts, inclEmpty);
        }
        if (dat instanceof FrameObject) {
            FrameObject fo = this.getFrameObject(varname);
            return this.getRDDHandleForFrameObject(fo, inputInfo);
        }
        throw new DMLRuntimeException("Failed to obtain RDD for data type other than matrix or frame.");
    }

    public JavaPairRDD<?, ?> getRDDHandleForMatrixObject(MatrixObject mo, InputInfo inputInfo) {
        return this.getRDDHandleForMatrixObject(mo, inputInfo, -1, true);
    }

    public JavaPairRDD<?, ?> getRDDHandleForMatrixObject(MatrixObject mo, InputInfo inputInfo, int numParts, boolean inclEmpty) {
        JavaSparkContext sc = this.getSparkContext();
        JavaPairRDD rdd = null;
        if (mo.getRDDHandle() != null && (mo.getRDDHandle().isCheckpointRDD() || !mo.isCached(false))) {
            rdd = mo.getRDDHandle().getRDD();
        } else if (mo.isDirty() || mo.isCached(false)) {
            MatrixCharacteristics mc = mo.getMatrixCharacteristics();
            boolean fromFile = false;
            if (!OptimizerUtils.checkSparkCollectMemoryBudget(mc, 0L) || !_parRDDs.reserve(OptimizerUtils.estimatePartitionedSizeExactSparsity(mc))) {
                if (mo.isDirty() || !mo.isHDFSFileExists()) {
                    mo.exportData();
                }
                rdd = sc.hadoopFile(mo.getFileName(), inputInfo.inputFormatClass, inputInfo.inputKeyClass, inputInfo.inputValueClass);
                rdd = SparkUtils.copyBinaryBlockMatrix((JavaPairRDD<MatrixIndexes, MatrixBlock>)rdd);
                fromFile = true;
            } else {
                MatrixBlock mb = (MatrixBlock)mo.acquireRead();
                rdd = SparkExecutionContext.toMatrixJavaPairRDD(sc, mb, (int)mo.getNumRowsPerBlock(), (int)mo.getNumColumnsPerBlock(), numParts, inclEmpty);
                mo.release();
                _parRDDs.registerRDD(rdd.id(), OptimizerUtils.estimatePartitionedSizeExactSparsity(mc), true);
            }
            RDDObject rddhandle = new RDDObject(rdd);
            rddhandle.setHDFSFile(fromFile);
            rddhandle.setParallelizedRDD(!fromFile);
            mo.setRDDHandle(rddhandle);
        } else {
            if (inputInfo == InputInfo.BinaryBlockInputInfo) {
                rdd = sc.hadoopFile(mo.getFileName(), inputInfo.inputFormatClass, inputInfo.inputKeyClass, inputInfo.inputValueClass);
                rdd = SparkUtils.copyBinaryBlockMatrix((JavaPairRDD<MatrixIndexes, MatrixBlock>)rdd);
            } else if (inputInfo == InputInfo.TextCellInputInfo || inputInfo == InputInfo.CSVInputInfo || inputInfo == InputInfo.MatrixMarketInputInfo) {
                rdd = sc.hadoopFile(mo.getFileName(), inputInfo.inputFormatClass, inputInfo.inputKeyClass, inputInfo.inputValueClass);
                rdd = rdd.mapToPair((PairFunction)new CopyTextInputFunction());
            } else if (inputInfo == InputInfo.BinaryCellInputInfo) {
                rdd = sc.hadoopFile(mo.getFileName(), inputInfo.inputFormatClass, inputInfo.inputKeyClass, inputInfo.inputValueClass);
                rdd = rdd.mapToPair((PairFunction)new CopyBinaryCellFunction());
            } else {
                throw new DMLRuntimeException("Incorrect input format in getRDDHandleForVariable");
            }
            RDDObject rddhandle = new RDDObject(rdd);
            rddhandle.setHDFSFile(true);
            mo.setRDDHandle(rddhandle);
        }
        return rdd;
    }

    public JavaPairRDD<?, ?> getRDDHandleForFrameObject(FrameObject fo, InputInfo inputInfo) {
        InputInfo inputInfo2 = inputInfo == InputInfo.BinaryBlockInputInfo ? InputInfo.BinaryBlockFrameInputInfo : inputInfo;
        JavaSparkContext sc = this.getSparkContext();
        JavaPairRDD rdd = null;
        if (fo.getRDDHandle() != null && (fo.getRDDHandle().isCheckpointRDD() || !fo.isCached(false))) {
            rdd = fo.getRDDHandle().getRDD();
        } else if (fo.isDirty() || fo.isCached(false)) {
            MatrixCharacteristics mc = fo.getMatrixCharacteristics();
            boolean fromFile = false;
            if (!OptimizerUtils.checkSparkCollectMemoryBudget(mc, 0L) || !_parRDDs.reserve(OptimizerUtils.estimatePartitionedSizeExactSparsity(mc))) {
                if (fo.isDirty()) {
                    fo.exportData();
                }
                rdd = sc.hadoopFile(fo.getFileName(), inputInfo2.inputFormatClass, inputInfo2.inputKeyClass, inputInfo2.inputValueClass);
                rdd = rdd.mapToPair((PairFunction)new CopyFrameBlockPairFunction());
                fromFile = true;
            } else {
                FrameBlock fb = (FrameBlock)fo.acquireRead();
                rdd = SparkExecutionContext.toFrameJavaPairRDD(sc, fb);
                fo.release();
                _parRDDs.registerRDD(rdd.id(), OptimizerUtils.estimatePartitionedSizeExactSparsity(mc), true);
            }
            RDDObject rddhandle = new RDDObject(rdd);
            rddhandle.setHDFSFile(fromFile);
            fo.setRDDHandle(rddhandle);
        } else {
            if (inputInfo2 == InputInfo.BinaryBlockFrameInputInfo) {
                rdd = sc.hadoopFile(fo.getFileName(), inputInfo2.inputFormatClass, inputInfo2.inputKeyClass, inputInfo2.inputValueClass);
                rdd = rdd.mapToPair((PairFunction)new CopyFrameBlockPairFunction());
            } else if (inputInfo2 == InputInfo.TextCellInputInfo || inputInfo2 == InputInfo.CSVInputInfo || inputInfo2 == InputInfo.MatrixMarketInputInfo) {
                rdd = sc.hadoopFile(fo.getFileName(), inputInfo2.inputFormatClass, inputInfo2.inputKeyClass, inputInfo2.inputValueClass);
                rdd = rdd.mapToPair((PairFunction)new CopyTextInputFunction());
            } else {
                if (inputInfo2 == InputInfo.BinaryCellInputInfo) {
                    throw new DMLRuntimeException("Binarycell not supported for frames.");
                }
                throw new DMLRuntimeException("Incorrect input format in getRDDHandleForVariable");
            }
            RDDObject rddhandle = new RDDObject(rdd);
            rddhandle.setHDFSFile(true);
            fo.setRDDHandle(rddhandle);
        }
        return rdd;
    }

    public Broadcast<CacheBlock> broadcastVariable(CacheableData<CacheBlock> cd) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        Broadcast brBlock = null;
        if (cd.getBroadcastHandle() != null && cd.getBroadcastHandle().isNonPartitionedBroadcastValid()) {
            brBlock = cd.getBroadcastHandle().getNonPartitionedBroadcast();
        }
        if (brBlock == null) {
            if (cd.getBroadcastHandle() != null) {
                CacheableData.addBroadcastSize(-cd.getBroadcastHandle().getNonPartitionedBroadcastSize());
            }
            CacheBlock cb = cd.acquireRead();
            cd.release();
            if (cb.getExactSerializedSize() > 0L && cb.getExactSerializedSize() <= Integer.MAX_VALUE) {
                brBlock = this.getSparkContext().broadcast((Object)cb);
                if (cd.getBroadcastHandle() == null) {
                    cd.setBroadcastHandle(new BroadcastObject());
                }
                cd.getBroadcastHandle().setNonPartitionedBroadcast((Broadcast<CacheBlock>)brBlock, OptimizerUtils.estimateSize(cd.getMatrixCharacteristics()));
                CacheableData.addBroadcastSize(cd.getBroadcastHandle().getNonPartitionedBroadcastSize());
                if (DMLScript.STATISTICS) {
                    Statistics.accSparkBroadCastTime(System.nanoTime() - t0);
                    Statistics.incSparkBroadcastCount(1L);
                }
            }
        }
        return brBlock;
    }

    public PartitionedBroadcast<MatrixBlock> getBroadcastForMatrixObject(MatrixObject mo) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        PartitionedBroadcast bret = null;
        if (mo.getBroadcastHandle() != null && mo.getBroadcastHandle().isPartitionedBroadcastValid()) {
            bret = mo.getBroadcastHandle().getPartitionedBroadcast();
        }
        if (bret == null) {
            if (mo.getBroadcastHandle() != null) {
                CacheableData.addBroadcastSize(-mo.getBroadcastHandle().getPartitionedBroadcastSize());
            }
            int brlen = (int)mo.getNumRowsPerBlock();
            int bclen = (int)mo.getNumColumnsPerBlock();
            MatrixBlock mb = (MatrixBlock)mo.acquireRead();
            PartitionedBlock<MatrixBlock> pmb = new PartitionedBlock<MatrixBlock>(mb, brlen, bclen);
            mo.release();
            int numPerPart = PartitionedBroadcast.computeBlocksPerPartition(mo.getNumRows(), mo.getNumColumns(), brlen, bclen);
            int numParts = (int)Math.ceil((double)pmb.getNumRowBlocks() * (double)pmb.getNumColumnBlocks() / (double)numPerPart);
            Broadcast[] ret = new Broadcast[numParts];
            if (numParts > 1) {
                Arrays.parallelSetAll(ret, i -> this.createPartitionedBroadcast(pmb, numPerPart, i));
            } else {
                ret[0] = this.getSparkContext().broadcast(pmb);
                if (!SparkExecutionContext.isLocalMaster()) {
                    pmb.clearBlocks();
                }
            }
            bret = new PartitionedBroadcast(ret, mo.getMatrixCharacteristics());
            if (mo.getBroadcastHandle() == null) {
                mo.setBroadcastHandle(new BroadcastObject());
            }
            mo.getBroadcastHandle().setPartitionedBroadcast(bret, OptimizerUtils.estimatePartitionedSizeExactSparsity(mo.getMatrixCharacteristics()));
            CacheableData.addBroadcastSize(mo.getBroadcastHandle().getPartitionedBroadcastSize());
        }
        if (DMLScript.STATISTICS) {
            Statistics.accSparkBroadCastTime(System.nanoTime() - t0);
            Statistics.incSparkBroadcastCount(1L);
        }
        return bret;
    }

    public PartitionedBroadcast<MatrixBlock> getBroadcastForVariable(String varname) {
        MatrixObject mo = this.getMatrixObject(varname);
        return this.getBroadcastForMatrixObject(mo);
    }

    public PartitionedBroadcast<FrameBlock> getBroadcastForFrameVariable(String varname) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        FrameObject fo = this.getFrameObject(varname);
        PartitionedBroadcast bret = null;
        if (fo.getBroadcastHandle() != null && fo.getBroadcastHandle().isPartitionedBroadcastValid()) {
            bret = fo.getBroadcastHandle().getPartitionedBroadcast();
        }
        if (bret == null) {
            if (fo.getBroadcastHandle() != null) {
                CacheableData.addBroadcastSize(-fo.getBroadcastHandle().getPartitionedBroadcastSize());
            }
            int bclen = (int)fo.getNumColumns();
            int brlen = OptimizerUtils.getDefaultFrameSize();
            FrameBlock mb = (FrameBlock)fo.acquireRead();
            PartitionedBlock<FrameBlock> pmb = new PartitionedBlock<FrameBlock>(mb, brlen, bclen);
            fo.release();
            int numPerPart = PartitionedBroadcast.computeBlocksPerPartition(fo.getNumRows(), fo.getNumColumns(), brlen, bclen);
            int numParts = (int)Math.ceil((double)pmb.getNumRowBlocks() * (double)pmb.getNumColumnBlocks() / (double)numPerPart);
            Broadcast[] ret = new Broadcast[numParts];
            if (numParts > 1) {
                Arrays.parallelSetAll(ret, i -> this.createPartitionedBroadcast(pmb, numPerPart, i));
            } else {
                ret[0] = this.getSparkContext().broadcast(pmb);
                if (!SparkExecutionContext.isLocalMaster()) {
                    pmb.clearBlocks();
                }
            }
            bret = new PartitionedBroadcast(ret, new MatrixCharacteristics(fo.getMatrixCharacteristics()).setBlockSize(brlen, bclen));
            if (fo.getBroadcastHandle() == null) {
                fo.setBroadcastHandle(new BroadcastObject());
            }
            fo.getBroadcastHandle().setPartitionedBroadcast(bret, OptimizerUtils.estimatePartitionedSizeExactSparsity(fo.getMatrixCharacteristics()));
            CacheableData.addBroadcastSize(fo.getBroadcastHandle().getPartitionedBroadcastSize());
        }
        if (DMLScript.STATISTICS) {
            Statistics.accSparkBroadCastTime(System.nanoTime() - t0);
            Statistics.incSparkBroadcastCount(1L);
        }
        return bret;
    }

    private Broadcast<PartitionedBlock<? extends CacheBlock>> createPartitionedBroadcast(PartitionedBlock<? extends CacheBlock> pmb, int numPerPart, int pos) {
        int offset = pos * numPerPart;
        int numBlks = Math.min(numPerPart, pmb.getNumRowBlocks() * pmb.getNumColumnBlocks() - offset);
        PartitionedBlock<? extends CacheBlock> tmp = pmb.createPartition(offset, numBlks);
        Broadcast ret = this.getSparkContext().broadcast(tmp);
        if (!SparkExecutionContext.isLocalMaster()) {
            tmp.clearBlocks();
        }
        return ret;
    }

    public void setRDDHandleForVariable(String varname, JavaPairRDD<?, ?> rdd) {
        CacheableData<?> obj = this.getCacheableData(varname);
        RDDObject rddhandle = new RDDObject(rdd);
        obj.setRDDHandle(rddhandle);
    }

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> toMatrixJavaPairRDD(JavaSparkContext sc, MatrixBlock src, int brlen, int bclen) {
        return SparkExecutionContext.toMatrixJavaPairRDD(sc, src, brlen, bclen, -1, true);
    }

    public static JavaPairRDD<MatrixIndexes, MatrixBlock> toMatrixJavaPairRDD(JavaSparkContext sc, MatrixBlock src, int brlen, int bclen, int numParts, boolean inclEmpty) {
        JavaPairRDD result;
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        List<Object> list = null;
        if (src.getNumRows() <= brlen && src.getNumColumns() <= bclen) {
            list = Arrays.asList(new Tuple2((Object)new MatrixIndexes(1L, 1L), (Object)src));
        } else {
            MatrixCharacteristics mc = new MatrixCharacteristics(src.getNumRows(), src.getNumColumns(), brlen, bclen, src.getNonZeros());
            list = LongStream.range(0L, mc.getNumBlocks()).parallel().mapToObj(i -> SparkExecutionContext.createIndexedBlock(src, mc, i)).filter(kv -> inclEmpty || !((MatrixBlock)kv._2).isEmptyBlock(false)).collect(Collectors.toList());
        }
        JavaPairRDD javaPairRDD = result = numParts > 1 ? sc.parallelizePairs(list, numParts) : sc.parallelizePairs(list);
        if (DMLScript.STATISTICS) {
            Statistics.accSparkParallelizeTime(System.nanoTime() - t0);
            Statistics.incSparkParallelizeCount(1L);
        }
        return result;
    }

    private static Tuple2<MatrixIndexes, MatrixBlock> createIndexedBlock(MatrixBlock mb, MatrixCharacteristics mc, long ix) {
        try {
            long blockRow = ix / mc.getNumColBlocks();
            long blockCol = ix % mc.getNumColBlocks();
            int maxRow = UtilFunctions.computeBlockSize(mc.getRows(), blockRow + 1L, mc.getRowsPerBlock());
            int maxCol = UtilFunctions.computeBlockSize(mc.getCols(), blockCol + 1L, mc.getColsPerBlock());
            MatrixBlock block = new MatrixBlock(maxRow, maxCol, mb.isInSparseFormat());
            int row_offset = (int)blockRow * mc.getRowsPerBlock();
            int col_offset = (int)blockCol * mc.getColsPerBlock();
            block = mb.slice(row_offset, row_offset + maxRow - 1, col_offset, col_offset + maxCol - 1, block);
            return new Tuple2((Object)new MatrixIndexes(blockRow + 1L, blockCol + 1L), (Object)block);
        }
        catch (DMLRuntimeException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static JavaPairRDD<Long, FrameBlock> toFrameJavaPairRDD(JavaSparkContext sc, FrameBlock src) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        LinkedList<Tuple2> list = new LinkedList<Tuple2>();
        int blksize = ConfigurationManager.getBlocksize();
        for (int blockRow = 0; blockRow < (int)Math.ceil((double)src.getNumRows() / (double)blksize); ++blockRow) {
            int maxRow = blockRow * blksize + blksize < src.getNumRows() ? blksize : src.getNumRows() - blockRow * blksize;
            int roffset = blockRow * blksize;
            FrameBlock block = new FrameBlock(src.getSchema());
            src.slice(roffset, roffset + maxRow - 1, 0, src.getNumColumns() - 1, block);
            if (roffset == 0) {
                block.setColumnMetadata(src.getColumnMetadata());
            }
            list.addLast(new Tuple2((Object)((long)roffset + 1L), (Object)block));
        }
        JavaPairRDD result = sc.parallelizePairs(list);
        if (DMLScript.STATISTICS) {
            Statistics.accSparkParallelizeTime(System.nanoTime() - t0);
            Statistics.incSparkParallelizeCount(1L);
        }
        return result;
    }

    public static MatrixBlock toMatrixBlock(RDDObject rdd, int rlen, int clen, int brlen, int bclen, long nnz) {
        return SparkExecutionContext.toMatrixBlock(rdd.getRDD(), rlen, clen, brlen, bclen, nnz);
    }

    public static MatrixBlock toMatrixBlock(JavaPairRDD<MatrixIndexes, MatrixBlock> rdd, int rlen, int clen, int brlen, int bclen, long nnz) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock out = null;
        if (rlen <= brlen && clen <= bclen) {
            List list = rdd.collect();
            if (list.size() > 1) {
                throw new DMLRuntimeException("Expecting no more than one result block.");
            }
            out = list.size() == 1 ? (MatrixBlock)((Tuple2)list.get(0))._2() : new MatrixBlock(rlen, clen, true);
            out.examSparsity();
        } else {
            long lnnz = nnz >= 0L ? nnz : (long)rlen * (long)clen;
            boolean sparse = MatrixBlock.evalSparseFormatInMemory(rlen, clen, lnnz);
            out = new MatrixBlock(rlen, clen, sparse, lnnz);
            List list = rdd.collect();
            long aNnz = 0L;
            for (Tuple2 keyval : list) {
                MatrixIndexes ix = (MatrixIndexes)keyval._1();
                MatrixBlock block = (MatrixBlock)keyval._2();
                int row_offset = (int)(ix.getRowIndex() - 1L) * brlen;
                int col_offset = (int)(ix.getColumnIndex() - 1L) * bclen;
                int rows = block.getNumRows();
                int cols = block.getNumColumns();
                if (block instanceof CompressedMatrixBlock) {
                    block = ((CompressedMatrixBlock)block).decompress();
                }
                if (sparse) {
                    out.appendToSparse(block, row_offset, col_offset, clen > bclen);
                } else {
                    out.copy(row_offset, row_offset + rows - 1, col_offset, col_offset + cols - 1, block, false);
                }
                aNnz += block.getNonZeros();
            }
            if (sparse && clen > bclen) {
                out.sortSparseRows();
            }
            out.setNonZeros(aNnz);
            out.examSparsity();
        }
        if (DMLScript.STATISTICS) {
            Statistics.accSparkCollectTime(System.nanoTime() - t0);
            Statistics.incSparkCollectCount(1L);
        }
        return out;
    }

    public static MatrixBlock toMatrixBlock(RDDObject rdd, int rlen, int clen, long nnz) {
        return SparkExecutionContext.toMatrixBlock(rdd.getRDD(), rlen, clen, nnz);
    }

    public static MatrixBlock toMatrixBlock(JavaPairRDD<MatrixIndexes, MatrixCell> rdd, int rlen, int clen, long nnz) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        MatrixBlock out = null;
        long lnnz = nnz >= 0L ? nnz : (long)rlen * (long)clen;
        boolean sparse = MatrixBlock.evalSparseFormatInMemory(rlen, clen, lnnz);
        out = new MatrixBlock(rlen, clen, sparse);
        List list = rdd.collect();
        for (Tuple2 keyval : list) {
            MatrixIndexes ix = (MatrixIndexes)keyval._1();
            MatrixCell cell = (MatrixCell)keyval._2();
            out.appendValue((int)ix.getRowIndex() - 1, (int)ix.getColumnIndex() - 1, cell.getValue());
        }
        if (sparse) {
            out.sortSparseRows();
        }
        out.recomputeNonZeros();
        out.examSparsity();
        if (DMLScript.STATISTICS) {
            Statistics.accSparkCollectTime(System.nanoTime() - t0);
            Statistics.incSparkCollectCount(1L);
        }
        return out;
    }

    public static PartitionedBlock<MatrixBlock> toPartitionedMatrixBlock(JavaPairRDD<MatrixIndexes, MatrixBlock> rdd, int rlen, int clen, int brlen, int bclen, long nnz) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        PartitionedBlock<MatrixBlock> out = new PartitionedBlock<MatrixBlock>(rlen, clen, brlen, bclen);
        List list = rdd.collect();
        for (Tuple2 keyval : list) {
            MatrixIndexes ix = (MatrixIndexes)keyval._1();
            MatrixBlock block = (MatrixBlock)keyval._2();
            out.setBlock((int)ix.getRowIndex(), (int)ix.getColumnIndex(), block);
        }
        if (DMLScript.STATISTICS) {
            Statistics.accSparkCollectTime(System.nanoTime() - t0);
            Statistics.incSparkCollectCount(1L);
        }
        return out;
    }

    public static FrameBlock toFrameBlock(RDDObject rdd, Expression.ValueType[] schema, int rlen, int clen) {
        JavaPairRDD<?, ?> lrdd = rdd.getRDD();
        return SparkExecutionContext.toFrameBlock(lrdd, schema, rlen, clen);
    }

    public static FrameBlock toFrameBlock(JavaPairRDD<Long, FrameBlock> rdd, Expression.ValueType[] schema, int rlen, int clen) {
        long t0;
        long l = t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        if (schema == null) {
            schema = UtilFunctions.nCopies(clen, Expression.ValueType.STRING);
        }
        FrameBlock out = new FrameBlock(schema);
        out.ensureAllocatedColumns(rlen);
        List list = rdd.collect();
        for (Tuple2 keyval : list) {
            int ix = (int)((Long)keyval._1() - 1L);
            FrameBlock block = (FrameBlock)keyval._2();
            out.copy(ix, ix + block.getNumRows() - 1, 0, block.getNumColumns() - 1, block);
            if (ix != 0) continue;
            out.setColumnNames(block.getColumnNames());
            out.setColumnMetadata(block.getColumnMetadata());
        }
        if (DMLScript.STATISTICS) {
            Statistics.accSparkCollectTime(System.nanoTime() - t0);
            Statistics.incSparkCollectCount(1L);
        }
        return out;
    }

    public static long writeRDDtoHDFS(RDDObject rdd, String path, OutputInfo oinfo) {
        JavaPairRDD lrdd = rdd.getRDD();
        LongAccumulator aNnz = SparkExecutionContext.getSparkContextStatic().sc().longAccumulator("nnz");
        lrdd = lrdd.mapValues((Function)new ComputeBinaryBlockNnzFunction(aNnz));
        lrdd.saveAsHadoopFile(path, oinfo.outputKeyClass, oinfo.outputValueClass, oinfo.outputFormatClass);
        return aNnz.value();
    }

    public static void writeFrameRDDtoHDFS(RDDObject rdd, String path, OutputInfo oinfo) {
        JavaPairRDD lrdd = rdd.getRDD();
        if (oinfo == OutputInfo.BinaryBlockOutputInfo) {
            lrdd = lrdd.mapToPair((PairFunction)new FrameRDDConverterUtils.LongFrameToLongWritableFrameFunction());
            oinfo = OutputInfo.BinaryBlockFrameOutputInfo;
        }
        lrdd.saveAsHadoopFile(path, oinfo.outputKeyClass, oinfo.outputValueClass, oinfo.outputFormatClass);
    }

    public void addLineageRDD(String varParent, String varChild) {
        RDDObject parent = this.getCacheableData(varParent).getRDDHandle();
        RDDObject child = this.getCacheableData(varChild).getRDDHandle();
        parent.addLineageChild(child);
    }

    public void addLineageBroadcast(String varParent, String varChild) {
        RDDObject parent = this.getCacheableData(varParent).getRDDHandle();
        BroadcastObject<?> child = this.getCacheableData(varChild).getBroadcastHandle();
        parent.addLineageChild(child);
    }

    public void addLineage(String varParent, String varChild, boolean broadcast) {
        if (broadcast) {
            this.addLineageBroadcast(varParent, varChild);
        } else {
            this.addLineageRDD(varParent, varChild);
        }
    }

    @Override
    public void cleanupCacheableData(CacheableData<?> mo) {
        if (DMLScript.JMLC_MEM_STATISTICS) {
            Statistics.removeCPMemObject(System.identityHashCode(mo));
        }
        if (!mo.isCleanupEnabled()) {
            return;
        }
        try {
            if (!this.getVariables().hasReferences(mo)) {
                mo.clearData();
                if (mo.isHDFSFileExists() && mo.getFileName() != null) {
                    if (mo.getRDDHandle() == null) {
                        MapReduceTool.deleteFileWithMTDIfExistOnHDFS(mo.getFileName());
                    } else {
                        RDDObject rdd = mo.getRDDHandle();
                        rdd.setHDFSFilename(mo.getFileName());
                    }
                }
                if (mo.getRDDHandle() != null) {
                    this.rCleanupLineageObject(mo.getRDDHandle());
                }
                if (mo.getBroadcastHandle() != null) {
                    this.rCleanupLineageObject(mo.getBroadcastHandle());
                }
            }
        }
        catch (Exception ex) {
            throw new DMLRuntimeException(ex);
        }
    }

    private void rCleanupLineageObject(LineageObject lob) throws IOException {
        if (lob.getNumReferences() > 0) {
            return;
        }
        if (lob.hasBackReference()) {
            return;
        }
        if (lob instanceof RDDObject) {
            RDDObject rdd = (RDDObject)lob;
            int rddID = rdd.getRDD().id();
            SparkExecutionContext.cleanupRDDVariable(rdd.getRDD());
            if (rdd.getHDFSFilename() != null) {
                MapReduceTool.deleteFileWithMTDIfExistOnHDFS(rdd.getHDFSFilename());
            }
            if (rdd.isParallelizedRDD()) {
                _parRDDs.deregisterRDD(rddID);
            }
        } else if (lob instanceof BroadcastObject) {
            Broadcast bc;
            PartitionedBroadcast pbm;
            BroadcastObject bob = (BroadcastObject)lob;
            if (bob.isPartitionedBroadcastValid() && (pbm = bob.getPartitionedBroadcast()) != null) {
                pbm.destroy();
            }
            if (((BroadcastObject)lob).isNonPartitionedBroadcastValid() && (bc = bob.getNonPartitionedBroadcast()) != null) {
                SparkExecutionContext.cleanupBroadcastVariable(bc);
            }
            CacheableData.addBroadcastSize(-bob.getNonPartitionedBroadcastSize());
        }
        for (LineageObject c : lob.getLineageChilds()) {
            c.decrementNumReferences();
            this.rCleanupLineageObject(c);
        }
    }

    public static void cleanupBroadcastVariable(Broadcast<?> bvar) {
        if (bvar.isValid()) {
            bvar.destroy(false);
        }
    }

    public static void cleanupRDDVariable(JavaPairRDD<?, ?> rvar) {
        if (rvar.getStorageLevel() != StorageLevel.NONE()) {
            rvar.unpersist(false);
        }
    }

    public void repartitionAndCacheMatrixObject(String var) {
        int numPartitions;
        MatrixObject mo = this.getMatrixObject(var);
        MatrixCharacteristics mcIn = mo.getMatrixCharacteristics();
        if (!OptimizerUtils.exceedsCachingThreshold(mo.getNumColumns(), OptimizerUtils.estimateSizeExactSparsity(mcIn))) {
            return;
        }
        JavaPairRDD in = this.getRDDHandleForMatrixObject(mo, InputInfo.BinaryBlockInputInfo);
        if (mo.getRDDHandle().allowsShortCircuitRead() && this.isRDDMarkedForCaching(in.id()) && !this.isRDDCached(in.id()) && (numPartitions = SparkUtils.getNumPreferredPartitions(mcIn, in = ((RDDObject)mo.getRDDHandle().getLineageChilds().get(0)).getRDD())) < in.getNumPartitions()) {
            in = in.coalesce(numPartitions);
        }
        JavaPairRDD out = RDDAggregateUtils.mergeByKey(in, false);
        if (OptimizerUtils.checkSparseBlockCSRConversion(mcIn)) {
            out = out.mapValues((Function)new CreateSparseBlockFunction(SparseBlock.Type.CSR));
        }
        out.persist(Checkpoint.DEFAULT_STORAGE_LEVEL).count();
        RDDObject inro = mo.getRDDHandle();
        RDDObject outro = new RDDObject(out);
        outro.setCheckpointRDD(true);
        outro.addLineageChild(inro);
        mo.setRDDHandle(outro);
    }

    public void cacheMatrixObject(String var) {
        MatrixObject mo = this.getMatrixObject(var);
        if (!OptimizerUtils.exceedsCachingThreshold(mo.getNumColumns(), OptimizerUtils.estimateSizeExactSparsity(mo.getMatrixCharacteristics()))) {
            return;
        }
        JavaPairRDD<?, ?> in = this.getRDDHandleForMatrixObject(mo, InputInfo.BinaryBlockInputInfo);
        if (!this.isRDDCached(in.id())) {
            in.count();
        }
    }

    public int setThreadLocalSchedulerPool() {
        int pool = -1;
        pool = SparkExecutionContext.allocSchedulerPoolName();
        this.getSparkContext().sc().setLocalProperty("spark.scheduler.pool", "parforPool" + pool);
        return pool;
    }

    public void cleanupThreadLocalSchedulerPool(int pool) {
        SparkExecutionContext.freeSchedulerPoolName(pool);
        this.getSparkContext().sc().setLocalProperty("spark.scheduler.pool", null);
    }

    private static synchronized int allocSchedulerPoolName() {
        int pool = ArrayUtils.indexOf((boolean[])_poolBuff, (boolean)false);
        if (pool < 0) {
            pool = _poolBuff.length;
            _poolBuff = Arrays.copyOf(_poolBuff, (int)Math.min(2L * (long)pool, Integer.MAX_VALUE));
        }
        SparkExecutionContext._poolBuff[pool] = true;
        return pool;
    }

    private static synchronized void freeSchedulerPoolName(int pool) {
        SparkExecutionContext._poolBuff[pool] = false;
    }

    private boolean isRDDMarkedForCaching(int rddID) {
        JavaSparkContext jsc = this.getSparkContext();
        return jsc.sc().getPersistentRDDs().contains((Object)rddID);
    }

    public boolean isRDDCached(int rddID) {
        JavaSparkContext jsc = this.getSparkContext();
        if (!jsc.sc().getPersistentRDDs().contains((Object)rddID)) {
            return false;
        }
        for (RDDInfo info : jsc.sc().getRDDStorageInfo()) {
            if (info.id() != rddID) continue;
            return info.isCached();
        }
        return false;
    }

    public static SparkClusterConfig getSparkClusterConfig() {
        if (_sconf == null) {
            _sconf = new SparkClusterConfig();
        }
        return _sconf;
    }

    public static double getBroadcastMemoryBudget() {
        return SparkExecutionContext.getSparkClusterConfig().getBroadcastMemoryBudget();
    }

    public static double getDataMemoryBudget(boolean min, boolean refresh) {
        return SparkExecutionContext.getSparkClusterConfig().getDataMemoryBudget(min, refresh);
    }

    public static int getNumExecutors() {
        return SparkExecutionContext.getSparkClusterConfig().getNumExecutors();
    }

    public static int getDefaultParallelism(boolean refresh) {
        return SparkExecutionContext.getSparkClusterConfig().getDefaultParallelism(refresh);
    }

    private static class MemoryManagerParRDDs {
        private final long _limit;
        private long _size;
        private HashMap<Integer, Long> _rdds;

        public MemoryManagerParRDDs(double fractionMem) {
            this._limit = (long)(fractionMem * (double)InfrastructureAnalyzer.getLocalMaxMemory());
            this._size = 0L;
            this._rdds = new HashMap();
        }

        public synchronized boolean reserve(long rddSize) {
            boolean ret = rddSize + this._size < this._limit;
            this._size += ret ? rddSize : 0L;
            return ret;
        }

        public synchronized void registerRDD(int rddID, long rddSize, boolean reserved) {
            if (!reserved) {
                throw new RuntimeException("Unsupported rdd registration without size reservation for " + rddSize + " bytes.");
            }
            this._rdds.put(rddID, rddSize);
        }

        public synchronized void deregisterRDD(int rddID) {
            long rddSize = this._rdds.remove(rddID);
            this._size -= rddSize;
        }

        public synchronized void clear() {
            this._size = 0L;
            this._rdds.clear();
        }
    }

    public static class SparkClusterConfig {
        private static final double BROADCAST_DATA_FRACTION = 0.35;
        private static final long RESERVED_SYSTEM_MEMORY_BYTES = 314572800L;
        private boolean _legacyVersion = false;
        private boolean _confOnly = false;
        private long _memExecutor = -1L;
        private double _memDataMinFrac = -1.0;
        private double _memDataMaxFrac = -1.0;
        private double _memBroadcastFrac = -1.0;
        private int _numExecutors = -1;
        private int _defaultPar = -1;

        public SparkClusterConfig() {
            SparkConf sconf = SparkExecutionContext.createSystemMLSparkConf();
            this._confOnly = true;
            String sparkVersion = SparkClusterConfig.getSparkVersionString();
            boolean bl = this._legacyVersion = UtilFunctions.compareVersion(sparkVersion, "1.6.0") < 0 || sconf.getBoolean("spark.memory.useLegacyMode", false);
            if (this._legacyVersion) {
                this.analyzeSparkConfiguationLegacy(sconf);
            } else {
                this.analyzeSparkConfiguation(sconf);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)this.toString());
            }
        }

        public long getBroadcastMemoryBudget() {
            return (long)((double)this._memExecutor * this._memBroadcastFrac);
        }

        public long getDataMemoryBudget(boolean min, boolean refresh) {
            int numExec = this._numExecutors;
            if (refresh && !this._confOnly || SparkExecutionContext.isSparkContextCreated()) {
                JavaSparkContext jsc = SparkExecutionContext.getSparkContextStatic();
                numExec = Math.max(jsc.sc().getExecutorMemoryStatus().size() - 1, 1);
            }
            return (long)((double)((long)numExec * this._memExecutor) * (min ? this._memDataMinFrac : this._memDataMaxFrac));
        }

        public int getNumExecutors() {
            if (this._numExecutors < 0) {
                this.analyzeSparkParallelismConfiguation(null);
            }
            return this._numExecutors;
        }

        public int getDefaultParallelism(boolean refresh) {
            if (this._defaultPar < 0 && !refresh) {
                this.analyzeSparkParallelismConfiguation(null);
            }
            int par = refresh && !this._confOnly || SparkExecutionContext.isSparkContextCreated() ? SparkExecutionContext.getSparkContextStatic().defaultParallelism() : this._defaultPar;
            return Math.max(par, 1);
        }

        public void analyzeSparkConfiguationLegacy(SparkConf conf) {
            double dataFrac;
            SparkConf sconf = conf == null ? SparkExecutionContext.createSystemMLSparkConf() : conf;
            this._memExecutor = UtilFunctions.parseMemorySize(sconf.get("spark.executor.memory", "1g"));
            this._memDataMinFrac = dataFrac = sconf.getDouble("spark.storage.memoryFraction", 0.6);
            this._memDataMaxFrac = dataFrac;
            this._memBroadcastFrac = dataFrac * 0.35;
            this.analyzeSparkParallelismConfiguation(sconf);
        }

        public void analyzeSparkConfiguation(SparkConf conf) {
            SparkConf sconf = conf == null ? SparkExecutionContext.createSystemMLSparkConf() : conf;
            this._memExecutor = UtilFunctions.parseMemorySize(sconf.get("spark.executor.memory", "1g")) - 314572800L;
            this._memDataMinFrac = sconf.getDouble("spark.memory.storageFraction", 0.5);
            this._memDataMaxFrac = sconf.getDouble("spark.memory.fraction", 0.6);
            this._memBroadcastFrac = this._memDataMaxFrac * 0.35;
            this.analyzeSparkParallelismConfiguation(sconf);
        }

        private void analyzeSparkParallelismConfiguation(SparkConf conf) {
            SparkConf sconf = conf == null ? SparkExecutionContext.createSystemMLSparkConf() : conf;
            int numExecutors = sconf.getInt("spark.executor.instances", -1);
            int numCoresPerExec = sconf.getInt("spark.executor.cores", -1);
            int defaultPar = sconf.getInt("spark.default.parallelism", -1);
            if (numExecutors > 1 && (defaultPar > 1 || numCoresPerExec > 1)) {
                this._numExecutors = numExecutors;
                this._defaultPar = defaultPar > 1 ? defaultPar : numExecutors * numCoresPerExec;
                this._confOnly &= true;
            } else {
                JavaSparkContext jsc = SparkExecutionContext.getSparkContextStatic();
                this._numExecutors = Math.max(jsc.sc().getExecutorMemoryStatus().size() - 1, 1);
                this._defaultPar = jsc.defaultParallelism();
                this._confOnly &= false;
            }
        }

        private static String getSparkVersionString() {
            if (SparkExecutionContext.isSparkContextCreated()) {
                return SparkExecutionContext.getSparkContextStatic().version();
            }
            return package$.MODULE$.SPARK_VERSION();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("SparkClusterConfig: \n");
            sb.append("-- legacyVersion    = " + this._legacyVersion + " (" + SparkClusterConfig.getSparkVersionString() + ")\n");
            sb.append("-- confOnly         = " + this._confOnly + "\n");
            sb.append("-- numExecutors     = " + this._numExecutors + "\n");
            sb.append("-- defaultPar       = " + this._defaultPar + "\n");
            sb.append("-- memExecutor      = " + this._memExecutor + "\n");
            sb.append("-- memDataMinFrac   = " + this._memDataMinFrac + "\n");
            sb.append("-- memDataMaxFrac   = " + this._memDataMaxFrac + "\n");
            sb.append("-- memBroadcastFrac = " + this._memBroadcastFrac + "\n");
            return sb.toString();
        }
    }
}

