/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.sysml.runtime.instructions.mr.CSVWriteInstruction;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.IJV;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;
import org.apache.sysml.runtime.matrix.mapred.ReduceBase;
import org.apache.sysml.runtime.util.MapReduceTool;

public class CSVWriteReducer
extends ReduceBase
implements Reducer<TaggedFirstSecondIndexes, MatrixBlock, NullWritable, RowBlockForTextOutput> {
    private NullWritable nullKey = NullWritable.get();
    private RowBlockForTextOutput outValue = new RowBlockForTextOutput();
    private RowBlockForTextOutput zeroBlock = new RowBlockForTextOutput();
    private long[] rowIndexes = null;
    private long[] minRowIndexes = null;
    private long[] maxRowIndexes = null;
    private long[] colIndexes = null;
    private long[] numColBlocks = null;
    private int[] colsPerBlock = null;
    private int[] lastBlockNCols = null;
    private String[] delims = null;
    private boolean[] sparses = null;
    private int[] tagToResultIndex = null;

    private void addEndingMissingValues(byte tag, Reporter reporter) throws IOException {
        long col;
        for (col = this.colIndexes[tag] + 1L; col < this.numColBlocks[tag]; ++col) {
            this.zeroBlock.setNumColumns(this.colsPerBlock[tag]);
            this.zeroBlock.setSituation(RowBlockForTextOutput.Situation.MIDDLE);
            this.collectFinalMultipleOutputs.directOutput(this.nullKey, this.zeroBlock, this.tagToResultIndex[tag], reporter);
        }
        if (col <= this.numColBlocks[tag]) {
            this.zeroBlock.setNumColumns(this.lastBlockNCols[tag]);
            this.zeroBlock.setSituation(RowBlockForTextOutput.Situation.MIDDLE);
            this.collectFinalMultipleOutputs.directOutput(this.nullKey, this.zeroBlock, this.tagToResultIndex[tag], reporter);
            this.colIndexes[tag] = 0L;
        }
    }

    private RowBlockForTextOutput.Situation addMissingRows(byte tag, long stoppingRow, RowBlockForTextOutput.Situation sit, Reporter reporter) throws IOException {
        for (long row = this.rowIndexes[tag] + 1L; row < stoppingRow; ++row) {
            for (long c = 1L; c < this.numColBlocks[tag]; ++c) {
                this.zeroBlock.setNumColumns(this.colsPerBlock[tag]);
                this.zeroBlock.setSituation(sit);
                this.collectFinalMultipleOutputs.directOutput(this.nullKey, this.zeroBlock, this.tagToResultIndex[tag], reporter);
                sit = RowBlockForTextOutput.Situation.MIDDLE;
            }
            this.zeroBlock.setNumColumns(this.lastBlockNCols[tag]);
            this.zeroBlock.setSituation(sit);
            this.collectFinalMultipleOutputs.directOutput(this.nullKey, this.zeroBlock, this.tagToResultIndex[tag], reporter);
            this.colIndexes[tag] = 0L;
            sit = RowBlockForTextOutput.Situation.NEWLINE;
        }
        this.colIndexes[tag] = 0L;
        return sit;
    }

    private void addNewlineCharacter(byte tag, Reporter reporter) throws IOException {
        this.zeroBlock.setNumColumns(0);
        this.zeroBlock.setSituation(RowBlockForTextOutput.Situation.NEWLINE);
        this.collectFinalMultipleOutputs.directOutput(this.nullKey, this.zeroBlock, this.tagToResultIndex[tag], reporter);
    }

    public void reduce(TaggedFirstSecondIndexes inkey, Iterator<MatrixBlock> inValue, OutputCollector<NullWritable, RowBlockForTextOutput> out, Reporter reporter) throws IOException {
        long begin = System.currentTimeMillis();
        this.cachedReporter = reporter;
        byte tag = inkey.getTag();
        this.zeroBlock.setFormatParameters(this.delims[tag], this.sparses[tag]);
        this.outValue.setFormatParameters(this.delims[tag], this.sparses[tag]);
        RowBlockForTextOutput.Situation sit = RowBlockForTextOutput.Situation.MIDDLE;
        if (this.rowIndexes[tag] == this.minRowIndexes[tag]) {
            sit = RowBlockForTextOutput.Situation.START;
        } else if (this.rowIndexes[tag] != inkey.getFirstIndex()) {
            sit = RowBlockForTextOutput.Situation.NEWLINE;
        }
        if (sit == RowBlockForTextOutput.Situation.NEWLINE) {
            this.addEndingMissingValues(tag, reporter);
        }
        if (sit == RowBlockForTextOutput.Situation.NEWLINE || sit == RowBlockForTextOutput.Situation.START) {
            sit = this.addMissingRows(tag, inkey.getFirstIndex(), sit, reporter);
        }
        for (long col = this.colIndexes[tag] + 1L; col < inkey.getSecondIndex(); ++col) {
            this.zeroBlock.setNumColumns(this.colsPerBlock[tag]);
            this.zeroBlock.setSituation(sit);
            this.collectFinalMultipleOutputs.directOutput(this.nullKey, this.zeroBlock, this.tagToResultIndex[tag], reporter);
            sit = RowBlockForTextOutput.Situation.MIDDLE;
        }
        this.colIndexes[tag] = inkey.getSecondIndex();
        while (inValue.hasNext()) {
            MatrixBlock block = inValue.next();
            this.outValue.setData(block);
            this.outValue.setNumColumns(block.getNumColumns());
            this.outValue.setSituation(sit);
            this.collectFinalMultipleOutputs.directOutput(this.nullKey, this.outValue, this.tagToResultIndex[tag], reporter);
            int n = this.tagToResultIndex[tag];
            this.resultsNonZeros[n] = this.resultsNonZeros[n] + block.getNonZeros();
            sit = RowBlockForTextOutput.Situation.MIDDLE;
        }
        this.rowIndexes[tag] = inkey.getFirstIndex();
        reporter.incrCounter(ReduceBase.Counters.COMBINE_OR_REDUCE_TIME, System.currentTimeMillis() - begin);
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        byte maxIndex = 0;
        HashMap<Byte, CSVWriteInstruction> out2Ins = new HashMap<Byte, CSVWriteInstruction>();
        try {
            CSVWriteInstruction[] ins;
            for (CSVWriteInstruction in : ins = MRJobConfiguration.getCSVWriteInstructions(job)) {
                out2Ins.put(in.output, in);
                if (in.output <= maxIndex) continue;
                maxIndex = in.output;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int numParitions = job.getNumReduceTasks();
        int taskID = MapReduceTool.getUniqueTaskId(job);
        this.rowIndexes = new long[maxIndex + 1];
        this.colIndexes = new long[maxIndex + 1];
        this.maxRowIndexes = new long[maxIndex + 1];
        this.minRowIndexes = new long[maxIndex + 1];
        this.numColBlocks = new long[maxIndex + 1];
        this.lastBlockNCols = new int[maxIndex + 1];
        this.colsPerBlock = new int[maxIndex + 1];
        this.delims = new String[maxIndex + 1];
        this.sparses = new boolean[maxIndex + 1];
        this.tagToResultIndex = new int[maxIndex + 1];
        int i = 0;
        while (i < this.resultIndexes.length) {
            CSVWriteInstruction in;
            byte ri = this.resultIndexes[i];
            this.tagToResultIndex[ri] = i++;
            in = (CSVWriteInstruction)out2Ins.get(ri);
            MatrixCharacteristics dim = MRJobConfiguration.getMatrixCharacteristicsForInput(job, in.input);
            this.delims[ri] = in.delim;
            this.sparses[ri] = in.sparse;
            this.numColBlocks[ri] = (long)Math.ceil((double)dim.getCols() / (double)dim.getColsPerBlock());
            this.lastBlockNCols[ri] = (int)(dim.getCols() % (long)dim.getColsPerBlock());
            this.colsPerBlock[ri] = dim.getColsPerBlock();
            long rstep = (long)Math.ceil((double)dim.getRows() / (double)numParitions);
            this.minRowIndexes[ri] = this.rowIndexes[ri] = rstep * (long)taskID;
            this.maxRowIndexes[ri] = Math.min(rstep * (long)(taskID + 1), dim.getRows());
            this.colIndexes[ri] = 0L;
        }
        this.zeroBlock.setData(new MatrixBlock());
    }

    @Override
    public void close() throws IOException {
        for (byte tag : this.resultIndexes) {
            this.addEndingMissingValues(tag, this.cachedReporter);
            this.addMissingRows(tag, this.maxRowIndexes[tag] + 1L, RowBlockForTextOutput.Situation.NEWLINE, this.cachedReporter);
            this.addNewlineCharacter(tag, this.cachedReporter);
        }
        super.close();
    }

    public static class RowBlockForTextOutput
    implements Writable {
        private MatrixBlock _data = null;
        private int _numCols = 0;
        private Situation _sit = Situation.START;
        private String delim = ",";
        private boolean sparse = true;
        private StringBuilder _buffer = new StringBuilder();

        public void setData(MatrixBlock block) {
            this._data = block;
        }

        public void setNumColumns(int cols) {
            this._numCols = cols;
        }

        public void setSituation(Situation s) {
            this._sit = s;
        }

        public void setFormatParameters(String del, boolean sps) {
            this.delim = del;
            this.sparse = sps;
        }

        @Override
        public void readFields(DataInput arg0) throws IOException {
            throw new IOException("this is not supposed to be called!");
        }

        @Override
        public void write(DataOutput out) throws IOException {
            this._buffer.setLength(0);
            switch (this._sit) {
                case START: {
                    break;
                }
                case NEWLINE: {
                    this._buffer.append('\n');
                    break;
                }
                case MIDDLE: {
                    this._buffer.append(this.delim);
                    break;
                }
                default: {
                    throw new RuntimeException("Unrecognized situation " + (Object)((Object)this._sit));
                }
            }
            if (this._numCols > 0) {
                if (this._data.isEmptyBlock(false)) {
                    RowBlockForTextOutput.appendZero(this._buffer, this.sparse, this.delim, false, this._numCols);
                } else if (this._data.isInSparseFormat()) {
                    Iterator<IJV> iter = this._data.getSparseBlockIterator();
                    int j = -1;
                    while (iter.hasNext()) {
                        IJV cell = iter.next();
                        RowBlockForTextOutput.appendZero(this._buffer, this.sparse, this.delim, true, cell.getJ() - j - 1);
                        j = cell.getJ();
                        if (cell.getV() != 0.0) {
                            this._buffer.append(cell.getV());
                        } else if (!this.sparse) {
                            this._buffer.append('0');
                        }
                        if (j >= this._numCols - 1) continue;
                        this._buffer.append(this.delim);
                    }
                    RowBlockForTextOutput.appendZero(this._buffer, this.sparse, this.delim, false, this._numCols - j - 1);
                } else {
                    for (int j = 0; j < this._numCols; ++j) {
                        double val = this._data.getValueDenseUnsafe(0, j);
                        if (val != 0.0) {
                            this._buffer.append(val);
                        } else if (!this.sparse) {
                            this._buffer.append('0');
                        }
                        if (j >= this._numCols - 1) continue;
                        this._buffer.append(this.delim);
                    }
                }
            }
            ByteBuffer bytes = Text.encode(this._buffer.toString());
            int length = bytes.limit();
            out.write(bytes.array(), 0, length);
        }

        private static void appendZero(StringBuilder buffer, boolean sparse, String delim, boolean alwaysDelim, int len) {
            if (len <= 0) {
                return;
            }
            for (int i = 0; i < len; ++i) {
                if (!sparse) {
                    buffer.append('0');
                }
                if (!alwaysDelim && i >= len - 1) continue;
                buffer.append(delim);
            }
        }

        public static enum Situation {
            START,
            NEWLINE,
            MIDDLE;

        }
    }
}

