/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.dag.impl;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tez.dag.api.EdgeManagerPlugin;
import org.apache.tez.dag.api.EdgeManagerPluginContext;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;

public class OneToOneEdgeManager
extends EdgeManagerPlugin {
    final List<Integer> destinationInputIndices = Collections.unmodifiableList(Collections.singletonList(0));
    final AtomicBoolean stateChecked = new AtomicBoolean(false);

    public OneToOneEdgeManager(EdgeManagerPluginContext context) {
        super(context);
    }

    public void initialize() {
    }

    public int getNumDestinationTaskPhysicalInputs(int destinationTaskIndex) {
        return 1;
    }

    public int getNumSourceTaskPhysicalOutputs(int sourceTaskIndex) {
        return 1;
    }

    public void routeDataMovementEventToDestination(DataMovementEvent event, int sourceTaskIndex, int sourceOutputIndex, Map<Integer, List<Integer>> destinationTaskAndInputIndices) {
        this.checkState();
        destinationTaskAndInputIndices.put(sourceTaskIndex, this.destinationInputIndices);
    }

    public void routeInputSourceTaskFailedEventToDestination(int sourceTaskIndex, Map<Integer, List<Integer>> destinationTaskAndInputIndices) {
        destinationTaskAndInputIndices.put(sourceTaskIndex, this.destinationInputIndices);
    }

    public int routeInputErrorEventToSource(InputReadErrorEvent event, int destinationTaskIndex, int destinationFailedInputIndex) {
        return destinationTaskIndex;
    }

    public int getNumDestinationConsumerTasks(int sourceTaskIndex) {
        return 1;
    }

    private void checkState() {
        if (this.stateChecked.get()) {
            return;
        }
        Preconditions.checkState((this.getContext().getSourceVertexNumTasks() == this.getContext().getDestinationVertexNumTasks() ? 1 : 0) != 0, (Object)("1-1 source and destination task counts must match. Destination: " + this.getContext().getDestinationVertexName() + " tasks: " + this.getContext().getDestinationVertexNumTasks() + " Source: " + this.getContext().getSourceVertexName() + " tasks: " + this.getContext().getSourceVertexNumTasks()));
        this.stateChecked.set(true);
    }
}

