/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.lifecycle;

import java.lang.reflect.Constructor;
import java.util.Collections;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.factory.ServiceConstructionException;

public class SingletonResourceProvider
implements ResourceProvider {
    private Object resourceInstance;
    private boolean callPostConstruct;

    public SingletonResourceProvider(Object o, boolean callPostConstruct) {
        this.resourceInstance = o;
        this.callPostConstruct = callPostConstruct;
    }

    public SingletonResourceProvider(Object o) {
        this(o, false);
    }

    public void init(Endpoint ep) {
        if (this.resourceInstance instanceof Constructor) {
            Constructor c = (Constructor)this.resourceInstance;
            MessageImpl m = new MessageImpl();
            ExchangeImpl exchange = new ExchangeImpl();
            exchange.put(Endpoint.class, ep);
            m.setExchange(exchange);
            Object[] values = ResourceUtils.createConstructorArguments(c, m, false, Collections.emptyMap());
            try {
                this.resourceInstance = values.length > 0 ? c.newInstance(values) : c.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new ServiceConstructionException(ex);
            }
        }
        if (this.callPostConstruct) {
            InjectionUtils.invokeLifeCycleMethod(this.resourceInstance, ResourceUtils.findPostConstructMethod(ClassHelper.getRealClass(this.resourceInstance)));
        }
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public Object getInstance(Message m) {
        return this.resourceInstance;
    }

    @Override
    public void releaseInstance(Message m, Object o) {
    }

    @Override
    public Class<?> getResourceClass() {
        return ClassHelper.getRealClass(this.resourceInstance);
    }
}

