/*
 * Decompiled with CFR 0.152.
 */
package colorspace;

import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import colorspace.EnumeratedColorSpaceMapper;
import colorspace.SYccColorSpaceMapper;
import icc.ICCProfileException;
import icc.ICCProfiler;
import java.io.IOException;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataAdapter;
import jj2000.j2k.util.ParameterList;

public abstract class ColorSpaceMapper
extends ImgDataAdapter
implements BlkImgDataSrc {
    public static final char OPT_PREFIX = 'I';
    protected static final String eol = System.getProperty("line.separator");
    protected DataBlkInt[] inInt;
    protected DataBlkFloat[] inFloat;
    protected DataBlkInt[] workInt;
    protected DataBlkFloat[] workFloat;
    protected int[][] dataInt;
    protected float[][] dataFloat;
    protected float[][] workDataFloat;
    protected int[][] workDataInt;
    protected int[] shiftValueArray = null;
    protected int[] maxValueArray = null;
    protected int[] fixedPtBitsArray = null;
    private static final String[][] pinfo = new String[][]{{"IcolorSpacedebug", null, "Print debugging messages during colorspace mapping.", "off"}};
    protected ParameterList pl = null;
    protected ColorSpace csMap = null;
    protected int ncomps = 0;
    protected BlkImgDataSrc src = null;
    protected DataBlk[] srcBlk = null;
    protected ComputedComponents computed = new ComputedComponents();

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    protected static void setInternalBuffer(DataBlk db) {
        switch (db.getDataType()) {
            case 3: {
                if (db.getData() != null && ((int[])db.getData()).length >= db.w * db.h) break;
                db.setData(new int[db.w * db.h]);
                break;
            }
            case 4: {
                if (db.getData() != null && ((float[])db.getData()).length >= db.w * db.h) break;
                db.setData(new float[db.w * db.h]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid output datablock type");
            }
        }
    }

    protected static void copyGeometry(DataBlk tgt, DataBlk src) {
        tgt.offset = 0;
        tgt.h = src.h;
        tgt.w = src.w;
        tgt.ulx = src.ulx;
        tgt.uly = src.uly;
        tgt.scanw = src.w;
        ColorSpaceMapper.setInternalBuffer(tgt);
    }

    public static BlkImgDataSrc createInstance(BlkImgDataSrc src, ColorSpace csMap) throws IOException, ColorSpaceException, ICCProfileException {
        ParameterList cfr_ignored_0 = csMap.pl;
        csMap.pl.checkList('I', ParameterList.toNameArray(pinfo));
        if (csMap.getMethod() == ColorSpace.ICC_PROFILED) {
            return ICCProfiler.createInstance(src, csMap);
        }
        ColorSpace.CSEnum colorspace = csMap.getColorSpace();
        if (colorspace == ColorSpace.sRGB) {
            return EnumeratedColorSpaceMapper.createInstance(src, csMap);
        }
        if (colorspace == ColorSpace.GreyScale) {
            return EnumeratedColorSpaceMapper.createInstance(src, csMap);
        }
        if (colorspace == ColorSpace.sYCC) {
            return SYccColorSpaceMapper.createInstance(src, csMap);
        }
        if (colorspace == ColorSpace.Unknown) {
            return null;
        }
        throw new ColorSpaceException("Bad color space specification in image");
    }

    protected ColorSpaceMapper(BlkImgDataSrc src, ColorSpace csMap) throws ColorSpaceException {
        super(src);
        this.src = src;
        this.csMap = csMap;
        this.initialize();
    }

    private void initialize() throws ColorSpaceException {
        this.pl = this.csMap.pl;
        this.ncomps = this.src.getNumComps();
        this.shiftValueArray = new int[this.ncomps];
        this.maxValueArray = new int[this.ncomps];
        this.fixedPtBitsArray = new int[this.ncomps];
        this.srcBlk = new DataBlk[this.ncomps];
        this.inInt = new DataBlkInt[this.ncomps];
        this.inFloat = new DataBlkFloat[this.ncomps];
        this.workInt = new DataBlkInt[this.ncomps];
        this.workFloat = new DataBlkFloat[this.ncomps];
        this.dataInt = new int[this.ncomps][];
        this.dataFloat = new float[this.ncomps][];
        this.workDataInt = new int[this.ncomps][];
        this.workDataFloat = new float[this.ncomps][];
        this.dataInt = new int[this.ncomps][];
        this.dataFloat = new float[this.ncomps][];
        for (int i = 0; i < this.ncomps; ++i) {
            this.shiftValueArray[i] = 1 << this.src.getNomRangeBits(i) - 1;
            this.maxValueArray[i] = (1 << this.src.getNomRangeBits(i)) - 1;
            this.fixedPtBitsArray[i] = this.src.getFixedPoint(i);
            this.inInt[i] = new DataBlkInt();
            this.inFloat[i] = new DataBlkFloat();
            this.workInt[i] = new DataBlkInt();
            this.workInt[i].progressive = this.inInt[i].progressive;
            this.workFloat[i] = new DataBlkFloat();
            this.workFloat[i].progressive = this.inFloat[i].progressive;
        }
    }

    @Override
    public int getFixedPoint(int c) {
        return this.src.getFixedPoint(c);
    }

    @Override
    public DataBlk getCompData(DataBlk out, int c) {
        return this.src.getCompData(out, c);
    }

    @Override
    public DataBlk getInternCompData(DataBlk out, int c) {
        return this.src.getInternCompData(out, c);
    }

    protected class ComputedComponents {
        private int tIdx = -1;
        private int h = -1;
        private int w = -1;
        private int ulx = -1;
        private int uly = -1;
        private int offset = -1;
        private int scanw = -1;

        public ComputedComponents() {
            this.clear();
        }

        public ComputedComponents(DataBlk db) {
            this.set(db);
        }

        public void set(DataBlk db) {
            this.h = db.h;
            this.w = db.w;
            this.ulx = db.ulx;
            this.uly = db.uly;
            this.offset = db.offset;
            this.scanw = db.scanw;
        }

        public void clear() {
            this.scanw = -1;
            this.offset = -1;
            this.uly = -1;
            this.ulx = -1;
            this.w = -1;
            this.h = -1;
        }

        public boolean equals(ComputedComponents cc) {
            return this.h == cc.h && this.w == cc.w && this.ulx == cc.ulx && this.uly == cc.uly && this.offset == cc.offset && this.scanw == cc.scanw;
        }
    }
}

