/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UncheckedIOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.QuantityFormat;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.util.AxisDirections;
import org.apache.sis.referencing.util.Formulas;
import org.apache.sis.referencing.util.ReferencingUtilities;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.internal.LocalizedParseException;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Ellipsoid;

public class CoordinateFormat
extends CompoundFormat<DirectPosition> {
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.measure");
    private static final long serialVersionUID = 6633388113040644304L;
    private static final int READ_AHEAD_LIMIT = 256;
    private static final int DEFAULT_DIMENSION = 4;
    private static final Set<Unit<?>> SCALABLES = Set.of(Units.METRE, Units.PASCAL);
    private String separator = "\u2003";
    private transient String parseSeparator = "";
    private Quantity<?> groundPrecision;
    private Quantity<?> groundAccuracy;
    private transient double accuracyThreshold;
    private transient long groundDimensions;
    private double[] desiredPrecisions;
    private transient boolean isPrecisionApplied;
    private transient boolean isAccuracyVisible;
    private CoordinateReferenceSystem defaultCRS;
    private transient CoordinateReferenceSystem lastCRS;
    private static final byte LONGITUDE = 1;
    private static final byte LATITUDE = 2;
    private static final byte ANGLE = 3;
    private static final byte DATE = 4;
    private static final byte TIME = 5;
    private static final byte INDEX = 6;
    private transient byte[] types;
    private transient Format[] sharedFormats;
    private transient Format[] formats;
    private transient Unit<?>[] units;
    private transient UnitConverter[] toFormatUnit;
    private transient String[] unitSymbols;
    private transient String[] unitSymbolsUnscaled;
    private transient String[] directionSymbols;
    private transient String accuracyText;
    private transient long negate;
    private transient long[] epochs;
    private transient FieldPosition dummy;
    private transient StringBuffer buffer;

    public CoordinateFormat() {
        this(Locale.getDefault(Locale.Category.FORMAT), TimeZone.getDefault());
    }

    public CoordinateFormat(Locale locale, TimeZone timezone) {
        super(locale, timezone);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        ArgumentChecks.ensureNonEmpty("separator", separator);
        this.separator = separator;
        this.parseSeparator = separator.strip();
    }

    public CoordinateReferenceSystem getDefaultCRS() {
        return this.defaultCRS;
    }

    public void setDefaultCRS(CoordinateReferenceSystem crs) {
        this.isPrecisionApplied &= crs == this.defaultCRS;
        this.defaultCRS = crs;
    }

    private void createFormats(CoordinateReferenceSystem crs) {
        this.types = null;
        this.formats = null;
        this.sharedFormats = null;
        this.units = null;
        this.toFormatUnit = null;
        this.unitSymbols = null;
        this.unitSymbolsUnscaled = null;
        this.directionSymbols = null;
        this.epochs = null;
        this.negate = 0L;
        this.lastCRS = crs;
        this.isPrecisionApplied = false;
        if (crs == null) {
            return;
        }
        CoordinateSystem cs = crs.getCoordinateSystem();
        if (cs == null) {
            return;
        }
        int dimension = cs.getDimension();
        byte[] types = new byte[dimension];
        Format[] formats = new Format[dimension];
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis axis = cs.getAxis(i);
            if (axis == null) {
                formats[i] = this.getDefaultFormat();
                continue;
            }
            AxisDirection direction = axis.getDirection();
            Unit<?> unit = axis.getUnit();
            if (Units.isAngular(unit)) {
                int type = 3;
                if (AxisDirection.NORTH.equals(direction)) {
                    type = 2;
                } else if (AxisDirection.EAST.equals(direction)) {
                    type = 1;
                } else if (AxisDirection.SOUTH.equals(direction)) {
                    type = 2;
                    this.negate(i);
                } else if (AxisDirection.WEST.equals(direction)) {
                    type = 1;
                    this.negate(i);
                }
                types[i] = type;
                formats[i] = this.getFormat(org.apache.sis.measure.Angle.class);
                this.setConverter(dimension, i, unit.asType(Angle.class).getConverterTo(Units.DEGREE));
                continue;
            }
            if (Units.isTemporal(unit)) {
                CoordinateReferenceSystem t = CRS.getComponentAt(crs, i, i + 1);
                if (t instanceof TemporalCRS) {
                    if (this.epochs == null) {
                        this.epochs = new long[dimension];
                    }
                    types[i] = 4;
                    formats[i] = this.getFormat(Date.class);
                    this.epochs[i] = ((TemporalCRS)t).getDatum().getOrigin().getTime();
                    this.setConverter(dimension, i, unit.asType(Time.class).getConverterTo(Units.MILLISECOND));
                    if (!AxisDirection.PAST.equals(direction)) continue;
                    this.negate(i);
                    continue;
                }
                types[i] = 5;
            } else if (AxisDirections.isGrid(direction) && (unit == null || Units.PIXEL.isCompatible(unit))) {
                types[i] = 6;
            }
            formats[i] = this.getFormat(types[i] == 6 ? Long.class : Number.class);
            if (unit != null) {
                if (this.units == null) {
                    this.units = new Unit[dimension];
                }
                this.units[i] = unit;
                String symbol = this.getFormat(Unit.class).format(unit);
                if (!symbol.isEmpty()) {
                    if (this.unitSymbols == null) {
                        this.unitSymbolsUnscaled = new String[dimension];
                        this.unitSymbols = this.unitSymbolsUnscaled;
                    }
                    this.unitSymbols[i] = "\u202f" + symbol;
                }
            }
            if (!AxisDirections.isCompass(direction)) continue;
            if (this.directionSymbols == null) {
                this.directionSymbols = new String[dimension * 2];
            }
            this.directionSymbols[i * 2] = CoordinateFormat.symbol(direction);
            this.directionSymbols[i * 2 + 1] = CoordinateFormat.symbol(AxisDirections.opposite(direction));
        }
        this.types = types;
        this.formats = formats;
        this.sharedFormats = formats;
    }

    private static String symbol(AxisDirection direction) {
        return ((StringBuilder)CharSequences.camelCaseToAcronym(direction.identifier())).insert(0, '\u00a0').toString();
    }

    private Format getFormatClone(int dim) {
        Format format;
        if (this.formats == this.sharedFormats) {
            this.formats = (Format[])this.formats.clone();
        }
        if ((format = this.formats[dim]) == this.sharedFormats[dim]) {
            this.formats[dim] = format = (Format)format.clone();
        }
        return format;
    }

    private Format getDefaultFormat() {
        return this.getFormat(Number.class);
    }

    private void setConverter(int dimension, int i, UnitConverter c) {
        if (!c.isIdentity()) {
            if (this.toFormatUnit == null) {
                this.toFormatUnit = new UnitConverter[dimension];
            }
            this.toFormatUnit[i] = c;
        }
    }

    private <Q extends Quantity<Q>> void scaleUnit(int i, Unit<Q> unit) {
        if (this.toFormatUnit == null) {
            this.toFormatUnit = new UnitConverter[this.formats.length];
        }
        if (this.toFormatUnit[i] == null) {
            Unit<Q> target = unit.multiply(1000.0);
            this.toFormatUnit[i] = unit.getConverterTo(target);
            if (this.unitSymbols == this.unitSymbolsUnscaled) {
                this.unitSymbols = (String[])this.unitSymbols.clone();
            }
            this.unitSymbols[i] = "\u202f" + this.getFormat(Unit.class).format(target);
        }
    }

    private void negate(int dimension) {
        if (dimension >= 64) {
            throw new ArithmeticException(Errors.format((short)37, dimension + 1));
        }
        this.negate |= 1L << dimension;
    }

    private boolean isNegative(int dimension) {
        return (this.negate & Numerics.bitmask(dimension)) != 0L;
    }

    public double[] getPrecisions() {
        this.configure(this.defaultCRS);
        Object[] cf = this.formats;
        if (cf == null) {
            cf = new Format[4];
            Arrays.fill(cf, this.getDefaultFormat());
        }
        double[] precisions = new double[cf.length];
        for (int i = 0; i < precisions.length; ++i) {
            Object f = cf[i];
            if (f instanceof DecimalFormat) {
                precisions[i] = MathFunctions.pow10(-((DecimalFormat)f).getMaximumFractionDigits());
                continue;
            }
            if (!(f instanceof AngleFormat)) continue;
            precisions[i] = ((AngleFormat)f).getPrecision();
        }
        return precisions;
    }

    public void setPrecisions(double ... precisions) {
        if (precisions == null) {
            this.desiredPrecisions = null;
            this.formats = this.sharedFormats;
        } else {
            if (this.desiredPrecisions == null || this.desiredPrecisions.length != precisions.length) {
                this.desiredPrecisions = new double[precisions.length];
            }
            this.isPrecisionApplied &= this.formats != null;
            for (int i = 0; i < precisions.length; ++i) {
                double p = Math.abs(precisions[i]);
                if (!(p < Double.POSITIVE_INFINITY)) {
                    p = 0.0;
                }
                if (this.desiredPrecisions[i] == (this.desiredPrecisions[i] = p) || !this.isPrecisionApplied) continue;
                this.applyPrecision(i);
            }
        }
        this.updateAccuracyVisibility();
    }

    private void applyPrecision(int dim) {
        double precision = this.desiredPrecisions[dim];
        if (precision > 0.0) {
            Format format = this.formats[dim];
            if (format instanceof DecimalFormat && (this.types == null || this.types[dim] != 6)) {
                Unit<?> unit;
                int digits = DecimalFunctions.fractionDigitsForDelta(precision, false);
                if (this.unitSymbols != null && SCALABLES.contains(unit = this.units[dim])) {
                    if (precision >= 10.0) {
                        digits += 3;
                        this.scaleUnit(dim, unit);
                    } else if (this.toFormatUnit != null) {
                        this.toFormatUnit[dim] = null;
                        this.unitSymbols[dim] = this.unitSymbolsUnscaled[dim];
                    }
                }
                digits = Math.max(digits, 0);
                DecimalFormat nf = (DecimalFormat)this.getFormatClone(dim);
                nf.setMinimumFractionDigits(digits);
                nf.setMaximumFractionDigits(digits);
            } else if (format instanceof AngleFormat) {
                ((AngleFormat)this.getFormatClone(dim)).setPrecision(precision, true);
            }
        }
    }

    private void configure(CoordinateReferenceSystem crs) {
        if (this.lastCRS != crs) {
            this.createFormats(crs);
        }
        if (!this.isPrecisionApplied) {
            if (this.groundPrecision != null) {
                this.applyGroundPrecision(crs);
            }
            if (this.desiredPrecisions != null) {
                if (this.sharedFormats == null) {
                    this.sharedFormats = new Format[this.desiredPrecisions.length];
                    this.formats = this.sharedFormats;
                    Arrays.fill(this.formats, this.getDefaultFormat());
                    this.types = new byte[this.formats.length];
                }
                int n = Math.min(this.desiredPrecisions.length, this.formats.length);
                for (int i = 0; i < n; ++i) {
                    this.applyPrecision(i);
                }
            }
            this.applyGroundAccuracy(crs);
            this.updateAccuracyVisibility();
            this.isPrecisionApplied = true;
        }
    }

    public void setGroundPrecision(Quantity<?> precision) {
        ArgumentChecks.ensureNonNull("precision", precision);
        this.groundPrecision = precision;
        if (this.isPrecisionApplied) {
            this.applyGroundPrecision(this.lastCRS);
        }
    }

    public void setGroundAccuracy(Quantity<?> accuracy) {
        this.accuracyText = null;
        this.groundAccuracy = accuracy;
        if (accuracy != null) {
            NumberFormat nf = NumberFormat.getInstance(this.getLocale(Locale.Category.FORMAT));
            QuantityFormat f = new QuantityFormat(nf, (UnitFormat)this.getFormat(Unit.class));
            if (this.buffer == null) {
                this.buffer = new StringBuffer();
            }
            this.buffer.setLength(0);
            this.accuracyText = f.format(accuracy, this.buffer.append("\u2003\u00b1\u00a0"), this.dummy).toString();
        }
        if (this.isPrecisionApplied) {
            this.applyGroundAccuracy(this.lastCRS);
            this.updateAccuracyVisibility();
        }
    }

    private void applyGroundPrecision(CoordinateReferenceSystem crs) {
        CoordinateSystem cs;
        IncommensurableException error;
        Resolution derived;
        Resolution specified = new Resolution(this.groundPrecision);
        try {
            derived = specified.derived(crs);
            error = null;
        }
        catch (IncommensurableException e) {
            derived = null;
            error = e;
        }
        this.groundDimensions = 0L;
        boolean useSpecified = false;
        boolean useDerived = false;
        if (crs != null && (cs = crs.getCoordinateSystem()) != null) {
            int dimension = cs.getDimension();
            boolean useAllAxes = false;
            while (true) {
                for (int i = 0; i < dimension; ++i) {
                    CoordinateSystemAxis axis = cs.getAxis(i);
                    if (axis == null) continue;
                    AxisDirection direction = axis.getDirection();
                    if (!useAllAxes && !AxisDirections.isCompass(direction)) continue;
                    specified.findMaxValue(axis);
                    Unit<?> axisUnit = axis.getUnit();
                    if (axisUnit == null) continue;
                    try {
                        boolean done = specified.findMinResolution(axisUnit, useSpecified);
                        useSpecified |= done;
                        if (!done && derived != null) {
                            done = derived.findMinResolution(axisUnit, useDerived);
                            useDerived |= done;
                        }
                        if (!done) continue;
                        this.groundDimensions |= Numerics.bitmask(i);
                        continue;
                    }
                    catch (IncommensurableException e) {
                        if (error == null) {
                            error = e;
                            continue;
                        }
                        error.addSuppressed(e);
                    }
                }
                if (useSpecified | useDerived) break;
                if (useAllAxes) {
                    useSpecified = true;
                    derived = null;
                    break;
                }
                useAllAxes = true;
            }
        }
        if (useSpecified) {
            specified.setPrecision(this);
        }
        if (useDerived) {
            derived.setPrecision(this);
        }
        if (error != null) {
            CoordinateFormat.unexpectedException("setGroundPrecision", error);
        }
    }

    private void applyGroundAccuracy(CoordinateReferenceSystem crs) {
        block7: {
            long dimensions = this.groundDimensions;
            if (dimensions != 0L && this.groundAccuracy != null) {
                try {
                    int i;
                    Resolution specified = new Resolution(this.groundAccuracy);
                    Resolution derived = specified.derived(crs);
                    CoordinateSystem cs = crs.getCoordinateSystem();
                    this.accuracyThreshold = 0.0;
                    do {
                        double accuracy;
                        Unit<?> unit;
                        if ((unit = cs.getAxis(i = Long.numberOfTrailingZeros(dimensions)).getUnit()).isCompatible(specified.unit)) {
                            accuracy = specified.resolution(unit);
                        } else {
                            if (derived == null || !unit.isCompatible(derived.unit)) break block7;
                            accuracy = derived.resolution(unit);
                        }
                        if (!(accuracy > this.accuracyThreshold)) continue;
                        this.accuracyThreshold = accuracy;
                    } while ((dimensions &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
                    return;
                }
                catch (IncommensurableException e) {
                    CoordinateFormat.unexpectedException("setGroundAccuracy", e);
                }
            }
        }
        this.accuracyThreshold = Double.POSITIVE_INFINITY;
    }

    private void updateAccuracyVisibility() {
        long dimensions;
        boolean bl = this.isAccuracyVisible = this.accuracyText != null;
        if (this.isAccuracyVisible && this.desiredPrecisions != null && (dimensions = this.groundDimensions & Numerics.bitmask(this.desiredPrecisions.length) - 1L) != 0L) {
            int i;
            this.isAccuracyVisible = false;
            do {
                double precision;
                if (!((precision = this.desiredPrecisions[i = Long.numberOfTrailingZeros(dimensions)]) > 0.0) || !(precision <= this.accuracyThreshold)) continue;
                this.isAccuracyVisible = true;
                break;
            } while ((dimensions &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
        }
    }

    public Quantity<?> getGroundAccuracy() {
        return this.groundAccuracy;
    }

    public Optional<String> getGroundAccuracyText() {
        return Optional.ofNullable(this.accuracyText);
    }

    public String getPattern(Class<?> valueType) {
        Format format = this.getFormat(valueType);
        if (format instanceof AngleFormat) {
            return ((AngleFormat)format).toPattern();
        }
        if (format instanceof DecimalFormat) {
            return ((DecimalFormat)format).toPattern();
        }
        if (format instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)format).toPattern();
        }
        return null;
    }

    public boolean applyPattern(Class<?> valueType, String pattern) {
        ArgumentChecks.ensureNonNull("pattern", pattern);
        Format format = this.getFormat(valueType);
        if (format instanceof DecimalFormat) {
            ((DecimalFormat)format).applyPattern(pattern);
        } else if (format instanceof SimpleDateFormat) {
            ((SimpleDateFormat)format).applyPattern(pattern);
        } else if (format instanceof AngleFormat) {
            ((AngleFormat)format).applyPattern(pattern);
        } else {
            return false;
        }
        this.formats = this.sharedFormats;
        return true;
    }

    @Override
    public final Class<DirectPosition> getValueType() {
        return DirectPosition.class;
    }

    @Override
    protected Format createFormat(Class<?> valueType) {
        Locale locale;
        if (valueType == Date.class && !Locale.ROOT.equals(locale = super.getLocale())) {
            DateFormat format = DateFormat.getDateTimeInstance(3, 3, locale);
            format.setTimeZone(this.getTimeZone());
            return format;
        }
        return super.createFormat(valueType);
    }

    public String format(DirectPosition position) {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.setLength(0);
        try {
            this.format(position, (Appendable)this.buffer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return this.buffer.toString();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void format(DirectPosition position, Appendable toAppendTo) throws IOException {
        ArgumentChecks.ensureNonNull("position", position);
        ArgumentChecks.ensureNonNull("toAppendTo", toAppendTo);
        crs = position.getCoordinateReferenceSystem();
        if (crs == null) {
            crs = this.defaultCRS;
        }
        this.configure(crs);
        if (toAppendTo instanceof StringBuffer) {
            destination = (StringBuffer)toAppendTo;
        } else {
            if (this.buffer == null) {
                this.buffer = new StringBuffer();
            }
            destination = this.buffer;
            destination.setLength(0);
        }
        if (this.dummy == null) {
            this.dummy = new FieldPosition(0);
        }
        dimension = position.getDimension();
        for (i = 0; i < dimension; ++i) {
            block25: {
                block24: {
                    value = position.getOrdinate(i);
                    if (this.formats == null || i >= this.formats.length) break block24;
                    f = this.formats[i];
                    v0 = unit = this.unitSymbols != null ? this.unitSymbols[i] : null;
                    if (this.directionSymbols == null) {
                        direction = null;
                    } else if (value < 0.0) {
                        value = -value;
                        direction = this.directionSymbols[i * 2 + 1];
                    } else {
                        direction = this.directionSymbols[i * 2];
                    }
                    if (this.isNegative(i)) {
                        value = -value;
                    }
                    if (this.toFormatUnit != null && (c = this.toFormatUnit[i]) != null) {
                        value = c.convert(value);
                    }
                    switch (this.types[i]) {
                        default: {
                            valueObject /* !! */  = value;
                            break block25;
                        }
                        case 6: {
                            valueObject /* !! */  = Math.round(value);
                            break block25;
                        }
                        case 1: {
                            valueObject /* !! */  = new Longitude(value);
                            break block25;
                        }
                        case 2: {
                            valueObject /* !! */  = new Latitude(value);
                            break block25;
                        }
                        case 3: {
                            valueObject /* !! */  = new org.apache.sis.measure.Angle(value);
                            break block25;
                        }
                        case 4: {
                            if (!Double.isFinite(value)) ** GOTO lbl54
                            valueObject /* !! */  = new Date(Math.addExact(Math.round(value), this.epochs[i]));
                            break block25;
lbl54:
                            // 1 sources

                            if (i != 0) {
                                toAppendTo.append(this.separator);
                            }
                            toAppendTo.append(String.valueOf(value));
                            break;
                        }
                    }
                    continue;
                }
                valueObject /* !! */  = value;
                f = this.getDefaultFormat();
                direction = null;
                unit = null;
            }
            if (i != 0) {
                toAppendTo.append(this.separator);
            }
            if (f.format(valueObject /* !! */ , destination, this.dummy) != toAppendTo) {
                toAppendTo.append(destination);
                destination.setLength(0);
            }
            if (unit != null) {
                toAppendTo.append(unit);
            }
            if (direction == null) continue;
            toAppendTo.append(direction);
        }
        if (this.isAccuracyVisible) {
            toAppendTo.append(this.accuracyText);
        }
    }

    @Override
    public DirectPosition parse(CharSequence text, ParsePosition pos) throws ParseException {
        int lg;
        int index;
        double[] coordinates;
        Format format;
        Format[] formats;
        String asString;
        ParsePosition subPos;
        int offset;
        ArgumentChecks.ensureNonNull("text", text);
        ArgumentChecks.ensureNonNull("pos", pos);
        int start = pos.getIndex();
        int length = text.length();
        if (text instanceof String) {
            offset = 0;
            subPos = pos;
            asString = (String)text;
        } else {
            offset = start;
            subPos = new ParsePosition(0);
            asString = text.subSequence(start, Math.min(start + 256, length)).toString();
        }
        if (this.lastCRS != this.defaultCRS) {
            this.createFormats(this.defaultCRS);
        }
        if ((formats = this.formats) != null) {
            format = null;
            coordinates = new double[formats.length];
        } else {
            format = this.getDefaultFormat();
            coordinates = new double[4];
        }
        for (int i = 0; i < coordinates.length; ++i) {
            Unit<?> target;
            Object object;
            block49: {
                if (i != 0) {
                    Object[] args;
                    short key;
                    int index2;
                    int c;
                    int end = subPos.getIndex();
                    for (index2 = offset + end; index2 < length; index2 += Character.charCount(c)) {
                        if (this.parseSeparator.isEmpty()) {
                            int next = CharSequences.skipLeadingWhitespaces(text, index2, length);
                            if (next > index2) {
                                subPos.setIndex(next - offset);
                                break block49;
                            }
                        } else if (CharSequences.regionMatches(text, index2, this.parseSeparator)) {
                            subPos.setIndex(index2 + this.parseSeparator.length() - offset);
                            break block49;
                        }
                        if (!Character.isSpaceChar(c = Character.codePointAt(text, index2))) break;
                    }
                    if (formats == null) {
                        pos.setIndex(index2);
                        return new GeneralDirectPosition(Arrays.copyOf(coordinates, i));
                    }
                    pos.setIndex(start);
                    pos.setErrorIndex(index2);
                    CharSequence previous = text.subSequence(start, end);
                    CharSequence found = CharSequences.token(text, index2);
                    if (found.length() != 0) {
                        key = 135;
                        args = new CharSequence[]{previous, found};
                    } else {
                        key = 138;
                        args = new CharSequence[]{previous};
                    }
                    throw new LocalizedParseException(this.getLocale(), key, args, index2);
                }
            }
            if (formats != null) {
                format = formats[i];
            }
            if ((object = format.parseObject(asString, subPos)) == null) {
                Class type = Number.class;
                if (this.types != null) {
                    switch (this.types[i]) {
                        case 1: {
                            type = Longitude.class;
                            break;
                        }
                        case 2: {
                            type = Latitude.class;
                            break;
                        }
                        case 3: {
                            type = org.apache.sis.measure.Angle.class;
                            break;
                        }
                        case 4: {
                            type = Date.class;
                            break;
                        }
                        case 6: {
                            type = Long.class;
                        }
                    }
                }
                pos.setIndex(start);
                if (subPos != pos) {
                    pos.setErrorIndex(offset + subPos.getErrorIndex());
                }
                throw new LocalizedParseException(this.getLocale(), type, text, pos);
            }
            double value = object instanceof org.apache.sis.measure.Angle ? ((org.apache.sis.measure.Angle)object).degrees() : (object instanceof Date ? (double)Math.subtractExact(((Date)object).getTime(), this.epochs[i]) : ((Number)object).doubleValue());
            String direction = null;
            String opposite = null;
            if (this.directionSymbols != null) {
                direction = this.directionSymbols[i * 2];
                opposite = this.directionSymbols[i * 2 + 1];
            }
            UnitConverter toCRS = null;
            if (this.units != null && (target = this.units[i]) != null) {
                int base;
                int c;
                for (int index3 = base = subPos.getIndex(); index3 < asString.length(); index3 += Character.charCount(c)) {
                    c = asString.codePointAt(index3);
                    if (Character.isSpaceChar(c)) {
                        continue;
                    }
                    int stopAt = index3;
                    int nextAt = -1;
                    if (direction != null) {
                        while ((stopAt += Character.charCount(c)) < asString.length()) {
                            c = asString.codePointAt(stopAt);
                            if (!Character.isSpaceChar(c)) continue;
                            if (asString.regionMatches(true, stopAt, direction, 0, direction.length())) {
                                nextAt = stopAt + direction.length();
                                break;
                            }
                            if (!asString.regionMatches(true, stopAt, opposite, 0, opposite.length())) break;
                            nextAt = stopAt + opposite.length();
                            value = -value;
                            break;
                        }
                    }
                    Format f = this.getFormat(Unit.class);
                    try {
                        Object unit;
                        if (nextAt < 0) {
                            subPos.setIndex(index3);
                            unit = f.parseObject(asString, subPos);
                        } else {
                            unit = f.parseObject(asString.substring(index3, stopAt));
                            subPos.setIndex(nextAt);
                            opposite = null;
                            direction = null;
                        }
                        if (unit == null) {
                            subPos.setIndex(base);
                            subPos.setErrorIndex(-1);
                        } else {
                            toCRS = ((Unit)unit).getConverterToAny(target);
                        }
                        break;
                    }
                    catch (ParseException | IncommensurableException e) {
                        pos.setIndex(start);
                        pos.setErrorIndex(index3 += offset);
                        if (e instanceof ParseException) {
                            throw (ParseException)e;
                        }
                        throw (ParseException)new ParseException(e.getMessage(), index3).initCause(e);
                    }
                }
            } else if (this.toFormatUnit != null && (toCRS = this.toFormatUnit[i]) != null) {
                toCRS = toCRS.inverse();
            }
            if (direction != null) {
                int index4 = subPos.getIndex();
                if (asString.regionMatches(true, index4, direction, 0, direction.length())) {
                    index4 += direction.length();
                } else if (asString.regionMatches(true, index4, opposite, 0, opposite.length())) {
                    index4 += opposite.length();
                    value = -value;
                }
                subPos.setIndex(index4);
            }
            if (toCRS != null) {
                value = toCRS.convert(value);
            }
            if (this.isNegative(i)) {
                value = -value;
            }
            coordinates[i] = value;
        }
        if (this.accuracyText != null && asString.regionMatches(true, index = subPos.getIndex(), this.accuracyText, 0, lg = this.accuracyText.length())) {
            subPos.setIndex(index + lg);
        }
        GeneralDirectPosition position = new GeneralDirectPosition(coordinates);
        position.setCoordinateReferenceSystem(this.defaultCRS);
        return position;
    }

    private static void unexpectedException(String method, Exception error) {
        Logging.unexpectedException(LOGGER, CoordinateFormat.class, method, error);
    }

    @Override
    public CoordinateFormat clone() {
        CoordinateFormat clone = (CoordinateFormat)super.clone();
        clone.dummy = null;
        clone.buffer = null;
        clone.createFormats(null);
        if (this.desiredPrecisions != null) {
            clone.desiredPrecisions = (double[])this.desiredPrecisions.clone();
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.parseSeparator = this.separator.strip();
    }

    private static final class Resolution {
        private double magnitude;
        private double resolution;
        private Unit<?> unit;
        final boolean isAngular;

        Resolution(Quantity<?> groundPrecision) {
            this.resolution = Math.abs(groundPrecision.getValue().doubleValue());
            this.unit = groundPrecision.getUnit();
            this.isAngular = Units.isAngular(this.unit);
        }

        private Resolution(Resolution specified, double radius, Unit<Length> axisUnit) throws IncommensurableException {
            boolean bl = this.isAngular = !specified.isAngular;
            if (this.isAngular) {
                this.resolution = Math.toDegrees(specified.resolution(axisUnit) / radius);
                this.unit = Units.DEGREE;
            } else {
                this.resolution = specified.resolution(Units.RADIAN) * radius;
                this.unit = axisUnit;
            }
        }

        Resolution derived(CoordinateReferenceSystem crs) throws IncommensurableException {
            Unit<Length> axisUnit;
            Ellipsoid ellipsoid;
            double radius;
            if ((this.isAngular || Units.isLinear(this.unit)) && (radius = Formulas.getAuthalicRadius(ellipsoid = ReferencingUtilities.getEllipsoid(crs))) > 0.0 && (axisUnit = ellipsoid.getAxisUnit()) != null) {
                return new Resolution(this, radius, axisUnit);
            }
            return null;
        }

        private double resolution(Unit<?> target) throws IncommensurableException {
            return Math.abs(this.unit.getConverterToAny(target).convert(this.resolution));
        }

        boolean findMinResolution(Unit<?> axisUnit, boolean hasPrevious) throws IncommensurableException {
            if (!axisUnit.isCompatible(this.unit)) {
                return false;
            }
            double r = this.resolution(axisUnit);
            if (!hasPrevious || r < this.resolution) {
                this.resolution = r;
                this.unit = axisUnit;
            }
            return true;
        }

        final void findMaxValue(CoordinateSystemAxis axis) {
            double maxValue = Math.max(Math.abs(axis.getMinimumValue()), Math.abs(axis.getMaximumValue()));
            if (maxValue > this.magnitude) {
                this.magnitude = maxValue;
            }
        }

        void setPrecision(CoordinateFormat owner) {
            if (Units.isTemporal(this.unit)) {
                return;
            }
            Format format = owner.getFormat(this.isAngular ? org.apache.sis.measure.Angle.class : Number.class);
            if (format instanceof DecimalFormat) {
                if (this.resolution == 0.0) {
                    this.resolution = 1.0E-6;
                }
                int p = Math.max(0, DecimalFunctions.fractionDigitsForDelta(this.resolution, true));
                int m = Math.max(0, DecimalFunctions.fractionDigitsForDelta(Math.ulp(this.magnitude), false));
                ((DecimalFormat)format).setMinimumFractionDigits(Math.min(p, m));
                ((DecimalFormat)format).setMaximumFractionDigits(p);
            } else if (format instanceof AngleFormat) {
                ((AngleFormat)format).setPrecision(this.resolution, true);
            }
        }
    }
}

