/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.scanner;

import jakarta.decorator.Decorator;
import jakarta.enterprise.context.Dependent;
import jakarta.interceptor.Interceptor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.corespi.scanner.xbean.CdiArchive;
import org.apache.webbeans.corespi.scanner.xbean.OwbAnnotationFinder;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.BdaScannerService;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.UrlSet;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.ClassLoaders;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.util.Files;

public abstract class AbstractMetaDataDiscovery
implements BdaScannerService {
    protected static final Logger logger = WebBeansLoggerFacade.getLogger(AbstractMetaDataDiscovery.class);
    public static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    private static final String DEPENDENT_CLASS = Dependent.class.getName();
    private Map<String, Boolean> annotationCache = new HashMap<String, Boolean>();
    private BeanArchiveService beanArchiveService;
    private final UrlSet beanArchiveLocations = new UrlSet();
    private final Map<String, URL> beanDeploymentUrls = new HashMap<String, URL>();
    private Map<BeanArchiveService.BeanArchiveInformation, Set<Class<?>>> beanClassesPerBda;
    protected String[] scanningExcludes;
    protected ClassLoader loader;
    protected CdiArchive archive;
    protected OwbAnnotationFinder finder;
    protected boolean isBDAScannerEnabled;
    protected BDABeansXmlScanner bdaBeansXmlScanner;
    protected WebBeansContext webBeansContext;

    protected AnnotationFinder initFinder() {
        if (this.finder != null) {
            return this.finder;
        }
        WebBeansContext webBeansContext = this.webBeansContext();
        if (this.beanArchiveService == null) {
            this.beanArchiveService = webBeansContext.getBeanArchiveService();
        }
        Filter userFilter = webBeansContext.getService(Filter.class);
        Map<String, URL> beanDeploymentUrls = this.getBeanDeploymentUrls();
        if (!webBeansContext.getOpenWebBeansConfiguration().getScanExtensionJars()) {
            webBeansContext.getExtensionLoader().loadExtensionServices();
            Set<URL> extensionJars = webBeansContext.getExtensionLoader().getExtensionJars();
            beanDeploymentUrls = extensionJars.isEmpty() ? beanDeploymentUrls : beanDeploymentUrls.entrySet().stream().filter(it -> !extensionJars.contains(it.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            extensionJars.clear();
        }
        this.archive = new CdiArchive(this.beanArchiveService, WebBeansUtil.getCurrentClassLoader(), beanDeploymentUrls, userFilter, this.getAdditionalArchive());
        this.finder = new OwbAnnotationFinder(this.archive);
        return this.finder;
    }

    protected Archive getAdditionalArchive() {
        return null;
    }

    protected Iterable<URL> getBeanArchiveUrls() {
        return this.beanArchiveLocations;
    }

    public Map<String, URL> getBeanDeploymentUrls() {
        return this.beanDeploymentUrls;
    }

    public void scan() throws WebBeansDeploymentException {
        try {
            this.configure();
            this.initFinder();
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException(e);
        }
    }

    protected abstract void configure();

    /*
     * WARNING - void declaration
     */
    protected void registerBeanArchives(ClassLoader loader) {
        this.loader = loader;
        try {
            Set classPathUrls = ClassLoaders.findUrls((ClassLoader)loader);
            Map<File, URL> classpathFiles = this.toFiles(classPathUrls);
            Enumeration<URL> beansXmlUrls = loader.getResources(META_INF_BEANS_XML);
            block2: while (beansXmlUrls.hasMoreElements()) {
                void var7_13;
                URL beansXmlUrl = beansXmlUrls.nextElement();
                this.addWebBeansXmlLocation(beansXmlUrl);
                if (classpathFiles == null) {
                    String beansXml = beansXmlUrl.toExternalForm();
                    beansXml = this.stripProtocol(beansXml);
                    Iterator iterator = classPathUrls.iterator();
                    while (iterator.hasNext()) {
                        URL cpUrl = (URL)iterator.next();
                        if (!beansXml.startsWith(this.stripProtocol(cpUrl.toExternalForm()))) continue;
                        iterator.remove();
                        this.addDeploymentUrl(beansXml, cpUrl);
                        continue block2;
                    }
                    continue;
                }
                File key = Files.toFile((URL)beansXmlUrl);
                URL uRL = classpathFiles.remove(key);
                if (uRL == null && "beans.xml".equals(key.getName()) && key.getParentFile() != null && "META-INF".equals(key.getParentFile().getName())) {
                    key = key.getParentFile().getParentFile();
                    URL uRL2 = classpathFiles.remove(key);
                }
                if (var7_13 == null) continue;
                this.addDeploymentUrl(beansXmlUrl.toExternalForm(), (URL)var7_13);
            }
            boolean onlyBeansXmlJars = this.webBeansContext().getOpenWebBeansConfiguration().scanOnlyBeansXmlJars();
            if (!onlyBeansXmlJars) {
                this.filterExcludedJars(classPathUrls);
                if (classpathFiles != null) {
                    classpathFiles = classpathFiles.entrySet().stream().filter(e -> classPathUrls.contains(e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                }
                for (URL uRL : classpathFiles == null ? classPathUrls : classpathFiles.values()) {
                    if (!this.isBdaUrlEnabled(uRL)) continue;
                    this.addWebBeansXmlLocation(uRL);
                    this.addDeploymentUrl(uRL.toExternalForm(), uRL);
                }
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    protected Map<File, URL> toFiles(Set<URL> classPathUrls) {
        try {
            Map<File, URL> collected = classPathUrls.stream().collect(Collectors.toMap(Files::toFile, Function.identity(), (a, b) -> a));
            if (collected.containsKey(null)) {
                return null;
            }
            return collected;
        }
        catch (RuntimeException re) {
            return null;
        }
    }

    protected String stripProtocol(String urlPath) {
        int pos = urlPath.lastIndexOf(":/");
        if (pos > 0) {
            return urlPath.substring(pos + 1);
        }
        return urlPath;
    }

    protected void filterExcludedJars(Set<URL> classPathUrls) {
        classPathUrls.removeIf(i -> this.isExcludedJar((URL)i));
    }

    protected boolean isExcludedJar(URL url) {
        String filename;
        File file;
        String path = url.toExternalForm();
        int knownJarIdx = this.isExcludedJar(path);
        if (knownJarIdx > 0 && knownJarIdx < path.indexOf(".jar")) {
            return true;
        }
        return path.contains("geronimo-") && (file = Files.toFile((URL)url)) != null && (filename = file.getName()).startsWith("geronimo-") && filename.contains("_spec");
    }

    protected int isExcludedJar(String path) {
        this.initScanningExcludes();
        for (String p : this.scanningExcludes) {
            int i = path.indexOf(p);
            if (i <= 0) continue;
            return i;
        }
        return -1;
    }

    public void release() {
        this.finder = null;
        this.archive = null;
        this.loader = null;
        this.annotationCache.clear();
    }

    protected void addDeploymentUrl(String beansXml, URL cpUrl) {
        this.beanDeploymentUrls.put(beansXml, cpUrl);
    }

    protected boolean isBdaUrlEnabled(URL bdaUrl) {
        return true;
    }

    public void init(Object object) {
        String usage = WebBeansContext.currentInstance().getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.useBDABeansXMLScanner");
        this.isBDAScannerEnabled = Boolean.parseBoolean(usage);
        this.initScanningExcludes();
    }

    public void initScanningExcludes() {
        if (this.scanningExcludes == null) {
            OpenWebBeansConfiguration owbConfiguration = WebBeansContext.currentInstance().getOpenWebBeansConfiguration();
            String scanningExcludesProperty = owbConfiguration.getProperty("org.apache.webbeans.scanExclusionPaths");
            List<String> excludes = owbConfiguration.splitValues(scanningExcludesProperty);
            this.scanningExcludes = excludes.toArray(new String[excludes.size()]);
        }
    }

    protected void addWebBeansXmlLocation(URL beanArchiveUrl) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("added beans archive URL: " + beanArchiveUrl.toExternalForm());
        }
        this.doAddWebBeansXmlLocation(beanArchiveUrl);
    }

    protected void doAddWebBeansXmlLocation(URL beanArchiveUrl) {
        this.beanArchiveLocations.add(beanArchiveUrl);
        if (this.beanArchiveService == null) {
            this.beanArchiveService = this.webBeansContext().getBeanArchiveService();
        }
        this.beanArchiveService.getBeanArchiveInformation(beanArchiveUrl);
    }

    public Map<BeanArchiveService.BeanArchiveInformation, Set<Class<?>>> getBeanClassesPerBda() {
        if (this.beanClassesPerBda == null) {
            this.beanClassesPerBda = new HashMap();
            ClassLoader loader = WebBeansUtil.getCurrentClassLoader();
            boolean dontSkipNCDFT = this.webBeansContext == null || !this.webBeansContext.getOpenWebBeansConfiguration().isSkipNoClassDefFoundErrorTriggers();
            for (CdiArchive.FoundClasses foundClasses : this.archive.classesByUrl().values()) {
                HashSet classSet = new HashSet();
                boolean scanModeAnnotated = BeanArchiveService.BeanDiscoveryMode.ANNOTATED == foundClasses.getBeanArchiveInfo().getBeanDiscoveryMode();
                for (String className : foundClasses.getClassNames()) {
                    try {
                        Class<?> clazz;
                        AnnotationFinder.ClassInfo classInfo;
                        if (scanModeAnnotated && ((classInfo = this.finder.getClassInfo(className)) == null || !this.isBeanAnnotatedClass(classInfo)) || (clazz = ClassUtil.getClassFromName(className, loader, dontSkipNCDFT)) == null) continue;
                        if (dontSkipNCDFT) {
                            clazz.getDeclaredFields();
                        }
                        classSet.add(clazz);
                    }
                    catch (NoClassDefFoundError e) {
                        if (this.isAnonymous(className)) {
                            if (!logger.isLoggable(Level.FINE)) continue;
                            logger.log(Level.FINE, "WARN_0018", new Object[]{className, e.toString()});
                            continue;
                        }
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.log(Level.WARNING, "WARN_0018", new Object[]{className, e.toString()});
                    }
                }
                this.beanClassesPerBda.put(foundClasses.getBeanArchiveInfo(), classSet);
            }
        }
        return this.beanClassesPerBda;
    }

    private boolean isAnonymous(String className) {
        int start = className.lastIndexOf(36);
        if (start <= 0) {
            return false;
        }
        try {
            Integer.parseInt(className.substring(start + 1));
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public Set<Class<?>> getBeanClasses() {
        return Collections.EMPTY_SET;
    }

    protected boolean isBeanAnnotatedClass(AnnotationFinder.ClassInfo classInfo) {
        for (AnnotationFinder.AnnotationInfo annotationInfo : classInfo.getAnnotations()) {
            if (!Interceptor.class.getName().equals(annotationInfo.getName()) && !Decorator.class.getName().equals(annotationInfo.getName()) && !this.isBeanAnnotation(annotationInfo)) continue;
            return true;
        }
        return false;
    }

    protected boolean isBeanAnnotation(AnnotationFinder.AnnotationInfo annotationInfo) {
        String annotationName = annotationInfo.getName();
        Boolean isBeanAnnotation = this.annotationCache.get(annotationName);
        if (isBeanAnnotation != null) {
            return isBeanAnnotation;
        }
        try {
            Class<?> annotationType = WebBeansUtil.getCurrentClassLoader().loadClass(annotationName);
            isBeanAnnotation = DEPENDENT_CLASS.equals(annotationName) || this.webBeansContext().getBeanManagerImpl().isNormalScope(annotationType);
            if (!isBeanAnnotation.booleanValue()) {
                isBeanAnnotation = this.webBeansContext().getBeanManagerImpl().isStereotype(annotationType);
            }
            this.annotationCache.put(annotationName, isBeanAnnotation);
            return isBeanAnnotation;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Set<URL> getBeanXmls() {
        return Collections.unmodifiableSet(this.beanArchiveLocations);
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return this.bdaBeansXmlScanner;
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return this.isBDAScannerEnabled;
    }

    protected WebBeansContext webBeansContext() {
        if (this.webBeansContext == null) {
            this.webBeansContext = WebBeansContext.getInstance();
        }
        return WebBeansContext.getInstance();
    }
}

