/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.conf;

import java.security.AccessController;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.StringUtil;

public class ClassListValue
extends Value {
    private Class<?>[] _values = new Class[0];

    public void set(Class<?>[] values) {
        this.assertChangeable();
        if (values != null) {
            this._values = values;
        }
        this.valueChanged();
    }

    public Class<?>[] get() {
        return this._values;
    }

    public Class<Class[]> getValueType() {
        return Class[].class;
    }

    @Override
    protected String getInternalString() {
        return Stream.of(this._values).map(Class::getName).collect(Collectors.joining(","));
    }

    @Override
    protected void setInternalString(String val) {
        String[] vals = StringUtil.split(val, ",", 0);
        if (vals.length == 0) {
            this.set(null);
            return;
        }
        ClassLoader loader = AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        this.set((Class[])Stream.of(vals).map(v -> {
            try {
                return loader.loadClass(v.trim());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }).toArray(Class[]::new));
    }

    @Override
    protected void setInternalObject(Object obj) {
        this.set((Class[])obj);
    }
}

