/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.http;

import jakarta.security.enterprise.authentication.mechanism.http.LoginToContinue;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.Principal;
import java.util.Set;
import org.apache.tomee.security.http.SavedAuthentication;
import org.apache.tomee.security.http.SavedRequest;

public interface LoginToContinueMechanism {
    public static final int MAX_SAVE_POST_SIZE = 4096;
    public static final String ORIGINAL_REQUEST = "org.apache.tomee.security.request.original";
    public static final String AUTHENTICATION = "org.apache.tomee.security.request.authentication";
    public static final String CALLER_AUTHENICATION = "org.apache.tomee.security.request.caller.authentication";

    public LoginToContinue getLoginToContinue();

    public static void saveRequest(HttpServletRequest request) throws IOException {
        request.getSession().setAttribute(ORIGINAL_REQUEST, (Object)SavedRequest.fromRequest(request));
    }

    public static boolean matchRequest(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        SavedRequest originalRequest = (SavedRequest)request.getSession().getAttribute(ORIGINAL_REQUEST);
        if (originalRequest == null) {
            return false;
        }
        String requestURI = request.getRequestURI();
        return requestURI != null && requestURI.equals(originalRequest.getUrlWithQueryString());
    }

    public static boolean hasRequest(HttpServletRequest request) {
        return request.getSession().getAttribute(ORIGINAL_REQUEST) != null;
    }

    public static SavedRequest getRequest(HttpServletRequest request) {
        return (SavedRequest)request.getSession().getAttribute(ORIGINAL_REQUEST);
    }

    public static void saveAuthentication(HttpServletRequest request, Principal principal, Set<String> groups) {
        SavedAuthentication savedAuthentication = new SavedAuthentication(principal, groups);
        request.getSession().setAttribute(AUTHENTICATION, (Object)savedAuthentication);
    }

    public static boolean hasAuthentication(HttpServletRequest request) {
        return request.getSession().getAttribute(AUTHENTICATION) != null;
    }

    public static SavedAuthentication getAuthentication(HttpServletRequest request) {
        return (SavedAuthentication)request.getSession().getAttribute(AUTHENTICATION);
    }

    public static void clearRequestAndAuthentication(HttpServletRequest request) {
        request.getSession().removeAttribute(ORIGINAL_REQUEST);
        request.getSession().removeAttribute(AUTHENTICATION);
    }
}

