/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.excalibur.logger.util.LoggerSwitch;
import org.apache.avalon.excalibur.logger.util.LoggerUtil;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;

public abstract class AbstractLoggerManager
implements LogEnabled,
LoggerManager {
    protected final Map m_loggers = new HashMap();
    protected String m_prefix;
    private LoggerSwitch m_switch;
    private Logger m_logger;
    private String m_switchTo;
    private boolean m_enableLoggingInvoked = false;
    private boolean m_startInvoked = false;
    private final Logger m_defaultLoggerOverride;

    protected Logger getLogger() {
        return this.m_logger;
    }

    public AbstractLoggerManager(String prefix, String switchTo, Logger defaultLoggerOverride) {
        this.m_prefix = prefix;
        this.m_switchTo = switchTo;
        this.m_switch = new LoggerSwitch(null, null);
        this.m_logger = this.m_switch.get();
        this.m_defaultLoggerOverride = defaultLoggerOverride;
    }

    public void enableLogging(Logger fallbackLogger) {
        if (this.m_enableLoggingInvoked) {
            throw new IllegalStateException("enableLogging() already called");
        }
        this.m_switch.setFallback(fallbackLogger);
        this.m_enableLoggingInvoked = true;
    }

    public void start() {
        if (this.m_startInvoked) {
            throw new IllegalStateException("start() already invoked");
        }
        if (this.m_switchTo != null) {
            Logger ourOwn;
            if (this.m_logger.isDebugEnabled()) {
                String message = "LoggerManager: switching logging to this.getLoggerForCategory('" + LoggerUtil.getFullCategoryName(this.m_prefix, this.m_switchTo) + "').";
                this.m_logger.debug(message);
            }
            if ((ourOwn = this.getLoggerForCategory(this.m_switchTo)) == null) {
                throw new NullPointerException("ourOwn");
            }
            this.m_switch.setPreferred(ourOwn);
            if (this.m_logger.isDebugEnabled()) {
                String message = "LoggerManager: have switched logging to this.getLoggerForCategory('" + LoggerUtil.getFullCategoryName(this.m_prefix, this.m_switchTo) + "').";
                this.m_logger.debug(message);
            }
        } else if (this.m_logger.isDebugEnabled()) {
            String message = "LoggerManager: switchTo is null, no switch of our own logging.";
            this.m_logger.debug("LoggerManager: switchTo is null, no switch of our own logging.");
        }
        this.m_startInvoked = true;
    }

    public void stop() {
    }

    public final Logger getDefaultLogger() {
        return this.getLoggerForCategory(null);
    }

    protected abstract Logger doGetLoggerForCategory(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Logger getLoggerForCategory(String categoryName) {
        Logger newLogger;
        Logger logger;
        if (this.m_defaultLoggerOverride != null && (categoryName == null || categoryName.length() == 0)) {
            return this.m_defaultLoggerOverride;
        }
        String fullCategoryName = LoggerUtil.getFullCategoryName(this.m_prefix, categoryName);
        Map map = this.m_loggers;
        synchronized (map) {
            logger = (Logger)this.m_loggers.get(fullCategoryName);
            if (logger == null) {
                newLogger = this.doGetLoggerForCategory(fullCategoryName);
                this.m_loggers.put(fullCategoryName, newLogger);
            } else {
                newLogger = null;
            }
        }
        if (null != logger) {
            if (this.m_logger.isDebugEnabled()) {
                this.m_logger.debug("Logger for category " + fullCategoryName + " returned");
            }
            return logger;
        }
        if (this.m_logger.isDebugEnabled()) {
            this.m_logger.debug("Logger for category " + fullCategoryName + " not defined in " + "configuration. New Logger created and returned");
        }
        return newLogger;
    }
}

