/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.pool;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.factory.FactoryService;
import org.apache.turbine.services.factory.TurbineFactory;
import org.apache.turbine.services.pool.PoolService;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.pool.ArrayCtorRecyclable;
import org.apache.turbine.util.pool.BoundedBuffer;
import org.apache.turbine.util.pool.Recyclable;

public class TurbinePoolService
extends TurbineBaseService
implements PoolService {
    private boolean debugPool = false;
    private FactoryService factoryService;
    private static Log log = LogFactory.getLog((Class)TurbinePoolService.class);
    private int poolCapacity = 128;
    private HashMap poolRepository = new HashMap();

    public void init() throws InitializationException {
        Configuration conf = this.getConfiguration();
        int capacity = conf.getInt("pool.capacity", 128);
        if (capacity <= 0) {
            throw new IllegalArgumentException("Capacity must be >0");
        }
        this.poolCapacity = capacity;
        this.debugPool = conf.getBoolean("pool.debug", false);
        if (this.debugPool) {
            log.info((Object)"Activated Pool Debugging!");
        }
        this.factoryService = TurbineFactory.getService();
        if (this.factoryService == null) {
            throw new InitializationException("Factory Service is not configured but required for the Pool Service!");
        }
        this.setInit(true);
    }

    public Object getInstance(String className) throws TurbineException {
        Object instance = this.pollInstance(className, null, null);
        return instance == null ? this.factoryService.getInstance(className) : instance;
    }

    public Object getInstance(String className, ClassLoader loader) throws TurbineException {
        Object instance = this.pollInstance(className, null, null);
        return instance == null ? this.factoryService.getInstance(className, loader) : instance;
    }

    public Object getInstance(String className, Object[] params, String[] signature) throws TurbineException {
        Object instance = this.pollInstance(className, params, signature);
        return instance == null ? this.factoryService.getInstance(className, params, signature) : instance;
    }

    public Object getInstance(String className, ClassLoader loader, Object[] params, String[] signature) throws TurbineException {
        Object instance = this.pollInstance(className, params, signature);
        return instance == null ? this.factoryService.getInstance(className, loader, params, signature) : instance;
    }

    public boolean isLoaderSupported(String className) throws TurbineException {
        return this.factoryService.isLoaderSupported(className);
    }

    public Object getInstance(Class clazz) throws TurbineException {
        Object instance = this.pollInstance(clazz.getName(), null, null);
        return instance == null ? this.factoryService.getInstance(clazz.getName()) : instance;
    }

    public Object getInstance(Class clazz, Object[] params, String[] signature) throws TurbineException {
        Object instance = this.pollInstance(clazz.getName(), params, signature);
        return instance == null ? this.factoryService.getInstance(clazz.getName(), params, signature) : instance;
    }

    public boolean putInstance(Object instance) {
        if (instance != null) {
            HashMap repository = this.poolRepository;
            String className = instance.getClass().getName();
            PoolBuffer pool = (PoolBuffer)repository.get(className);
            if (pool == null) {
                pool = new PoolBuffer(this.getCapacity(className));
                repository = (HashMap)repository.clone();
                repository.put(className, pool);
                this.poolRepository = repository;
                if (instance instanceof ArrayCtorRecyclable) {
                    pool.setArrayCtorRecyclable(true);
                }
            }
            return pool.offer(instance);
        }
        return false;
    }

    public int getCapacity(String className) {
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(className);
        if (pool == null) {
            Configuration conf = this.getConfiguration();
            int capacity = conf.getInt("pool.capacity." + className, this.poolCapacity);
            capacity = capacity <= 0 ? this.poolCapacity : capacity;
            return capacity;
        }
        return pool.capacity();
    }

    public void setCapacity(String className, int capacity) {
        HashMap<String, PoolBuffer> repository = this.poolRepository;
        repository = repository != null ? (HashMap)repository.clone() : new HashMap<String, PoolBuffer>();
        capacity = capacity <= 0 ? this.poolCapacity : capacity;
        repository.put(className, new PoolBuffer(capacity));
        this.poolRepository = repository;
    }

    public int getSize(String className) {
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(className);
        return pool != null ? pool.size() : 0;
    }

    public void clearPool(String className) {
        HashMap repository = this.poolRepository;
        if (repository.get(className) != null) {
            repository = (HashMap)repository.clone();
            repository.remove(className);
            this.poolRepository = repository;
        }
    }

    public void clearPool() {
        this.poolRepository = new HashMap();
    }

    private Object pollInstance(String className, Object[] params, String[] signature) throws TurbineException {
        PoolBuffer pool = (PoolBuffer)this.poolRepository.get(className);
        return pool != null ? pool.poll(params, signature) : null;
    }

    private class PoolBuffer {
        private BoundedBuffer pool;
        private boolean arrayCtorRecyclable;
        private ArrayList recyclers;

        public PoolBuffer(int capacity) {
            this.pool = new BoundedBuffer(capacity);
        }

        public void setArrayCtorRecyclable(boolean isArrayCtor) {
            this.arrayCtorRecyclable = isArrayCtor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object poll(Object[] params, String[] signature) throws TurbineException {
            Object instance;
            block13: {
                if (TurbinePoolService.this.debugPool && this.pool.size() < this.pool.capacity() / 2) {
                    log.debug((Object)("Size: " + this.pool.size() + ", capacity: " + this.pool.capacity()));
                    return null;
                }
                instance = this.pool.poll();
                if (instance != null) {
                    if (this.arrayCtorRecyclable) {
                        ((ArrayCtorRecyclable)instance).recycle(params);
                    } else if (instance instanceof Recyclable) {
                        try {
                            if (signature != null && signature.length > 0) {
                                Method recycle = this.getRecycle(signature);
                                if (recycle == null) {
                                    PoolBuffer poolBuffer = this;
                                    synchronized (poolBuffer) {
                                        recycle = this.getRecycle(signature);
                                        if (recycle == null) {
                                            Class<?> clazz = instance.getClass();
                                            recycle = clazz.getMethod("recycle", TurbinePoolService.this.factoryService.getSignature(clazz, params, signature));
                                            ArrayList cache = this.recyclers != null ? (ArrayList)this.recyclers.clone() : new ArrayList();
                                            cache.add(new Recycler(recycle, signature));
                                            this.recyclers = cache;
                                        }
                                    }
                                }
                                recycle.invoke(instance, params);
                                break block13;
                            }
                            ((Recyclable)instance).recycle();
                        }
                        catch (Exception x) {
                            throw new TurbineException("Recycling failed for " + instance.getClass().getName(), x);
                        }
                    }
                }
            }
            return instance;
        }

        public boolean offer(Object instance) {
            if (instance instanceof Recyclable) {
                try {
                    ((Recyclable)instance).dispose();
                }
                catch (Exception x) {
                    return false;
                }
            }
            return this.pool.offer(instance);
        }

        public int capacity() {
            return this.pool.capacity();
        }

        public int size() {
            return this.pool.size();
        }

        private Method getRecycle(String[] signature) {
            ArrayList cache = this.recyclers;
            if (cache != null) {
                Iterator i = cache.iterator();
                while (i.hasNext()) {
                    Method recycle = ((Recycler)i.next()).match(signature);
                    if (recycle == null) continue;
                    return recycle;
                }
            }
            return null;
        }

        private class Recycler {
            private final Method recycle;
            private final String[] signature;

            public Recycler(Method rec, String[] sign) {
                this.recycle = rec;
                this.signature = sign != null && sign.length > 0 ? sign : null;
            }

            public Method match(String[] sign) {
                if (sign != null && sign.length > 0) {
                    if (this.signature != null && sign.length == this.signature.length) {
                        for (int i = 0; i < this.signature.length; ++i) {
                            if (this.signature[i].equals(sign[i])) continue;
                            return null;
                        }
                        return this.recycle;
                    }
                    return null;
                }
                if (this.signature == null) {
                    return this.recycle;
                }
                return null;
            }
        }
    }
}

