/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.html.Input;
import org.apache.ecs.html.Option;
import org.apache.ecs.html.Select;

public class DateSelector {
    public static final String DEFAULT_PREFIX = "DateSelector";
    public static final String DAY_SUFFIX = "_day";
    public static final String MONTH_SUFFIX = "_month";
    public static final String YEAR_SUFFIX = "_year";
    private Calendar useDate = null;
    private String selName = null;
    private static final String[] monthName = new DateFormatSymbols().getMonths();
    private String onChange = null;
    private boolean onChangeSet = false;
    private boolean showDays = true;
    private int setDay = 0;
    private boolean useYears = false;
    private int firstYear = 0;
    private int lastYear = 0;
    private int selectedYear = 0;

    public DateSelector() {
        this.selName = DEFAULT_PREFIX;
        this.useDate = Calendar.getInstance();
        this.useDate.setTime(new Date());
    }

    public DateSelector(String selName, Calendar useDate) {
        this.useDate = useDate;
        this.selName = selName;
    }

    public DateSelector(String selName) {
        this.selName = selName;
        this.useDate = Calendar.getInstance();
        this.useDate.setTime(new Date());
    }

    public DateSelector setOnChange(String onChange) {
        if (onChange != null) {
            this.onChange = onChange;
            this.onChangeSet = true;
        } else {
            this.onChange = null;
            this.onChangeSet = false;
        }
        return this;
    }

    public DateSelector setDay(int day) {
        this.setDay = day;
        this.showDays = false;
        return this;
    }

    public DateSelector setShowDay(boolean show) {
        this.showDays = false;
        return this;
    }

    public void setSelName(String selName) {
        this.selName = selName;
    }

    public String getSelName() {
        return this.selName;
    }

    public static Select getMonthSelector(String name) {
        return DateSelector.getMonthSelector(name, Calendar.getInstance());
    }

    public static Select getMonthSelector(String name, Calendar now) {
        Select monthSelect = new Select().setName(name);
        for (int curMonth = 0; curMonth <= 11; ++curMonth) {
            Option o = new Option();
            o.addElement(monthName[curMonth]);
            o.setValue(curMonth);
            if (now.get(2) == curMonth) {
                o.setSelected(true);
            }
            monthSelect.addElement((Element)o);
        }
        return monthSelect;
    }

    public static Select getDaySelector(String name) {
        return DateSelector.getDaySelector(name, Calendar.getInstance());
    }

    public static Select getDaySelector(String name, Calendar now) {
        Select daySelect = new Select().setName(name);
        for (int currentDay = 1; currentDay <= 31; ++currentDay) {
            Option o = new Option();
            o.addElement(Integer.toString(currentDay));
            o.setValue(currentDay);
            if (now.get(5) == currentDay) {
                o.setSelected(true);
            }
            daySelect.addElement((Element)o);
        }
        return daySelect;
    }

    public static Select getYearSelector(String name) {
        return DateSelector.getYearSelector(name, Calendar.getInstance());
    }

    public static Select getYearSelector(String name, Calendar now) {
        int startYear = now.get(1);
        return DateSelector.getYearSelector(name, startYear - 5, startYear + 5, startYear);
    }

    public static Select getYearSelector(String name, int firstYear, int lastYear, int selectedYear) {
        Select yearSelect = new Select().setName(name);
        for (int currentYear = firstYear; currentYear <= lastYear; ++currentYear) {
            Option o = new Option();
            o.addElement(Integer.toString(currentYear));
            o.setValue(currentYear);
            if (currentYear == selectedYear) {
                o.setSelected(true);
            }
            yearSelect.addElement((Element)o);
        }
        return yearSelect;
    }

    public boolean setYear(int firstYear, int lastYear, int selectedYear) {
        if (firstYear <= lastYear && firstYear <= selectedYear && selectedYear <= lastYear) {
            this.useYears = true;
            this.firstYear = firstYear;
            this.lastYear = lastYear;
            this.selectedYear = selectedYear;
            return true;
        }
        return false;
    }

    public String output() {
        return this.ecsOutput().toString();
    }

    public String toString() {
        return this.ecsOutput().toString();
    }

    public ElementContainer ecsOutput() {
        if (this.useDate == null) {
            this.useDate.setTime(new Date());
        }
        Select monthSelect = DateSelector.getMonthSelector(this.selName + MONTH_SUFFIX, this.useDate);
        Input daySelect = null;
        if (!this.showDays) {
            daySelect = new Input("hidden", this.selName + DAY_SUFFIX, this.setDay);
        } else {
            Select tmp = DateSelector.getDaySelector(this.selName + DAY_SUFFIX, this.useDate);
            if (this.onChangeSet) {
                tmp.setOnChange(this.onChange);
            }
            daySelect = tmp;
        }
        Select yearSelect = null;
        yearSelect = this.useYears ? DateSelector.getYearSelector(this.selName + YEAR_SUFFIX, this.firstYear, this.lastYear, this.selectedYear) : DateSelector.getYearSelector(this.selName + YEAR_SUFFIX, this.useDate);
        if (this.onChangeSet) {
            monthSelect.setOnChange(this.onChange);
            yearSelect.setOnChange(this.onChange);
        }
        ElementContainer ec = new ElementContainer();
        ec.addElement((Element)monthSelect);
        ec.addElement((Element)daySelect);
        ec.addElement((Element)yearSelect);
        return ec;
    }
}

