/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.uri;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.ServerData;
import org.apache.turbine.util.parser.ParameterParser;
import org.apache.turbine.util.parser.ParserUtils;
import org.apache.turbine.util.uri.BaseURI;
import org.apache.turbine.util.uri.URIParam;

public class TurbineURI
extends BaseURI {
    private static Log log = LogFactory.getLog((Class)TurbineURI.class);
    private List[] dataVectors = null;

    public TurbineURI() {
        this.init();
    }

    public TurbineURI(RunData runData) {
        super(runData);
        this.init();
    }

    public TurbineURI(RunData runData, boolean redirect) {
        super(runData, redirect);
        this.init();
    }

    public TurbineURI(RunData runData, String screen) {
        this(runData);
        this.setScreen(screen);
    }

    public TurbineURI(RunData runData, String screen, boolean redirect) {
        this(runData, redirect);
        this.setScreen(screen);
    }

    public TurbineURI(RunData runData, String screen, String action) {
        this(runData, screen);
        this.setAction(action);
    }

    public TurbineURI(RunData runData, String screen, String action, boolean redirect) {
        this(runData, screen, redirect);
        this.setAction(action);
    }

    public TurbineURI(ServerData serverData) {
        super(serverData);
        this.init();
    }

    public TurbineURI(ServerData serverData, boolean redirect) {
        super(serverData, redirect);
        this.init();
    }

    public TurbineURI(ServerData serverData, String screen) {
        this(serverData);
        this.setScreen(screen);
    }

    public TurbineURI(ServerData serverData, String screen, boolean redirect) {
        this(serverData, redirect);
        this.setScreen(screen);
    }

    public TurbineURI(ServerData serverData, String screen, String action) {
        this(serverData, screen);
        this.setAction(action);
    }

    public TurbineURI(ServerData serverData, String screen, String action, boolean redirect) {
        this(serverData, screen, redirect);
        this.setAction(action);
    }

    public TurbineURI(String screen, String action) {
        this();
        this.setScreen(screen);
        this.setAction(action);
    }

    private void init() {
        this.dataVectors = new List[2];
        this.dataVectors[0] = new ArrayList();
        this.dataVectors[1] = new ArrayList();
    }

    public void setAction(String action) {
        if (StringUtils.isNotEmpty((String)action)) {
            this.add(0, "action", action);
        } else {
            this.clearAction();
        }
    }

    public void setEvent(String event) {
        this.add(0, "eventSubmit_" + event, event);
    }

    public void setActionEvent(String action, String event) {
        this.setAction(action);
        if (StringUtils.isNotEmpty((String)event)) {
            this.setEvent(event);
        }
    }

    public void clearAction() {
        this.removePathInfo("action");
    }

    public void setScreen(String screen) {
        if (StringUtils.isNotEmpty((String)screen)) {
            this.add(0, "screen", screen);
        } else {
            this.clearScreen();
        }
    }

    public void clearScreen() {
        this.removePathInfo("screen");
    }

    public void addPathInfo(ParameterParser pp) {
        this.add(0, pp);
    }

    public void addPathInfo(List list) {
        this.add(0, list);
    }

    public void addPathInfo(String name, Object value) {
        this.add(0, name, null == value ? null : value.toString());
    }

    public void addPathInfo(String name, String value) {
        this.add(0, name, value);
    }

    public void addPathInfo(String name, double value) {
        this.add(0, name, Double.toString(value));
    }

    public void addPathInfo(String name, int value) {
        this.add(0, name, Integer.toString(value));
    }

    public void addPathInfo(String name, long value) {
        this.add(0, name, Long.toString(value));
    }

    public void addQueryData(String name, Object value) {
        this.add(1, name, null == value ? null : value.toString());
    }

    public void addQueryData(String name, String value) {
        this.add(1, name, value);
    }

    public void addQueryData(String name, double value) {
        this.add(1, name, Double.toString(value));
    }

    public void addQueryData(String name, int value) {
        this.add(1, name, Integer.toString(value));
    }

    public void addQueryData(String name, long value) {
        this.add(1, name, Long.toString(value));
    }

    public void addQueryData(ParameterParser pp) {
        this.add(1, pp);
    }

    public void addQueryData(List list) {
        this.add(1, list);
    }

    public boolean hasPathInfo() {
        return !this.dataVectors[0].isEmpty();
    }

    public void removePathInfo() {
        this.dataVectors[0].clear();
    }

    public void removePathInfo(String name) {
        this.remove(0, name);
    }

    public boolean hasQueryData() {
        return !this.dataVectors[1].isEmpty();
    }

    public void removeQueryData() {
        this.dataVectors[1].clear();
    }

    public void removeQueryData(String name) {
        this.remove(1, name);
    }

    public void clearResponse() {
        this.setResponse(null);
    }

    public String getAbsoluteLink() {
        StringBuffer output = new StringBuffer();
        this.getSchemeAndPort(output);
        this.buildRelativeLink(output);
        return this.encodeResponse(output.toString());
    }

    public String getRelativeLink() {
        StringBuffer output = new StringBuffer();
        this.buildRelativeLink(output);
        return this.encodeResponse(output.toString());
    }

    private void buildRelativeLink(StringBuffer output) {
        this.getContextAndScript(output);
        if (this.hasPathInfo()) {
            output.append('/');
            this.getPathInfoAsString(output);
        }
        if (this.hasReference()) {
            output.append('#');
            output.append(this.getReference());
        }
        if (this.hasQueryData()) {
            output.append('?');
            this.getQueryDataAsString(output);
        }
    }

    public List getPathInfo() {
        return this.dataVectors[0];
    }

    public void setPathInfo(List pathInfo) {
        this.dataVectors[0] = pathInfo;
    }

    public List getQueryData() {
        return this.dataVectors[1];
    }

    public void setQueryData(List queryData) {
        this.dataVectors[1] = queryData;
    }

    public String toString() {
        return this.getAbsoluteLink();
    }

    private void getPathInfoAsString(StringBuffer output) {
        this.doEncode(output, this.dataVectors[0], '/', '/');
    }

    private void getQueryDataAsString(StringBuffer output) {
        this.doEncode(output, this.dataVectors[1], '&', '=');
    }

    private void doEncode(StringBuffer output, Collection list, char fieldDelim, char valueDelim) {
        if (!list.isEmpty()) {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                URIParam uriParam = (URIParam)it.next();
                String key = URLEncoder.encode(uriParam.getKey());
                String val = null == uriParam.getValue() ? null : String.valueOf(uriParam.getValue());
                output.append(key);
                output.append(valueDelim);
                if (StringUtils.isEmpty((String)val)) {
                    if (val == null) {
                        if (log.isWarnEnabled()) {
                            log.warn((Object)("Found a null value for " + key));
                        }
                        val = "null";
                    }
                    output.append(val);
                } else {
                    output.append(URLEncoder.encode(val));
                }
                if (!it.hasNext()) continue;
                output.append(fieldDelim);
            }
        }
    }

    protected void add(int type, String name, String value) {
        URIParam uriParam = new URIParam(ParserUtils.convertAndTrim(name), value);
        this.dataVectors[type].add(uriParam);
    }

    protected void add(int type, ParameterParser pp) {
        Iterator it = pp.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.equalsIgnoreCase("action") || key.equalsIgnoreCase("screen")) continue;
            String[] values = pp.getStrings(key);
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    this.add(type, key, values[i]);
                }
                continue;
            }
            this.add(type, key, "");
        }
    }

    protected void add(int type, List list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            URIParam uriParam = (URIParam)it.next();
            this.dataVectors[type].add(uriParam);
        }
    }

    protected void remove(int type, String name) {
        List c = this.dataVectors[type];
        String key = ParserUtils.convertAndTrim(name);
        Iterator it = c.iterator();
        while (it.hasNext()) {
            URIParam uriParam = (URIParam)it.next();
            if (!key.equals(uriParam.getKey())) continue;
            it.remove();
        }
    }
}

