/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DBApiType;
import com.ziclix.python.sql.zxJDBCFunc;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyClass;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;

public class zxJDBC
extends PyObject
implements ClassDictInit {
    public static PyObject Error = Py.None;
    public static PyObject Warning = Py.None;
    public static PyObject InterfaceError = Py.None;
    public static PyObject DatabaseError = Py.None;
    public static PyObject InternalError = Py.None;
    public static PyObject OperationalError = Py.None;
    public static PyObject ProgrammingError = Py.None;
    public static PyObject IntegrityError = Py.None;
    public static PyObject DataError = Py.None;
    public static PyObject NotSupportedError = Py.None;
    private static ResourceBundle resourceBundle = null;
    public static PyClass __class__;
    private static /* synthetic */ Class class$Lcom$ziclix$python$sql$zxJDBC;

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("apilevel", (PyObject)new PyString("2.0"));
        dict.__setitem__("threadsafety", (PyObject)new PyInteger(1));
        dict.__setitem__("paramstyle", (PyObject)new PyString("qmark"));
        dict.__setitem__("__version__", Py.newString("$Revision: 1.4 $").__getslice__(Py.newInteger(11), Py.newInteger(-2), null));
        dict.__setitem__("Date", (PyObject)new zxJDBCFunc("Date", 1, 3, 3, false, "construct a Date from year, month, day"));
        dict.__setitem__("Time", (PyObject)new zxJDBCFunc("Time", 2, 3, 3, false, "construct a Date from hour, minute, second"));
        dict.__setitem__("Timestamp", (PyObject)new zxJDBCFunc("Timestamp", 3, 6, 6, false, "construct a Timestamp from year, month, day, hour, minute, second"));
        dict.__setitem__("DateFromTicks", (PyObject)new zxJDBCFunc("DateFromTicks", 4, 1, 1, false, "construct a Date from seconds since the epoch"));
        dict.__setitem__("TimeFromTicks", (PyObject)new zxJDBCFunc("TimeFromTicks", 5, 1, 1, false, "construct a Time from seconds since the epoch"));
        dict.__setitem__("TimestampFromTicks", (PyObject)new zxJDBCFunc("TimestampFromTicks", 6, 1, 1, false, "construct a Timestamp from seconds since the epoch"));
        zxJDBC._addSqlTypes(dict);
        zxJDBC._addConnectors(dict);
        zxJDBC._buildExceptions(dict);
        dict.__setitem__("initModule", null);
        dict.__setitem__("toString", null);
        dict.__setitem__("getPyClass", null);
        dict.__setitem__("classDictInit", null);
        dict.__setitem__("_addSqlTypes", null);
        dict.__setitem__("_addConnectors", null);
        dict.__setitem__("_buildExceptions", null);
        dict.__setitem__("_empty__init__", null);
        dict.__setitem__("buildClass", null);
        dict.__setitem__("createExceptionMessage", null);
        dict.__setitem__("newError", null);
        dict.__setitem__("resourceBundle", null);
        dict.__setitem__("getString", null);
        dict.__setitem__("makeException", null);
    }

    protected PyClass getPyClass() {
        return __class__;
    }

    protected static void _addSqlTypes(PyObject dict) throws PyException {
        PyDictionary sqltype = new PyDictionary();
        dict.__setitem__("sqltype", (PyObject)sqltype);
        try {
            Class<?> c = Class.forName("java.sql.Types");
            Field[] fields = c.getFields();
            int i = 0;
            while (i < fields.length) {
                Field f = fields[i];
                PyString name = Py.newString(f.getName());
                DBApiType value = new DBApiType(f.getInt(c));
                dict.__setitem__(name, (PyObject)value);
                sqltype.__setitem__(value, (PyObject)name);
                ++i;
            }
        }
        catch (Throwable t) {
            throw zxJDBC.newError(t);
        }
    }

    protected static void _addConnectors(PyObject dict) throws PyException {
        PyObject connector = Py.None;
        Properties props = new Properties();
        ((Hashtable)props).put("connect", "com.ziclix.python.sql.connect.Connect");
        ((Hashtable)props).put("lookup", "com.ziclix.python.sql.connect.Lookup");
        ((Hashtable)props).put("connectx", "com.ziclix.python.sql.connect.Connectx");
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = ((String)names.nextElement()).trim();
            String className = props.getProperty(name).trim();
            try {
                connector = (PyObject)Class.forName(className).newInstance();
                dict.__setitem__(name, connector);
                Py.writeComment("zxJDBC", "loaded connector [" + className + "] as [" + name + "]");
            }
            catch (Throwable t) {
                Py.writeComment("zxJDBC", "failed to load connector [" + name + "] using class [" + className + "]");
            }
        }
    }

    protected static void _buildExceptions(PyObject dict) {
        Error = zxJDBC.buildClass("Error", Py.StandardError, "_empty__init__");
        Warning = zxJDBC.buildClass("Warning", Py.StandardError, "_empty__init__");
        InterfaceError = zxJDBC.buildClass("InterfaceError", Error, "_empty__init__");
        DatabaseError = zxJDBC.buildClass("DatabaseError", Error, "_empty__init__");
        InternalError = zxJDBC.buildClass("InternalError", DatabaseError, "_empty__init__");
        OperationalError = zxJDBC.buildClass("OperationalError", DatabaseError, "_empty__init__");
        ProgrammingError = zxJDBC.buildClass("ProgrammingError", DatabaseError, "_empty__init__");
        IntegrityError = zxJDBC.buildClass("IntegrityError", DatabaseError, "_empty__init__");
        DataError = zxJDBC.buildClass("DataError", DatabaseError, "_empty__init__");
        NotSupportedError = zxJDBC.buildClass("NotSupportedError", DatabaseError, "_empty__init__");
    }

    public static PyObject _empty__init__(PyObject[] arg, String[] kws) {
        PyStringMap dict = new PyStringMap();
        ((PyObject)dict).__setitem__("__module__", (PyObject)new PyString("zxJDBC"));
        return dict;
    }

    /*
     * Unable to fully structure code
     */
    public static String getString(String key) {
        block6: {
            block7: {
                i = 0;
                lines = null;
                resource = null;
                block2: while (true) {
                    try {
                        resource = zxJDBC.resourceBundle.getString(key + "." + i++);
                        if (lines == null) {
                            lines = new ArrayList<String>();
                        }
                        lines.add(resource);
                    }
                    catch (MissingResourceException e) {
                        if (lines == null || lines.size() == 0) {
                            resource = zxJDBC.resourceBundle.getString(key);
                            break block6;
                        }
                        sep = System.getProperty("line.separator");
                        sb = new StringBuffer();
                        i = 0;
lbl19:
                        // 2 sources

                        while (i < lines.size() - 1) {
                            break block2;
                        }
                        break block7;
                    }
                }
                sb.append(lines.get(i)).append(sep);
                ++i;
                ** GOTO lbl19
            }
            sb.append(lines.get(lines.size() - 1));
            resource = sb.toString();
        }
        return resource;
    }

    public static String getString(String key, Object[] values) {
        String format = zxJDBC.getString(key);
        return MessageFormat.format(format, values);
    }

    public static PyException makeException(PyObject type, String msg) {
        return Py.makeException(type, Py.newString(msg == null ? "" : msg));
    }

    public static PyException newError(String msg) {
        return zxJDBC.makeException(Error, msg);
    }

    public static PyException newError(Throwable e) {
        if (e instanceof PyException) {
            throw (PyException)e;
        }
        try {
            StringBuffer buffer = new StringBuffer();
            zxJDBC.createExceptionMessage((SQLException)e, buffer, 0);
            return zxJDBC.newError(buffer.toString());
        }
        catch (ClassCastException classCastException) {
            return zxJDBC.newError(e.getMessage());
        }
    }

    protected static void createExceptionMessage(SQLException exception, StringBuffer buffer, int level) {
        buffer.append(exception.getMessage());
        buffer.append(" [SQLCode: " + exception.getErrorCode() + "]");
        if (exception.getSQLState() != null) {
            buffer.append(", [SQLState: " + exception.getSQLState() + "]");
        }
        if (exception.getNextException() != null) {
            buffer.append(System.getProperty("line.separator"));
            zxJDBC.createExceptionMessage(exception.getNextException(), buffer, level + 1);
        }
    }

    protected static PyObject Date(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        return zxJDBC.DateFromTicks(c.getTime().getTime() / 1000L);
    }

    protected static PyObject Time(int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.set(10, hour);
        c.set(12, minute);
        c.set(13, second);
        return zxJDBC.TimeFromTicks(c.getTime().getTime() / 1000L);
    }

    protected static PyObject Timestamp(int year, int month, int day, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        c.set(10, hour);
        c.set(12, minute);
        c.set(13, second);
        c.set(14, 0);
        return zxJDBC.TimestampFromTicks(c.getTime().getTime() / 1000L);
    }

    protected static PyObject DateFromTicks(long ticks) {
        Calendar c = Calendar.getInstance();
        c.setTime(new java.util.Date(ticks * 1000L));
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return Py.java2py(new Date(c.getTime().getTime()));
    }

    protected static PyObject TimeFromTicks(long ticks) {
        return Py.java2py(new Time(ticks * 1000L));
    }

    protected static PyObject TimestampFromTicks(long ticks) {
        return Py.java2py(new Timestamp(ticks * 1000L));
    }

    protected static PyObject buildClass(String classname, PyObject superclass, String classCodeName) {
        PyObject[] pyObjectArray;
        if (superclass == null) {
            pyObjectArray = Py.EmptyObjects;
        } else {
            PyObject[] pyObjectArray2 = new PyObject[1];
            pyObjectArray = pyObjectArray2;
            pyObjectArray2[0] = superclass;
        }
        PyObject[] parents = pyObjectArray;
        PyString doc = Py.newString(zxJDBC.getString(classname));
        PyObject cls = Py.makeClass(classname, parents, Py.newJavaCode(class$Lcom$ziclix$python$sql$zxJDBC != null ? class$Lcom$ziclix$python$sql$zxJDBC : (class$Lcom$ziclix$python$sql$zxJDBC = zxJDBC.class$("com.ziclix.python.sql.zxJDBC")), classCodeName), doc);
        return cls;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            resourceBundle = ResourceBundle.getBundle("com.ziclix.python.sql.resource.zxJDBCMessages");
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("missing zxjdbc resource bundle");
        }
    }
}

