/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.component.AbstractDualLogEnabled;
import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.LogkitLoggerManager;
import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.component.ThreadSafeComponentHandler;
import org.apache.avalon.excalibur.logger.LogKitManageable;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.excalibur.logger.LoggerManageable;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.instrument.Instrument;
import org.apache.excalibur.instrument.InstrumentManageable;
import org.apache.excalibur.instrument.InstrumentManager;
import org.apache.excalibur.instrument.Instrumentable;

public class ExcaliburComponentSelector
extends AbstractDualLogEnabled
implements Contextualizable,
ComponentSelector,
Composable,
Configurable,
Initializable,
ThreadSafe,
Disposable,
RoleManageable,
LogKitManageable,
LoggerManageable,
InstrumentManageable,
Instrumentable {
    private final ClassLoader m_loader;
    private static final String DEFAULT_NAME = "UnnamedSelector";
    private String m_rolename;
    protected Context m_context;
    private ComponentManager m_componentManager;
    private Configuration m_configuration;
    private Map m_componentHandlers = Collections.synchronizedMap(new HashMap());
    private Map m_componentMapping = Collections.synchronizedMap(new HashMap());
    private boolean m_disposed;
    private boolean m_initialized;
    private RoleManager m_roles;
    private LogkitLoggerManager m_logkit;
    private InstrumentManager m_instrumentManager;
    private String m_instrumentableName;

    public ExcaliburComponentSelector() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ExcaliburComponentSelector(ClassLoader loader) {
        this.m_loader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
    }

    public void contextualize(Context context) {
        if (null == this.m_context) {
            this.m_context = context;
        }
    }

    public Component select(Object hint) throws ComponentException {
        if (!this.m_initialized && this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Looking up component on an uninitialized ComponentLocator with hint [" + hint + "]");
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot select a Component from a disposed ComponentSelector");
        }
        if (null == hint) {
            String message = this.getName() + ": ComponentSelector Attempted to retrieve component with null hint.";
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error(message);
            }
            throw new ComponentException(message);
        }
        ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(hint));
        if (null == handler) {
            String message = this.getName() + ": ComponentSelector could not find the component for hint [" + hint + "]";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(message);
            }
            throw new ComponentException(hint.toString(), message);
        }
        Component component = null;
        try {
            component = handler.get();
        }
        catch (ComponentException ce) {
            throw ce;
        }
        catch (Exception e) {
            String message = this.getName() + ": ComponentSelector could not access the Component for hint [" + hint + "]";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(message, (Throwable)e);
            }
            throw new ComponentException(hint.toString(), message, (Throwable)e);
        }
        if (null == component) {
            String message = this.getName() + ": ComponentSelector could not find the component for hint [" + hint + "]";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(message);
            }
            throw new ComponentException(hint.toString(), message);
        }
        this.m_componentMapping.put(component, handler);
        return component;
    }

    public boolean hasComponent(Object hint) {
        if (!this.m_initialized) {
            return false;
        }
        if (this.m_disposed) {
            return false;
        }
        boolean exists = false;
        try {
            ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(hint));
            exists = handler != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return exists;
    }

    public void release(Component component) {
        block5: {
            if (null == component) {
                return;
            }
            ComponentHandler handler = (ComponentHandler)((Object)this.m_componentMapping.get(component));
            if (null == handler) {
                this.getLogger().warn("Attempted to release a " + component.getClass().getName() + " but its handler could not be located.");
                return;
            }
            if (!(handler instanceof ThreadSafeComponentHandler)) {
                this.m_componentMapping.remove(component);
            }
            try {
                handler.put(component);
            }
            catch (Exception e) {
                if (!this.getLogger().isDebugEnabled()) break block5;
                this.getLogger().debug("Error trying to release component", (Throwable)e);
            }
        }
    }

    protected boolean canRelease(Component component) {
        return this.m_componentMapping.containsKey(component);
    }

    public void compose(ComponentManager componentManager) throws ComponentException {
        this.m_componentManager = componentManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        String name;
        this.m_configuration = configuration;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("ComponentSelector setting up with root element: " + this.m_configuration.getName());
        }
        this.m_rolename = (name = configuration.getName()).equals("component") ? this.m_configuration.getAttribute("role") : this.m_roles.getRoleForName(name);
        Configuration[] instances = this.m_configuration.getChildren();
        for (int i = 0; i < instances.length; ++i) {
            String hint = instances[i].getAttribute("name").trim();
            String className = "component-instance".equals(instances[i].getName()) ? instances[i].getAttribute("class").trim() : this.m_roles.getDefaultClassNameForHint(this.m_rolename, instances[i].getName());
            try {
                Class<?> clazz = this.m_loader.loadClass(className);
                this.addComponent(hint, clazz, instances[i]);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                String message = "The component instance for hint [" + hint + "] has an invalid class name (" + className + ").";
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error(message, (Throwable)cnfe);
                }
                throw new ConfigurationException(message, (Throwable)cnfe);
            }
            catch (ComponentException ce) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("The component instance for hint [" + hint + "] is not valid.", (Throwable)ce);
                }
                throw new ConfigurationException("Could not set up component", (Throwable)ce);
            }
            catch (Exception e) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Unexpected exception for hint [" + hint + "]", (Throwable)e);
                }
                throw new ConfigurationException("Unexpected exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        ExcaliburComponentSelector excaliburComponentSelector = this;
        synchronized (excaliburComponentSelector) {
            this.m_initialized = true;
            ArrayList keys = new ArrayList(this.m_componentHandlers.keySet());
            for (int i = 0; i < keys.size(); ++i) {
                Object key = keys.get(i);
                ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(key));
                try {
                    handler.initialize();
                    if (this.m_instrumentManager == null || !(handler instanceof Instrumentable)) continue;
                    String handleInstName = handler.getInstrumentableName();
                    this.m_instrumentManager.registerInstrumentable((Instrumentable)handler, handleInstName);
                    continue;
                }
                catch (Exception e) {
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("Caught an exception trying to initialize of the component handler.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ExcaliburComponentSelector excaliburComponentSelector = this;
        synchronized (excaliburComponentSelector) {
            Iterator<Object> keys = this.m_componentHandlers.keySet().iterator();
            ArrayList keyList = new ArrayList();
            while (keys.hasNext()) {
                Object key = keys.next();
                ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(key));
                handler.dispose();
                keyList.add(key);
            }
            keys = keyList.iterator();
            while (keys.hasNext()) {
                this.m_componentHandlers.remove(keys.next());
            }
            keyList.clear();
            this.m_disposed = true;
        }
    }

    public void setRoleManager(RoleManager roles) {
        if (null == this.m_roles) {
            this.m_roles = roles;
        }
    }

    public void setLogKitManager(LogKitManager logkit) {
        if (null == this.m_logkit) {
            this.m_logkit = new LogkitLoggerManager(null, logkit);
        }
    }

    public void setInstrumentManager(InstrumentManager instrumentManager) {
        this.m_instrumentManager = instrumentManager;
    }

    public void setInstrumentableName(String name) {
        this.m_instrumentableName = name;
    }

    public String getInstrumentableName() {
        return this.m_instrumentableName;
    }

    public Instrument[] getInstruments() {
        return Instrumentable.EMPTY_INSTRUMENT_ARRAY;
    }

    public Instrumentable[] getChildInstrumentables() {
        return EMPTY_INSTRUMENTABLE_ARRAY;
    }

    public void setLoggerManager(LoggerManager logkit) {
        if (null == this.m_logkit) {
            this.m_logkit = new LogkitLoggerManager(logkit, null);
        }
    }

    protected ComponentHandler getComponentHandler(String role, Class componentClass, Configuration configuration, ComponentManager componentManager, Context context, RoleManager roleManager, LogkitLoggerManager logkitManager) throws Exception {
        String instrumentableName = this.m_instrumentableName + "." + configuration.getAttribute("instrumentable", configuration.getAttribute("name", configuration.getName()));
        return ComponentHandler.getComponentHandler(role, componentClass, configuration, componentManager, context, roleManager, logkitManager, this.m_instrumentManager, instrumentableName);
    }

    protected Map getComponentHandlers() {
        return this.m_componentHandlers;
    }

    public void addComponent(Object hint, Class component, Configuration configuration) throws ComponentException {
        if (this.m_initialized) {
            throw new ComponentException(hint.toString(), "Cannot add components to an initialized ComponentSelector", null);
        }
        try {
            ComponentHandler handler = this.getComponentHandler(this.m_rolename, component, configuration, this.m_componentManager, this.m_context, this.m_roles, this.m_logkit);
            handler.setLogger(this.getLogkitLogger());
            handler.enableLogging(this.getLogger());
            handler.initialize();
            this.m_componentHandlers.put(hint, handler);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Adding " + component.getName() + " for hint [" + hint.toString() + "]");
            }
        }
        catch (Exception e) {
            String message = "Could not set up Component for hint [ " + hint + "]";
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error(message, (Throwable)e);
            }
            throw new ComponentException(hint.toString(), message, (Throwable)e);
        }
    }

    public void addComponentInstance(Object hint, Component instance) {
        block4: {
            if (this.m_initialized) {
                throw new IllegalStateException("Cannot add components to an initialized ComponentSelector");
            }
            try {
                ComponentHandler handler = ComponentHandler.getComponentHandler(instance);
                handler.setLogger(this.getLogkitLogger());
                handler.enableLogging(this.getLogger());
                handler.initialize();
                this.m_componentHandlers.put(hint, handler);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Adding " + instance.getClass().getName() + " for hint [" + hint.toString() + "]");
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isErrorEnabled()) break block4;
                this.getLogger().error("Could not set up Component for hint [" + hint + "]", (Throwable)e);
            }
        }
    }

    private String getName() {
        if (null != this.m_configuration && !this.m_configuration.getName().equals("")) {
            return this.m_configuration.getName();
        }
        return DEFAULT_NAME;
    }
}

