/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.impl.AllFSs;
import org.apache.uima.cas.impl.BinaryCasSerDes;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.internal.util.Int2ObjHashMap;
import org.apache.uima.internal.util.Obj2IntIdentityHashMap;
import org.apache.uima.jcas.cas.TOP;

public class CommonSerDesSequential {
    public static final boolean TRACE_SETUP = false;
    final Obj2IntIdentityHashMap<TOP> fs2addr = new Obj2IntIdentityHashMap<TOP>(TOP.class, TOP._singleton);
    final Int2ObjHashMap<TOP, TOP> addr2fs = new Int2ObjHashMap(TOP.class);
    private final List<TOP> sortedFSs = new ArrayList<TOP>();
    private final List<TOP> pending = new ArrayList<TOP>();
    private final CASImpl baseCas;
    private int heapEnd;

    public CommonSerDesSequential(CASImpl cas) {
        this.baseCas = cas.getBaseCAS();
    }

    public boolean isEmpty() {
        return this.sortedFSs.isEmpty() && this.pending.isEmpty();
    }

    void addFS(TOP fs, int addr) {
        this.addFS1(fs, addr);
        this.sortedFSs.add(fs);
    }

    void addFS1(TOP fs, int addr) {
        this.fs2addr.put(fs, addr);
        this.addr2fs.put(addr, fs);
    }

    void addFSunordered(TOP fs, int addr) {
        this.addFS1(fs, addr);
        this.pending.add(fs);
    }

    void clear() {
        this.sortedFSs.clear();
        this.fs2addr.clear();
        this.addr2fs.clear();
        this.pending.clear();
        this.heapEnd = 0;
    }

    List<TOP> setup(MarkerImpl mark, int fromAddr) {
        if (mark == null) {
            this.clear();
        }
        int nextAddr = fromAddr;
        ArrayList<TOP> all = new AllFSs(this.baseCas).getAllFSsAllViews_sofas_reachable().getAllFSsSorted();
        List<TOP> filtered = CASImpl.filterAboveMark(all, mark);
        for (TOP fs : filtered) {
            this.addFS1(fs, nextAddr);
            nextAddr += BinaryCasSerDes.getFsSpaceReq(fs, fs._getTypeImpl());
        }
        this.sortedFSs.addAll(filtered);
        this.heapEnd = nextAddr;
        return all;
    }

    List<TOP> getSortedFSs() {
        if (this.pending.size() != 0) {
            this.merge();
        }
        return this.sortedFSs;
    }

    int getHeapEnd() {
        return this.heapEnd;
    }

    void setHeapEnd(int heapEnd) {
        this.heapEnd = heapEnd;
    }

    private void merge() {
        this.pending.sort(FeatureStructureImplC::compare);
        this.sortedFSs.addAll(this.pending);
        this.pending.clear();
        this.sortedFSs.sort(FeatureStructureImplC::compare);
    }
}

