/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

public class SymbolTable {
    private static final int DEFAULT_START = 0;
    private int start;
    private final HashMap<String, Integer> symbol2intMap = new HashMap();
    private final ArrayList<String> int2symbolMap = new ArrayList();

    public SymbolTable(int start) {
        this.start = start;
    }

    public SymbolTable() {
        this(0);
    }

    public SymbolTable(String[] names) {
        this(0);
        for (int i = 0; i < names.length; ++i) {
            this.set(names[i]);
        }
    }

    public boolean contains(String symbol) {
        return this.getStart() <= this.get(symbol);
    }

    public int getStart() {
        return this.start;
    }

    public SymbolTable copy() {
        SymbolTable copy = new SymbolTable(this.start);
        int max = this.int2symbolMap.size();
        for (int i = 0; i < max; ++i) {
            copy.set(this.int2symbolMap.get(i));
        }
        return copy;
    }

    private final int rel2abs(int i) {
        return i - this.start;
    }

    private final int abs2rel(int i) {
        return i + this.start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set(String symbol) {
        int rel;
        if (this.symbol2intMap.containsKey(symbol)) {
            return this.symbol2intMap.get(symbol);
        }
        SymbolTable symbolTable = this;
        synchronized (symbolTable) {
            int abs = this.symbol2intMap.size();
            rel = this.abs2rel(abs);
            this.symbol2intMap.put(symbol, rel);
            this.int2symbolMap.add(symbol);
        }
        return rel;
    }

    public int get(String symbol) {
        Integer i = this.symbol2intMap.get(symbol);
        return i == null ? this.start - 1 : i;
    }

    public String getSymbol(int i) {
        int abs = this.rel2abs(i);
        if (abs < 0 || abs >= this.int2symbolMap.size()) {
            return null;
        }
        return this.int2symbolMap.get(abs);
    }

    public int size() {
        return this.int2symbolMap.size();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{ ");
        int max = this.getStart() + this.size();
        for (int i = this.getStart(); i < max; ++i) {
            buf.append(i + ":" + this.getSymbol(i));
            if (i + 1 >= max) continue;
            buf.append(", ");
        }
        buf.append(" }");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SymbolTable readFromFile(String filename) throws IOException {
        File stf = new File(filename);
        FileReader fr = null;
        try (BufferedReader in = null;){
            String word;
            fr = new FileReader(stf);
            in = new BufferedReader(fr);
            SymbolTable st = new SymbolTable();
            while ((word = in.readLine()) != null) {
                if (word.equals("")) continue;
                st.set(word);
            }
            SymbolTable symbolTable = st;
            return symbolTable;
        }
    }
}

