/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.impl.BuiltinTypeKinds;
import org.apache.uima.internal.util.MsgLocalizationClassLoader;
import org.apache.uima.internal.util.function.Runnable_withException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public class Misc {
    public static final boolean isJava9ea = System.getProperty("java.version").startsWith("9-ea");
    public static final String blanks = new String(new char[1000]).replace('\u0000', ' ');
    public static final String dots = "...";
    public static final int[] INT0 = new int[]{0};
    private static final Pattern whitespace = Pattern.compile("\\s");
    public static final MethodHandles.Lookup UIMAlookup = MethodHandles.lookup();
    private static FilenameFilter jarFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            name = name.toLowerCase();
            return name.endsWith(".jar");
        }
    };
    public static final int numberOfCores = Runtime.getRuntime().availableProcessors();
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private static final int seed = 969059159;

    public static String replaceWhiteSpace(String s, String replacement) {
        return whitespace.matcher(s).replaceAll(replacement);
    }

    public static String null2str(String s) {
        return s == null ? "" : s;
    }

    public static byte[] hex_string_to_bytearray(String s) {
        int len2 = s.length();
        int len = len2 >> 1;
        byte[] out = new byte[len];
        int out_i = 0;
        int str_i = 0;
        while (out_i < len) {
            out[out_i] = (byte)((Character.digit(s.charAt(str_i), 16) << 4) + Character.digit(s.charAt(str_i + 1), 16));
            ++out_i;
            str_i += 2;
        }
        return out;
    }

    public static String dumpByteArray(byte[] b, int limit) {
        if (b == null) {
            return "null";
        }
        if (b.length == 0) {
            return "0-length";
        }
        StringBuilder sb = new StringBuilder(b.length * 3);
        for (int i = 0; i < b.length; ++i) {
            if (i % 100 == 0) {
                sb.append('\n');
            }
            sb.append(String.format("%02X", b[i]));
            if (i % 2 == 1) {
                sb.append(' ');
            }
            if (i <= limit) continue;
            sb.append("\n Hit the limit: ").append(limit);
            break;
        }
        return sb.toString();
    }

    public static StringBuilder getCallers(int s, int n) {
        return Misc.dumpCallers(Thread.currentThread().getStackTrace(), s, n);
    }

    public static StringBuilder dumpCallers(StackTraceElement[] e, int s, int n) {
        StringBuilder sb = new StringBuilder();
        for (int i = s + 2; i < s + n + 3 && i < e.length; ++i) {
            if (i != s + 2) {
                sb.append("\n  called_by: ");
            }
            sb.append(Misc.formatcaller(e[i]));
        }
        return sb;
    }

    public static String getCaller() {
        StackTraceElement[] e = Thread.currentThread().getStackTrace();
        return Misc.formatcaller(e[5]) + " => " + Misc.formatcaller(e[4]);
    }

    private static String formatcaller(StackTraceElement e) {
        String n = e.getClassName();
        return n.substring(1 + n.lastIndexOf(46)) + "." + e.getMethodName() + "[" + e.getLineNumber() + "]";
    }

    public static String formatcaller(String className, String methodName, int lineNumber) {
        return className.substring(1 + className.lastIndexOf(46)) + "." + methodName + "[" + lineNumber + "]";
    }

    public static ClassLoader[] getCallingClass_classLoaders() {
        Class<?>[] cs = new MsgLocalizationClassLoader.CallStack().getCallStack();
        ArrayList<ClassLoader> cls = new ArrayList<ClassLoader>();
        for (int i = 3; i < cs.length; ++i) {
            Class<?> callingClass = cs[i];
            ClassLoader cl = callingClass.getClassLoader();
            if (null == cl) {
                cl = ClassLoader.getSystemClassLoader();
            }
            if (cls.contains(cl)) continue;
            cls.add(cl);
        }
        return cls.toArray(new ClassLoader[cls.size()]);
    }

    public static String elide(String s, int n) {
        return Misc.elide(s, n, true);
    }

    public static String elide(String s, int n, boolean pad) {
        int ss;
        int sl;
        if (s == null) {
            s = "null";
        }
        if ((sl = s.length()) <= n) {
            return s + (pad ? blanks.substring(0, n - sl) : "");
        }
        int dl = 1;
        int ss2 = ss + ((ss = (n - dl) / 2) * 2 == n - dl ? 0 : 1);
        return s.substring(0, ss) + dots.substring(0, dl) + s.substring(sl - ss2);
    }

    public static StringBuilder indent(StringBuilder sb, int[] indent) {
        return Misc.indent(sb, indent[0]);
    }

    public static StringBuilder indent(StringBuilder sb, int indent) {
        if (!Misc.endsWithNl(sb) && indent > 0) {
            sb.append('\n');
        }
        return sb.append(blanks, 0, Math.min(blanks.length(), indent));
    }

    public static void addNlIfMissing(StringBuilder sb) {
        if (!Misc.endsWithNl(sb)) {
            sb.append('\n');
        }
    }

    public static void addNlIfMissing(StringBuffer sb) {
        if (!Misc.endsWithNl(sb)) {
            sb.append('\n');
        }
    }

    private static boolean endsWithNl(StringBuilder sb) {
        int l = sb.length();
        return l >= 1 && sb.charAt(l - 1) == '\n';
    }

    private static boolean endsWithNl(StringBuffer sb) {
        int l = sb.length();
        return l >= 1 && sb.charAt(l - 1) == '\n';
    }

    public static URL[] getURLs(String s) throws MalformedURLException, IOException, URISyntaxException {
        String[] spaths;
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String p : spaths = s.split(File.pathSeparator)) {
            Misc.addUrlsFromPath(p, urls);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static void addUrlsFromPath(String p, List<URL> urls) throws MalformedURLException, IOException, URISyntaxException {
        File pf;
        boolean mustBeDirectory = false;
        if (p.endsWith("*")) {
            if (p.length() < 2 || p.charAt(p.length() - 2) != File.separatorChar) {
                UIMAFramework.getLogger().error("Path Specification \"{}\" invalid.", p);
                throw new MalformedURLException();
            }
            p = p.substring(0, p.length() - 2);
            mustBeDirectory = true;
        }
        if ((pf = new File(p)).isDirectory()) {
            File[] jars = pf.listFiles(jarFilter);
            if (jars == null || jars.length == 0) {
                Misc.addPathToURLs(urls, pf);
            } else {
                for (File f : jars) {
                    Misc.addPathToURLs(urls, f);
                }
            }
        } else {
            if (mustBeDirectory) {
                UIMAFramework.getLogger().error("Path Specification \"{}\" must be a directory.", p);
                throw new MalformedURLException();
            }
            if (p.toLowerCase().endsWith(".jar")) {
                Misc.addPathToURLs(urls, pf);
            } else {
                UIMAFramework.getLogger().warn("Skipping adding \"{}\" to URLs because it is not a directory or a JAR", p);
            }
        }
    }

    private static void addPathToURLs(List<URL> urls, File cp) throws MalformedURLException {
        URL url = cp.toURI().toURL();
        urls.add(url);
    }

    public static URL[] classpath2urls(String classpath) {
        try {
            return Misc.getURLs(classpath);
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static String expandClasspath(String classpath) {
        StringBuilder sb = new StringBuilder();
        for (URL url : Misc.classpath2urls(classpath)) {
            sb.append(url.getPath());
            sb.append(File.pathSeparatorChar);
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static boolean getNoValueSystemProperty(String name) {
        return !System.getProperty(name, "false").equals("false");
    }

    public static <T> StringBuilder addElementsToStringBuilder(StringBuilder sb, Collection<T> c) {
        return Misc.addElementsToStringBuilder(sb, c, 1000);
    }

    public static <T> StringBuilder addElementsToStringBuilder(StringBuilder sb, Collection<T> c, int limit) {
        return Misc.addElementsToStringBuilder(sb, c, limit, StringBuilder::append);
    }

    public static <T> StringBuilder addElementsToStringBuilder(StringBuilder sb, Collection<T> c, BiConsumer<StringBuilder, T> appender) {
        return Misc.addElementsToStringBuilder(sb, c, 1000, appender);
    }

    public static <T> StringBuilder addElementsToStringBuilder(List<T> c, int limit) {
        return Misc.addElementsToStringBuilder(c, limit, StringBuilder::append);
    }

    public static <T> StringBuilder addElementsToStringBuilder(List<T> c, int limit, BiConsumer<StringBuilder, T> appender) {
        return Misc.addElementsToStringBuilder(INT0, c, limit, appender);
    }

    public static <T> StringBuilder addElementsToStringBuilder(int[] indent, List<T> c, int limit, BiConsumer<StringBuilder, T> appender) {
        if (c == null) {
            return Misc.indent(new StringBuilder(), indent).append("null");
        }
        int sz = Math.min(limit, c.size());
        StringBuilder sb = Misc.indent(new StringBuilder(sz * 5 + 2), indent);
        return Misc.addElementsToStringBuilder(indent, sb, c, limit, appender);
    }

    public static <T> StringBuilder addElementsToStringBuilder(StringBuilder sb, Collection<T> c, int limit, BiConsumer<StringBuilder, T> appender) {
        return Misc.addElementsToStringBuilder(INT0, sb, c, limit, appender);
    }

    public static <T> StringBuilder addElementsToStringBuilder(int[] indent, StringBuilder sb, Collection<T> c, int limit, BiConsumer<StringBuilder, T> appender) {
        int origLength = sb.length();
        if (c == null) {
            return sb.append("<null>");
        }
        if (c.size() == 0) {
            return sb.append("[]");
        }
        sb.append('[');
        int i = 0;
        boolean overLimit = false;
        for (T item : c) {
            if (i++ >= limit && limit >= 0) {
                overLimit = true;
                break;
            }
            appender.accept(sb, (StringBuilder)item);
            sb.append(", ");
            if (sb.length() - origLength <= 60) continue;
            sb.setLength(origLength);
            return Misc.style2(indent, sb, c, limit, appender);
        }
        if (overLimit) {
            sb.append(dots);
        } else {
            sb.setLength(sb.length() - 2);
        }
        sb.append(']');
        return sb;
    }

    public static StringBuilder addElementsToStringBuilder(StringBuilder sb, int size, int limit, int indent, int incr, BiConsumer<StringBuilder, Integer> appender) {
        int origLength = sb.length();
        if (size == 0) {
            return sb.append("[]");
        }
        sb.append('[');
        for (int i = 0; i < limit; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            appender.accept(sb, i);
            if (sb.length() - origLength <= 120) continue;
            sb.setLength(origLength);
            return Misc.style2(sb, size, limit, indent, incr, appender);
        }
        if (size > limit) {
            sb.append(dots);
        }
        sb.append(']');
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> StringBuilder style2(int[] indent, StringBuilder sb, Collection<T> c, int limit, BiConsumer<StringBuilder, T> appender) {
        sb.append("[");
        indent[0] = indent[0] + 2;
        Misc.indent(sb, indent);
        try {
            int i = 0;
            int cl = -1;
            boolean overLimit = false;
            for (T item : c) {
                if (i++ >= limit && limit >= 0) {
                    overLimit = true;
                    break;
                }
                appender.accept(sb, (StringBuilder)item);
                cl = sb.length();
                sb.append(",");
                Misc.indent(sb, indent);
            }
            if (overLimit) {
                sb.append(dots);
            } else {
                sb.setLength(cl);
            }
        }
        finally {
            indent[0] = indent[0] - 2;
            Misc.indent(sb, indent).append(']');
        }
        return sb;
    }

    private static <T> StringBuilder style2(StringBuilder sb, int size, int limit, int indent, int incr, BiConsumer<StringBuilder, Integer> appender) {
        sb.append("[");
        indent += incr;
        for (int i = 0; i < limit; ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append('\n');
            Misc.indent(sb, indent);
            appender.accept(sb, i);
        }
        if (size > limit) {
            sb.append(",\n");
            Misc.indent(sb, indent);
            sb.append(dots);
        }
        sb.append('\n');
        Misc.indent(sb, indent - incr);
        sb.append(']');
        return sb;
    }

    public static void toFile(ByteArrayOutputStream baos, String name) {
        try (FileOutputStream fos = new FileOutputStream(name);){
            baos.writeTo(fos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void toFile(ByteArrayOutputStream baos, File file) {
        try (FileOutputStream fos = new FileOutputStream(file);){
            baos.writeTo(fos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static int nextHigherPowerOf2(int i) {
        return i < 1 ? 1 : Integer.highestOneBit(i) << (Integer.bitCount(i) == 1 ? 0 : 1);
    }

    public static int nextHigherPowerOfX(int i, int x) {
        int shft = 31 - Integer.numberOfLeadingZeros(x);
        return i < 1 ? x : i + (x - 1) >>> shft << shft;
    }

    public static MethodHandle getProtectedMethodHandle(Class<?> clazz, MethodHandles.Lookup methodHandleAccessContext, String protectedMethod, Class<?> ... args) {
        try {
            Method m = clazz.getDeclaredMethod(protectedMethod, args);
            m.setAccessible(true);
            return methodHandleAccessContext.unreflect(m);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static MethodHandle getProtectedMethodHandle(Class<?> clazz, String protectedMethod, Class<?> ... args) {
        return Misc.getProtectedMethodHandle(clazz, UIMAlookup, protectedMethod, args);
    }

    public static MethodHandle getProtectedFieldGetter(Class<?> clazz, String protectedField) {
        try {
            Field f = clazz.getDeclaredField(protectedField);
            f.setAccessible(true);
            return UIMAlookup.unreflectGetter(f);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getStaticIntField(Class<?> clazz, String fieldName) {
        try {
            Field f = clazz.getField(fieldName);
            return f.getInt(null);
        }
        catch (NoSuchFieldException e) {
            return Integer.MIN_VALUE;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getStaticIntFieldNoInherit(Class<?> clazz, String fieldName) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            return f.getInt(null);
        }
        catch (NoSuchFieldException e) {
            return Integer.MIN_VALUE;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getPrivateStaticIntFieldNoInherit(Class<?> clazz, String fieldName) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.getInt(null);
        }
        catch (NoSuchFieldException e) {
            return Integer.MIN_VALUE;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addAll(Collection<String> c, String ... v) {
        for (String s : v) {
            c.add(s);
        }
    }

    public static void debug(Object o) {
        System.err.println("Debug: " + String.valueOf(o));
    }

    public static void assertUie(boolean v) {
        if (!v) {
            throw new UIMARuntimeException("INTERNAL_ERROR", new Object[0]);
        }
    }

    public static void assertUie(boolean v, Throwable e) {
        if (!v) {
            throw new UIMARuntimeException(e, "INTERNAL_ERROR", e);
        }
    }

    public static RuntimeException internalError() {
        Misc.assertUie(false);
        return null;
    }

    public static void internalError(Throwable e) {
        Misc.assertUie(false, e);
    }

    public static int hashInt(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        int h1 = 0x39C2AB57 ^ (k1 *= 461845907);
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }

    public static long hashStringLong(String s) {
        if (s == null) {
            return 0L;
        }
        int l = s.length();
        if (l == 0) {
            return 0L;
        }
        long c = 1L;
        for (int i = 0; i < l; ++i) {
            c = 31L * c + (long)s.charAt(i);
        }
        return c;
    }

    public static <T> T getWithExpand(List<T> a, int i) {
        while (i >= a.size()) {
            a.add(null);
        }
        return a.get(i);
    }

    public static <T> void setWithExpand(List<T> a, int i, T value) {
        while (i >= a.size()) {
            a.add(null);
        }
        a.set(i, value);
    }

    public static boolean equalStrings(String s1, String s2) {
        if (null == s1) {
            return null == s2;
        }
        return null == s2 ? false : s1.equals(s2);
    }

    public static int compareStrings(String s1, String s2) {
        if (null == s1) {
            if (null == s2) {
                return 0;
            }
            return -1;
        }
        return null == s2 ? 1 : s1.compareTo(s2);
    }

    public static String elideString(String s, int len) {
        if (s.length() <= len) {
            return s;
        }
        return s.substring(0, len) + dots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T shareExisting(T obj, WeakHashMap<T, WeakReference<T>> cache) {
        if (null == obj) {
            throw new IllegalArgumentException();
        }
        WeakHashMap<T, WeakReference<T>> weakHashMap = cache;
        synchronized (weakHashMap) {
            Object v;
            WeakReference<T> r = cache.get(obj);
            if (r == null || (v = r.get()) == null) {
                cache.put(obj, new WeakReference<T>(obj));
                return obj;
            }
            return v;
        }
    }

    public static <T> String ppList(List<T> items) {
        return Misc.ppList(items, 1000);
    }

    public static <T> String ppList(List<T> items, int max) {
        return Misc.addElementsToStringBuilder(items, max).toString();
    }

    public static <T> String ppList(List<T> items, int max, BiConsumer<StringBuilder, T> appender) {
        return Misc.addElementsToStringBuilder(items, max, appender).toString();
    }

    public static <T> String ppList(int[] indent, List<T> items) {
        return Misc.ppList(indent, items, 1000);
    }

    public static <T> String ppList(int[] indent, List<T> items, int max) {
        return Misc.addElementsToStringBuilder(items, max).toString();
    }

    public static <T> String ppList(int[] indent, List<T> items, int max, BiConsumer<StringBuilder, T> appender) {
        return Misc.addElementsToStringBuilder(items, max, appender).toString();
    }

    public static String typeName2ClassName(String typeName) {
        if (typeName.startsWith("uima.cas.")) {
            return "org.apache.uima.jcas.cas." + typeName.substring("uima.cas.".length());
        }
        if (typeName.startsWith("uima.tcas.")) {
            return "org.apache.uima.jcas.tcas." + typeName.substring("uima.tcas.".length());
        }
        return typeName;
    }

    public static String javaClassName2UimaTypeName(String className) {
        if (className.startsWith("org.apache.uima.jcas.cas.") && BuiltinTypeKinds.creatableBuiltinJCasClassNames.contains(className)) {
            return "uima.cas." + className.substring("org.apache.uima.jcas.cas.".length());
        }
        if (className.startsWith("org.apache.uima.jcas.tcas.") && BuiltinTypeKinds.creatableBuiltinJCasClassNames.contains(className)) {
            return "uima.tcas." + className.substring("org.apache.uima.jcas.tcas.".length());
        }
        switch (className) {
            case "boolean": {
                return "uima.cas.Boolean";
            }
            case "byte": {
                return "uima.cas.Byte";
            }
            case "short": {
                return "uima.cas.Short";
            }
            case "int": {
                return "uima.cas.Integer";
            }
            case "long": {
                return "uima.cas.Long";
            }
            case "float": {
                return "uima.cas.Float";
            }
            case "double": {
                return "uima.cas.Double";
            }
            case "java.lang.String": {
                return "uima.cas.String";
            }
        }
        return className;
    }

    public static void timeLoops(String title, int iterations, Runnable_withException r) throws Exception {
        long shortest = Long.MAX_VALUE;
        for (int i = 0; i < iterations; ++i) {
            long startTime = System.nanoTime();
            r.run();
            long time = (System.nanoTime() - startTime) / 1000L;
            if (time >= shortest) continue;
            shortest = time;
            System.out.format("%s: speed is %,d microseconds on iteration %,d%n", title, shortest, i);
        }
    }

    public static void sleep(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean maybeShrink(boolean secondTimeShrinkable, int size, int capacity, int factor, int minCapacity, IntConsumer realloc, Runnable reset) {
        if (size < capacity >> factor) {
            if (secondTimeShrinkable) {
                int newCapacity = Math.max(minCapacity, capacity >> 1);
                if (newCapacity < capacity) {
                    realloc.accept(newCapacity);
                } else {
                    reset.run();
                }
                return false;
            }
            reset.run();
            return true;
        }
        reset.run();
        return false;
    }

    public static boolean isJava9ea() {
        return isJava9ea;
    }

    public static String classNameFromByteCode(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        int temp = bb.getShort() & 0xFFFF;
        assert (51966 == temp);
        temp = bb.getShort() & 0xFFFF;
        assert (47806 == temp);
        bb.getInt();
        int constantPoolCount = (bb.getShort() & 0xFFFF) - 1;
        int[] classes = new int[constantPoolCount];
        String[] strings = new String[constantPoolCount];
        block6: for (int i = 0; i < constantPoolCount; ++i) {
            byte tagByte = bb.get();
            switch (tagByte) {
                case 7: {
                    classes[i] = bb.getShort() & 0xFFFF;
                    continue block6;
                }
                case 1: {
                    strings[i] = Misc.readModifiedUTF8(bb);
                    continue block6;
                }
                case 5: 
                case 6: {
                    bb.getLong();
                    ++i;
                    continue block6;
                }
                case 8: {
                    bb.getShort();
                    continue block6;
                }
                default: {
                    bb.getInt();
                }
            }
        }
        bb.getShort();
        int indexIntoConstantPoolOfClassInfo = (bb.getShort() & 0xFFFF) - 1;
        return strings[classes[indexIntoConstantPoolOfClassInfo] - 1];
    }

    private static String readModifiedUTF8(ByteBuffer bb) {
        int len = bb.getShort() & 0xFFFF;
        StringBuilder sb = new StringBuilder();
        while (len > 0) {
            int r;
            int c = bb.get() & 0xFF;
            if ((c & 0x80) == 0) {
                sb.append((char)c);
                --len;
                continue;
            }
            if ((c & 0x60) == 64) {
                r = (c & 0x1F) << 6;
                c = bb.get() & 0xFF;
                assert (128 == (c & 0xC0));
                sb.append((char)(r |= bb.get() & 0x3F));
                len -= 2;
                continue;
            }
            if ((c & 0xF0) == 224) {
                r = c & 0x3C0;
                c = bb.get() & 0xFF;
                assert (128 == (c & 0xC0));
                r = (r | c & 0x3F) << 6;
                c = bb.get() & 0xFF;
                assert (128 == (c & 0xC0));
                sb.append((char)(r |= c & 0x3F));
                len -= 3;
                continue;
            }
            Misc.internalError(new UnsupportedEncodingException());
        }
        return sb.toString();
    }

    public static <T> List<T> setAsList(final Set<T> set) {
        return new AbstractSequentialList<T>(){

            @Override
            public ListIterator<T> listIterator(int index) {
                final Iterator it = set.iterator();
                final int[] i = new int[]{0};
                return new ListIterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public T next() {
                        i[0] = i[0] + 1;
                        return it.next();
                    }

                    @Override
                    public int nextIndex() {
                        return i[0];
                    }

                    @Override
                    public void remove() {
                        it.remove();
                    }

                    @Override
                    public boolean hasPrevious() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public T previous() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public int previousIndex() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void set(T e) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void add(T e) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return set.size();
            }
        };
    }

    public static boolean contains(String[] strings, String item) {
        for (String string : strings) {
            if (!Misc.equalStrings(string, item)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(ClassLoader[] cls, ClassLoader cl) {
        for (ClassLoader item : cls) {
            if (item != cl) continue;
            return true;
        }
        return false;
    }

    public static void decreasingWithTrace(AtomicInteger errorCount, String message, Logger logger) {
        int c;
        int cTruncated;
        if (logger != null && (cTruncated = Integer.highestOneBit(c = errorCount.incrementAndGet())) == c) {
            if (logger.isLoggable(Level.FINE)) {
                try {
                    throw new Throwable();
                }
                catch (Throwable e) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(baos);
                    e.printStackTrace(ps);
                    message = "Message count: " + c + "; " + (String)message + " Message count indicates messages skipped to avoid potential flooding.\n" + baos.toString();
                    logger.log(Level.FINE, (String)message);
                }
            } else {
                message = "Message count: " + c + "; " + (String)message + " Message count indicates messages skipped to avoid potential flooding.";
                logger.log(Level.WARNING, (String)message);
            }
        }
    }

    public static void decreasingMessage(AtomicInteger errorCount, Supplier<String> messageSupplier, Consumer<String> publishMessage) {
        int c = errorCount.incrementAndGet();
        int cTruncated = Integer.highestOneBit(c);
        if (cTruncated == c) {
            String message = "Message count: " + c + "; " + messageSupplier.get() + " Message count indicates messages skipped to avoid potential flooding.";
            publishMessage.accept(message);
        }
    }
}

