/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IWrappedHeaderItem;
import org.apache.wicket.request.Response;

public class PriorityHeaderItem
extends HeaderItem
implements IWrappedHeaderItem {
    private final HeaderItem wrapped;

    public PriorityHeaderItem(HeaderItem wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public HeaderItem getWrapped() {
        return this.wrapped;
    }

    @Override
    public PriorityHeaderItem wrap(HeaderItem item) {
        return new PriorityHeaderItem(item);
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return this.getWrapped().getRenderTokens();
    }

    @Override
    public void render(Response response) {
        this.getWrapped().render(response);
    }

    @Override
    public List<HeaderItem> getDependencies() {
        ArrayList<PriorityHeaderItem> ret = new ArrayList<PriorityHeaderItem>();
        for (HeaderItem curDependency : this.getWrapped().getDependencies()) {
            ret.add(this.wrap(curDependency));
        }
        List<HeaderItem> dependencies = super.getDependencies();
        dependencies.addAll(ret);
        return dependencies;
    }

    @Override
    public Iterable<? extends HeaderItem> getProvidedResources() {
        return this.getWrapped().getProvidedResources();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriorityHeaderItem that = (PriorityHeaderItem)o;
        return Objects.equals(this.wrapped, that.wrapped);
    }

    public int hashCode() {
        return Objects.hash(this.wrapped);
    }

    public String toString() {
        return "PriorityHeaderItem(" + String.valueOf(this.getWrapped()) + ")";
    }
}

