/*
 * RunAsHandler.java
 *
 * Copyright (c) 2000 Sun Microsystems, Inc.
 * All right reserved, all wrongs reversed.
 */

package sunlabs.brazil.sunlabs;

import sunlabs.brazil.server.Handler;
import sunlabs.brazil.server.Request;
import sunlabs.brazil.server.Server;
import java.io.IOException;

/**
 * Handler for changing the group and owner of the server.
 * This handler expects the native library,
 * <code>sunlabs_brazil_sunlabs_RunAsHandler</code>
 * to be in the library path.
 * <p>
 * Properties:
 * <dl class=props>
 * <dt>user	<dd>name of the user to run as
 * <dt>group  <dd>The name of the group to run as
 * </dl>
 *
 * @author      Stephen Uhler
 * @version     @(#)RunAsHandler.java	2.2
 */

public class RunAsHandler implements Handler {

    public native static boolean setUser(String user);
    public native static boolean setGroup(String group);

    /**
     * set up the Unix user and group..
     */

    public boolean
    init(Server server, String prefix) {
	String user = server.props.getProperty(prefix + "user");
	String group = server.props.getProperty(prefix + "group");
	try {
	    System.loadLibrary("sunlabs_brazil_sunlabs_RunAsHandler");
	    if (group != null) {
	        if (setGroup(group)) {
		    server.log(Server.LOG_LOG, prefix, 
			"Setting server to run as group: " + group);
		} else {
		    server.log(Server.LOG_WARNING, prefix, 
			"Error setting server to run as group: " + group);
		}
	    }
	    if (user != null) {
	        if (setUser(user)) {
		    server.log(Server.LOG_LOG, prefix, 
			"Setting server to run as user: " + user);
		} else {
		    server.log(Server.LOG_WARNING, prefix, 
			"Error setting server to run as user: " + user);
		}
	    }
	} catch (UnsatisfiedLinkError e) {
	    server.log(Server.LOG_ERROR, prefix, 
		" Link Error: " + e.getMessage());
	    return false;
	}
	return true;
    }

    /**
     * Nothing to respond to.
     */

    public boolean
    respond(Request request) throws IOException {
	return false;
    }
}
