/*
 * Decompiled with CFR 0.152.
 */
package JLex;

import JLex.CDTrans;
import JLex.CSpec;
import JLex.CUtility;
import JLex.SparseBitSet;
import java.util.Vector;

class CMinimize {
    CSpec m_spec;
    Vector m_group;
    int[] m_ingroup;

    CMinimize() {
        this.reset();
    }

    private void col_copy(int n, int n2) {
        int n3 = this.m_spec.m_dtrans_vector.size();
        int n4 = 0;
        while (n4 < n3) {
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n4);
            cDTrans.m_dtrans[n] = cDTrans.m_dtrans[n2];
            ++n4;
        }
    }

    private boolean col_equiv(int n, int n2) {
        int n3 = this.m_spec.m_dtrans_vector.size();
        int n4 = 0;
        while (n4 < n3) {
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n4);
            if (cDTrans.m_dtrans[n] != cDTrans.m_dtrans[n2]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    private void fix_dtrans() {
        Vector<CDTrans> vector = new Vector<CDTrans>();
        int n = this.m_spec.m_state_dtrans.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.m_spec.m_state_dtrans[n2] != -1) {
                this.m_spec.m_state_dtrans[n2] = this.m_ingroup[this.m_spec.m_state_dtrans[n2]];
            }
            ++n2;
        }
        n = this.m_group.size();
        n2 = 0;
        while (n2 < n) {
            Vector vector2 = (Vector)this.m_group.elementAt(n2);
            CDTrans cDTrans = (CDTrans)vector2.elementAt(0);
            vector.addElement(cDTrans);
            int n3 = 0;
            while (n3 < this.m_spec.m_dtrans_ncols) {
                if (cDTrans.m_dtrans[n3] != -1) {
                    cDTrans.m_dtrans[n3] = this.m_ingroup[cDTrans.m_dtrans[n3]];
                }
                ++n3;
            }
            ++n2;
        }
        this.m_group = null;
        this.m_spec.m_dtrans_vector = vector;
    }

    private void init_groups() {
        this.m_group = new Vector();
        int n = 0;
        int n2 = this.m_spec.m_dtrans_vector.size();
        this.m_ingroup = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            Vector<CDTrans> vector;
            boolean bl = false;
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n3);
            CUtility.assert(n3 == cDTrans.m_label);
            CUtility.assert(!bl);
            CUtility.assert(n == this.m_group.size());
            int n4 = 0;
            while (n4 < n) {
                vector = (Vector<CDTrans>)this.m_group.elementAt(n4);
                CUtility.assert(!bl);
                CUtility.assert(vector.size() > 0);
                CDTrans cDTrans2 = (CDTrans)vector.elementAt(0);
                int n5 = vector.size();
                CUtility.assert(n5 > 0);
                int n6 = 1;
                while (n6 < n5) {
                    CDTrans cDTrans3 = (CDTrans)vector.elementAt(n6);
                    CUtility.assert(cDTrans3.m_accept == cDTrans2.m_accept);
                    ++n6;
                }
                if (cDTrans2.m_accept == cDTrans.m_accept) {
                    vector.addElement(cDTrans);
                    this.m_ingroup[n3] = n4;
                    bl = true;
                    CUtility.assert(n4 == this.m_ingroup[cDTrans.m_label]);
                    break;
                }
                ++n4;
            }
            if (!bl) {
                vector = new Vector<CDTrans>();
                vector.addElement(cDTrans);
                this.m_ingroup[n3] = this.m_group.size();
                this.m_group.addElement(vector);
                ++n;
            }
            ++n3;
        }
        boolean cfr_ignored_0 = this.m_spec.m_verbose;
        if (false) {
            System.out.println("Initial grouping:");
            this.pgroups();
            System.out.println();
        }
    }

    void min_dfa(CSpec cSpec) {
        this.set(cSpec);
        this.minimize();
        this.reduce();
        this.reset();
    }

    private void minimize() {
        this.init_groups();
        int n = this.m_group.size();
        int n2 = n - 1;
        while (n2 != n) {
            n2 = n;
            CUtility.assert(this.m_group.size() == n);
            int n3 = 0;
            while (n3 < n) {
                Vector vector = (Vector)this.m_group.elementAt(n3);
                int n4 = vector.size();
                if (n4 > 1) {
                    Vector<CDTrans> vector2 = new Vector<CDTrans>();
                    boolean bl = false;
                    CDTrans cDTrans = (CDTrans)vector.elementAt(0);
                    int n5 = 1;
                    while (n5 < n4) {
                        CDTrans cDTrans2 = (CDTrans)vector.elementAt(n5);
                        int n6 = 0;
                        while (n6 < this.m_spec.m_dtrans_ncols) {
                            int n7 = cDTrans.m_dtrans[n6];
                            int n8 = cDTrans2.m_dtrans[n6];
                            if (n7 != n8 && (n7 == -1 || n8 == -1 || this.m_ingroup[n8] != this.m_ingroup[n7])) {
                                CUtility.assert(vector.elementAt(n5) == cDTrans2);
                                vector.removeElementAt(n5);
                                --n5;
                                --n4;
                                vector2.addElement(cDTrans2);
                                if (!bl) {
                                    bl = true;
                                    ++n;
                                    this.m_group.addElement(vector2);
                                }
                                this.m_ingroup[cDTrans2.m_label] = this.m_group.size() - 1;
                                CUtility.assert(this.m_group.contains(vector2));
                                CUtility.assert(this.m_group.contains(vector));
                                CUtility.assert(vector.contains(cDTrans));
                                CUtility.assert(!vector.contains(cDTrans2));
                                CUtility.assert(!vector2.contains(cDTrans));
                                CUtility.assert(vector2.contains(cDTrans2));
                                CUtility.assert(vector.size() == n4);
                                CUtility.assert(n3 == this.m_ingroup[cDTrans.m_label]);
                                CUtility.assert(this.m_group.size() - 1 == this.m_ingroup[cDTrans2.m_label]);
                                break;
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
        }
        System.out.println(String.valueOf(this.m_group.size()) + " states after removal of redundant states.");
        boolean cfr_ignored_0 = this.m_spec.m_verbose;
        if (false) {
            System.out.println();
            System.out.println("States grouped as follows after minimization");
            this.pgroups();
        }
        this.fix_dtrans();
    }

    private void pgroups() {
        int n = this.m_group.size();
        int n2 = 0;
        while (n2 < n) {
            System.out.print("\tGroup " + n2 + " {");
            this.pset((Vector)this.m_group.elementAt(n2));
            System.out.println("}");
            System.out.println();
            ++n2;
        }
        System.out.println();
        int n3 = this.m_spec.m_dtrans_vector.size();
        n2 = 0;
        while (n2 < n3) {
            System.out.println("\tstate " + n2 + " is in group " + this.m_ingroup[n2]);
            ++n2;
        }
    }

    private void pset(Vector vector) {
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            CDTrans cDTrans = (CDTrans)vector.elementAt(n2);
            System.out.print(String.valueOf(cDTrans.m_label) + " ");
            ++n2;
        }
    }

    private void reduce() {
        int n;
        SparseBitSet sparseBitSet = new SparseBitSet();
        int n2 = this.m_spec.m_dtrans_vector.size();
        this.m_spec.m_anchor_array = new int[n2];
        this.m_spec.m_accept_vector = new Vector();
        int n3 = 0;
        while (n3 < n2) {
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n3);
            this.m_spec.m_accept_vector.addElement(cDTrans.m_accept);
            this.m_spec.m_anchor_array[n3] = cDTrans.m_anchor;
            cDTrans.m_accept = null;
            ++n3;
        }
        this.m_spec.m_col_map = new int[this.m_spec.m_dtrans_ncols];
        n3 = 0;
        while (n3 < this.m_spec.m_dtrans_ncols) {
            this.m_spec.m_col_map[n3] = -1;
            ++n3;
        }
        int n4 = 0;
        while (true) {
            n3 = 0;
            while (n3 < n4) {
                CUtility.assert(this.m_spec.m_col_map[n3] != -1);
                ++n3;
            }
            n3 = n4;
            while (n3 < this.m_spec.m_dtrans_ncols) {
                if (this.m_spec.m_col_map[n3] == -1) break;
                ++n3;
            }
            if (n3 >= this.m_spec.m_dtrans_ncols) break;
            CUtility.assert(!sparseBitSet.get(n3));
            CUtility.assert(this.m_spec.m_col_map[n3] == -1);
            sparseBitSet.set(n3);
            this.m_spec.m_col_map[n3] = n4;
            n = n3 + 1;
            while (n < this.m_spec.m_dtrans_ncols) {
                if (this.m_spec.m_col_map[n] == -1 && this.col_equiv(n3, n)) {
                    this.m_spec.m_col_map[n] = n4;
                }
                ++n;
            }
            ++n4;
        }
        int n5 = 0;
        n3 = 0;
        while (n3 < this.m_spec.m_dtrans_ncols) {
            if (sparseBitSet.get(n3)) {
                ++n5;
                sparseBitSet.clear(n3);
                n = this.m_spec.m_col_map[n3];
                CUtility.assert(n <= n3);
                if (n != n3) {
                    this.col_copy(n, n3);
                }
            }
            ++n3;
        }
        this.m_spec.m_dtrans_ncols = n4;
        this.trunc_col();
        CUtility.assert(n5 == n4);
        int n6 = this.m_spec.m_dtrans_vector.size();
        this.m_spec.m_row_map = new int[n6];
        n3 = 0;
        while (n3 < n6) {
            this.m_spec.m_row_map[n3] = -1;
            ++n3;
        }
        int n7 = 0;
        while (true) {
            n3 = 0;
            while (n3 < n7) {
                CUtility.assert(this.m_spec.m_row_map[n3] != -1);
                ++n3;
            }
            n3 = n7;
            while (n3 < n6) {
                if (this.m_spec.m_row_map[n3] == -1) break;
                ++n3;
            }
            if (n3 >= n6) break;
            CUtility.assert(!sparseBitSet.get(n3));
            CUtility.assert(this.m_spec.m_row_map[n3] == -1);
            sparseBitSet.set(n3);
            this.m_spec.m_row_map[n3] = n7;
            n = n3 + 1;
            while (n < n6) {
                if (this.m_spec.m_row_map[n] == -1 && this.row_equiv(n3, n)) {
                    this.m_spec.m_row_map[n] = n7;
                }
                ++n;
            }
            ++n7;
        }
        n5 = 0;
        n3 = 0;
        while (n3 < n6) {
            if (sparseBitSet.get(n3)) {
                ++n5;
                sparseBitSet.clear(n3);
                n = this.m_spec.m_row_map[n3];
                CUtility.assert(n <= n3);
                if (n != n3) {
                    this.row_copy(n, n3);
                }
            }
            ++n3;
        }
        this.m_spec.m_dtrans_vector.setSize(n7);
        CUtility.assert(n5 == n7);
    }

    private void reset() {
        this.m_spec = null;
        this.m_group = null;
        this.m_ingroup = null;
    }

    private void row_copy(int n, int n2) {
        CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n2);
        this.m_spec.m_dtrans_vector.setElementAt(cDTrans, n);
    }

    private boolean row_equiv(int n, int n2) {
        CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n);
        CDTrans cDTrans2 = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n2);
        int n3 = 0;
        while (n3 < this.m_spec.m_dtrans_ncols) {
            if (cDTrans.m_dtrans[n3] != cDTrans2.m_dtrans[n3]) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private void set(CSpec cSpec) {
        CUtility.assert(cSpec != null);
        this.m_spec = cSpec;
        this.m_group = null;
        this.m_ingroup = null;
    }

    private void trunc_col() {
        int n = this.m_spec.m_dtrans_vector.size();
        int n2 = 0;
        while (n2 < n) {
            int[] nArray = new int[this.m_spec.m_dtrans_ncols];
            CDTrans cDTrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(n2);
            System.arraycopy(cDTrans.m_dtrans, 0, nArray, 0, nArray.length);
            cDTrans.m_dtrans = nArray;
            ++n2;
        }
    }
}

