/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.memory;

import io.atomix.utils.memory.DirectMemoryAllocator;
import io.atomix.utils.memory.Memory;
import io.atomix.utils.memory.MemoryAllocator;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import sun.misc.Unsafe;

public class NativeMemory
implements Memory {
    static final Unsafe UNSAFE;
    private static final boolean UNALIGNED;
    static final boolean BIG_ENDIAN;
    private long address;
    private final int size;
    protected final MemoryAllocator allocator;

    public static NativeMemory allocate(int size) {
        return new DirectMemoryAllocator().allocate(size);
    }

    protected NativeMemory(long address, int size, MemoryAllocator<? extends NativeMemory> allocator) {
        if (allocator == null) {
            throw new NullPointerException("allocator cannot be null");
        }
        this.address = address;
        this.size = size;
        this.allocator = allocator;
    }

    @Override
    public MemoryAllocator<NativeMemory> allocator() {
        return this.allocator;
    }

    @Override
    public final long address() {
        return this.address;
    }

    @Override
    public final long address(int offset) {
        return this.address + (long)offset;
    }

    private long address(int offset, int b) {
        return this.address + (long)offset + (long)b;
    }

    @Override
    public int size() {
        return this.size;
    }

    public final Unsafe unsafe() {
        return UNSAFE;
    }

    @Override
    public NativeMemory copy() {
        NativeMemory memory = (NativeMemory)this.allocator.allocate(this.size);
        UNSAFE.copyMemory(this.address, memory.address, this.size);
        return memory;
    }

    @Override
    public byte getByte(int offset) {
        return UNSAFE.getByte(this.address(offset));
    }

    private byte getByte(int offset, int pos) {
        return UNSAFE.getByte(this.address(offset, pos));
    }

    @Override
    public char getChar(int offset) {
        if (UNALIGNED) {
            return UNSAFE.getChar(this.address(offset));
        }
        if (BIG_ENDIAN) {
            return (char)(this.getByte(offset) << 8 | this.getByte(offset, 1) & 0xFF);
        }
        return (char)(this.getByte(offset, 1) << 8 | this.getByte(offset) & 0xFF);
    }

    @Override
    public short getShort(int offset) {
        if (UNALIGNED) {
            return UNSAFE.getShort(this.address(offset));
        }
        if (BIG_ENDIAN) {
            return (short)(this.getByte(offset) << 8 | this.getByte(offset, 1) & 0xFF);
        }
        return (short)(this.getByte(offset, 1) << 8 | this.getByte(offset) & 0xFF);
    }

    @Override
    public int getInt(int offset) {
        if (UNALIGNED) {
            return UNSAFE.getInt(this.address(offset));
        }
        if (BIG_ENDIAN) {
            return this.getByte(offset, 0) << 24 | (this.getByte(offset, 1) & 0xFF) << 16 | (this.getByte(offset, 2) & 0xFF) << 8 | this.getByte(offset, 3) & 0xFF;
        }
        return this.getByte(offset, 3) << 24 | (this.getByte(offset, 2) & 0xFF) << 16 | (this.getByte(offset, 1) & 0xFF) << 8 | this.getByte(offset, 0) & 0xFF;
    }

    @Override
    public long getLong(int offset) {
        if (UNALIGNED) {
            return UNSAFE.getLong(this.address(offset));
        }
        if (BIG_ENDIAN) {
            return (long)this.getByte(offset) << 56 | ((long)this.getByte(offset, 1) & 0xFFL) << 48 | ((long)this.getByte(offset, 2) & 0xFFL) << 40 | ((long)this.getByte(offset, 3) & 0xFFL) << 32 | ((long)this.getByte(offset, 4) & 0xFFL) << 24 | ((long)this.getByte(offset, 5) & 0xFFL) << 16 | ((long)this.getByte(offset, 6) & 0xFFL) << 8 | (long)this.getByte(offset, 7) & 0xFFL;
        }
        return (long)this.getByte(offset, 7) << 56 | ((long)this.getByte(offset, 6) & 0xFFL) << 48 | ((long)this.getByte(offset, 5) & 0xFFL) << 40 | ((long)this.getByte(offset, 4) & 0xFFL) << 32 | ((long)this.getByte(offset, 3) & 0xFFL) << 24 | ((long)this.getByte(offset, 2) & 0xFFL) << 16 | ((long)this.getByte(offset, 1) & 0xFFL) << 8 | (long)this.getByte(offset) & 0xFFL;
    }

    @Override
    public float getFloat(int offset) {
        return Float.intBitsToFloat(this.getInt(offset));
    }

    @Override
    public double getDouble(int offset) {
        return Double.longBitsToDouble(this.getLong(offset));
    }

    @Override
    public void putByte(int offset, byte b) {
        UNSAFE.putByte(this.address(offset), b);
    }

    private void putByte(int offset, int pos, byte b) {
        UNSAFE.putByte(this.address(offset, pos), b);
    }

    @Override
    public void putChar(int offset, char c) {
        if (UNALIGNED) {
            UNSAFE.putChar(offset, c);
        } else if (BIG_ENDIAN) {
            this.putByte(offset, (byte)(c >>> 8));
            this.putByte(offset, 1, (byte)c);
        } else {
            this.putByte(offset, 1, (byte)(c >>> 8));
            this.putByte(offset, (byte)c);
        }
    }

    @Override
    public void putShort(int offset, short s) {
        if (UNALIGNED) {
            UNSAFE.putShort(this.address(offset), s);
        } else if (BIG_ENDIAN) {
            this.putByte(offset, (byte)(s >>> 8));
            this.putByte(offset, 1, (byte)s);
        } else {
            this.putByte(offset, 1, (byte)(s >>> 8));
            this.putByte(offset, (byte)s);
        }
    }

    @Override
    public void putInt(int offset, int i) {
        if (UNALIGNED) {
            UNSAFE.putInt(this.address(offset), i);
        } else if (BIG_ENDIAN) {
            this.putByte(offset, (byte)(i >>> 24));
            this.putByte(offset, 1, (byte)(i >>> 16));
            this.putByte(offset, 2, (byte)(i >>> 8));
            this.putByte(offset, 3, (byte)i);
        } else {
            this.putByte(offset, 3, (byte)(i >>> 24));
            this.putByte(offset, 2, (byte)(i >>> 16));
            this.putByte(offset, 1, (byte)(i >>> 8));
            this.putByte(offset, (byte)i);
        }
    }

    @Override
    public void putLong(int offset, long l) {
        if (UNALIGNED) {
            UNSAFE.putLong(this.address(offset), l);
        } else if (BIG_ENDIAN) {
            this.putByte(offset, (byte)(l >>> 56));
            this.putByte(offset, 1, (byte)(l >>> 48));
            this.putByte(offset, 2, (byte)(l >>> 40));
            this.putByte(offset, 3, (byte)(l >>> 32));
            this.putByte(offset, 4, (byte)(l >>> 24));
            this.putByte(offset, 5, (byte)(l >>> 16));
            this.putByte(offset, 6, (byte)(l >>> 8));
            this.putByte(offset, 7, (byte)l);
        } else {
            this.putByte(offset, 7, (byte)(l >>> 56));
            this.putByte(offset, 6, (byte)(l >>> 48));
            this.putByte(offset, 5, (byte)(l >>> 40));
            this.putByte(offset, 4, (byte)(l >>> 32));
            this.putByte(offset, 3, (byte)(l >>> 24));
            this.putByte(offset, 2, (byte)(l >>> 16));
            this.putByte(offset, 1, (byte)(l >>> 8));
            this.putByte(offset, (byte)l);
        }
    }

    @Override
    public void putFloat(int offset, float f) {
        this.putInt(offset, Float.floatToRawIntBits(f));
    }

    @Override
    public void putDouble(int offset, double d) {
        this.putLong(offset, Double.doubleToRawLongBits(d));
    }

    @Override
    public void clear() {
        UNSAFE.setMemory(this.address, this.size, (byte)0);
    }

    @Override
    public void free() {
        if (this.address != 0L) {
            UNSAFE.freeMemory(this.address);
            this.address = 0L;
        }
    }

    static {
        boolean unaligned;
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            UNSAFE = (Unsafe)unsafeField.get(null);
        }
        catch (Exception e) {
            throw new AssertionError();
        }
        try {
            Class<?> bitsClass = Class.forName("java.nio.Bits", false, ClassLoader.getSystemClassLoader());
            Method unalignedMethod = bitsClass.getDeclaredMethod("unaligned", new Class[0]);
            unalignedMethod.setAccessible(true);
            unaligned = Boolean.TRUE.equals(unalignedMethod.invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            unaligned = false;
        }
        UNALIGNED = unaligned;
    }
}

