/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.net;

import com.google.common.collect.Maps;
import io.atomix.utils.net.MalformedAddressException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;

public final class Address {
    private static final int DEFAULT_PORT = 5679;
    private static final Map<Pair<String, Integer>, Address> addressCache = Maps.newConcurrentMap();
    private static final Map<Address, String> toStringCache = Maps.newConcurrentMap();
    private final String host;
    private final int port;
    private final InetAddress address;
    private final Type type;

    public static Address local() {
        return Address.from(5679);
    }

    private static Address cached(Pair<String, Integer> addressPair, Supplier<Address> factory) {
        Address address = addressCache.get(addressPair);
        if (address == null) {
            address = addressCache.computeIfAbsent(addressPair, pair -> (Address)factory.get());
        }
        return address;
    }

    public static Address from(String address) {
        return Address.cached((Pair<String, Integer>)Pair.of((Object)address, null), () -> {
            int port;
            int lastColon = address.lastIndexOf(58);
            int openBracket = address.indexOf(91);
            int closeBracket = address.indexOf(93);
            String host = openBracket != -1 && closeBracket != -1 ? address.substring(openBracket + 1, closeBracket) : (lastColon != -1 ? address.substring(0, lastColon) : address);
            if (lastColon != -1) {
                try {
                    port = Integer.parseInt(address.substring(lastColon + 1));
                }
                catch (NumberFormatException e) {
                    throw new MalformedAddressException(address, e);
                }
            } else {
                port = 5679;
            }
            try {
                return new Address(host, port, InetAddress.getByName(host));
            }
            catch (UnknownHostException e) {
                throw new MalformedAddressException(address, e);
            }
        });
    }

    public static Address from(String host, int port) {
        return Address.cached((Pair<String, Integer>)Pair.of((Object)host, (Object)port), () -> {
            try {
                return new Address(host, port, InetAddress.getByName(host));
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Failed to locate host", e);
            }
        });
    }

    public static Address from(int port) {
        return Address.cached((Pair<String, Integer>)Pair.of(null, (Object)port), () -> {
            try {
                InetAddress address = Address.getLocalAddress();
                return new Address(address.getHostName(), port, address);
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException("Failed to locate host", e);
            }
        });
    }

    private static InetAddress getLocalAddress() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception ignore) {
            return InetAddress.getByName(null);
        }
    }

    public Address(String host, int port, InetAddress address) {
        this.host = host;
        this.port = port;
        this.address = address;
        this.type = address instanceof Inet4Address ? Type.IPV4 : Type.IPV6;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public InetAddress address() {
        return this.address;
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        String toString = toStringCache.get(this);
        if (toString == null) {
            toString = toStringCache.computeIfAbsent(this, a -> {
                switch (this.type) {
                    case IPV4: {
                        return String.format("%s:%d", this.address().getHostName(), this.port());
                    }
                    case IPV6: {
                        return String.format("[%s]:%d", this.address().getHostName(), this.port());
                    }
                }
                throw new AssertionError();
            });
        }
        return toString;
    }

    public int hashCode() {
        return Objects.hash(this.address, this.port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Address that = (Address)obj;
        return this.port == that.port && Objects.equals(this.address, that.address);
    }

    public static enum Type {
        IPV4,
        IPV6;

    }
}

