/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ipv6;

import com.googlecode.ipv6.BitSetHelpers;
import com.googlecode.ipv6.IPv6Address;
import java.io.Serializable;
import java.util.BitSet;

public final class IPv6NetworkMask
implements Serializable {
    private final int prefixLength;

    IPv6NetworkMask(int prefixLength) {
        if (prefixLength < 0 || prefixLength > 128) {
            throw new IllegalArgumentException("prefix length should be in interval [0, 128]");
        }
        this.prefixLength = prefixLength;
    }

    public static IPv6NetworkMask fromAddress(IPv6Address iPv6Address) {
        IPv6NetworkMask.validateNetworkMask(iPv6Address);
        return new IPv6NetworkMask(iPv6Address.numberOfLeadingOnes());
    }

    public static IPv6NetworkMask fromPrefixLength(int prefixLength) {
        return new IPv6NetworkMask(prefixLength);
    }

    private static void validateNetworkMask(IPv6Address addressToValidate) {
        BitSet addressAsBitSet = BitSetHelpers.bitSetOf(addressToValidate.getLowBits(), addressToValidate.getHighBits());
        boolean firstZeroFound = false;
        for (int i = 127; i >= 0 && !firstZeroFound; --i) {
            if (addressAsBitSet.get(i)) continue;
            firstZeroFound = true;
            for (int j = i - 1; j >= 0; --j) {
                if (!addressAsBitSet.get(j)) continue;
                throw new IllegalArgumentException(addressToValidate + " is not a valid network mask");
            }
        }
    }

    public int asPrefixLength() {
        return this.prefixLength;
    }

    public IPv6Address asAddress() {
        if (this.prefixLength == 128) {
            return new IPv6Address(-1L, -1L);
        }
        if (this.prefixLength == 64) {
            return new IPv6Address(-1L, 0L);
        }
        if (this.prefixLength > 64) {
            int remainingPrefixLength = this.prefixLength - 64;
            return new IPv6Address(-1L, -1L << 64 - remainingPrefixLength);
        }
        if (this.prefixLength == 0) {
            return new IPv6Address(0L, 0L);
        }
        return new IPv6Address(-1L << 64 - this.prefixLength, 0L);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IPv6NetworkMask that = (IPv6NetworkMask)o;
        return this.prefixLength == that.prefixLength;
    }

    public int hashCode() {
        return this.prefixLength;
    }

    public String toString() {
        return "" + this.prefixLength;
    }
}

