/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import com.google.gson.Gson;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.zeppelin.annotation.Experimental;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.helium.HeliumType;
import org.apache.zeppelin.helium.SpellPackageInfo;

@Experimental
public class HeliumPackage
implements JsonSerializable {
    private static final Gson gson = new Gson();
    private HeliumType type;
    private String name;
    private String description;
    private String artifact;
    private String className;
    private String[][] resources;
    private String license;
    private String icon;
    private String published;
    private String groupId;
    private String artifactId;
    private SpellPackageInfo spell;
    private Map<String, Object> config;

    private HeliumPackage(HeliumType type, String name, String description, String artifact, String className, String[][] resources, String license, String icon) {
        this.type = type;
        this.name = name;
        this.description = description;
        this.artifact = artifact;
        this.className = className;
        this.resources = resources;
        this.license = license;
        this.icon = icon;
    }

    public int hashCode() {
        return (this.type.toString() + this.artifact + this.className).hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof HeliumPackage)) {
            return false;
        }
        HeliumPackage info = (HeliumPackage)o;
        return this.type == info.type && this.artifact.equals(info.artifact) && this.className.equals(info.className);
    }

    public HeliumType getType() {
        return this.type;
    }

    public static boolean isBundleType(HeliumType type) {
        return type == HeliumType.VISUALIZATION || type == HeliumType.SPELL;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getClassName() {
        return this.className;
    }

    public String[][] getResources() {
        return this.resources;
    }

    public String getLicense() {
        return this.license;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getPublishedDate() {
        return this.published;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public SpellPackageInfo getSpellInfo() {
        return this.spell;
    }

    public Map<String, Object> getConfig() {
        return this.config;
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static HeliumPackage fromJson(String json) {
        return HeliumPackage.preventXss((HeliumPackage)gson.fromJson(json, HeliumPackage.class));
    }

    public static HeliumPackage newHeliumPackage(HeliumType type, String name, String description, String artifact, String className, String[][] resources, String license, String icon) {
        return HeliumPackage.preventXss(new HeliumPackage(type, name, description, artifact, className, resources, license, icon));
    }

    private static HeliumPackage preventXss(HeliumPackage heliumPackage) {
        heliumPackage.name = StringEscapeUtils.escapeHtml4((String)heliumPackage.name);
        heliumPackage.description = StringEscapeUtils.escapeHtml4((String)heliumPackage.description);
        heliumPackage.artifact = StringEscapeUtils.escapeHtml4((String)heliumPackage.artifact);
        heliumPackage.className = StringEscapeUtils.escapeHtml4((String)heliumPackage.className);
        heliumPackage.resources = Optional.ofNullable(heliumPackage.getResources()).map(r -> (String[][])Arrays.stream(r).map(resource -> (String[])Arrays.stream(resource).map(StringEscapeUtils::escapeHtml4).toArray(String[]::new)).toArray(x$0 -> new String[x$0][])).orElse(null);
        heliumPackage.license = StringEscapeUtils.escapeHtml4((String)heliumPackage.license);
        heliumPackage.published = StringEscapeUtils.escapeHtml4((String)heliumPackage.published);
        heliumPackage.groupId = StringEscapeUtils.escapeHtml4((String)heliumPackage.groupId);
        heliumPackage.artifactId = StringEscapeUtils.escapeHtml4((String)heliumPackage.artifactId);
        heliumPackage.spell = Optional.ofNullable(heliumPackage.getSpellInfo()).map(spellPackageInfo -> new SpellPackageInfo(StringEscapeUtils.escapeHtml4((String)spellPackageInfo.getMagic()), StringEscapeUtils.escapeHtml4((String)spellPackageInfo.getUsage()))).orElse(null);
        return heliumPackage;
    }
}

